/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.NodeDetails;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.ha.ConfUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerAdminProtocolProtos;

public final class OMNodeDetails
extends NodeDetails {
    private int rpcPort;
    private boolean isDecommissioned = false;

    private OMNodeDetails(String serviceId, String nodeId, InetSocketAddress rpcAddr, int rpcPort, int ratisPort, String httpAddress, String httpsAddress) {
        super(serviceId, nodeId, rpcAddr, ratisPort, httpAddress, httpsAddress);
        this.rpcPort = rpcPort;
    }

    private OMNodeDetails(String serviceId, String nodeId, String hostAddr, int rpcPort, int ratisPort, String httpAddress, String httpsAddress) {
        super(serviceId, nodeId, hostAddr, rpcPort, ratisPort, httpAddress, httpsAddress);
        this.rpcPort = rpcPort;
    }

    public void setDecommissioningState() {
        this.isDecommissioned = true;
    }

    public boolean isDecommissioned() {
        return this.isDecommissioned;
    }

    public String toString() {
        return "OMNodeDetails[omServiceId=" + this.getServiceId() + ", omNodeId=" + this.getNodeId() + ", rpcAddress=" + this.getRpcAddressString() + ", rpcPort=" + this.getRpcPort() + ", ratisPort=" + this.getRatisPort() + ", httpAddress=" + this.getHttpAddress() + ", httpsAddress=" + this.getHttpsAddress() + "]";
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public String getOMDBCheckpointEnpointUrl(boolean isHttpPolicy) {
        if (isHttpPolicy) {
            if (StringUtils.isNotEmpty((CharSequence)this.getHttpAddress())) {
                return "http://" + this.getHttpAddress() + "/dbCheckpoint" + "?" + "flushBeforeCheckpoint" + "=true";
            }
        } else if (StringUtils.isNotEmpty((CharSequence)this.getHttpsAddress())) {
            return "https://" + this.getHttpsAddress() + "/dbCheckpoint" + "?" + "flushBeforeCheckpoint" + "=true";
        }
        return null;
    }

    public String getOMPrintInfo() {
        return this.getNodeId() + "[" + this.getHostAddress() + ":" + this.getRpcPort() + "]";
    }

    public static String getOMNodeAddressFromConf(OzoneConfiguration conf, String omServiceId, String omNodeId) {
        String rpcAddrKey = ConfUtils.addKeySuffixes((String)"ozone.om.address", (String[])new String[]{omServiceId, omNodeId});
        return OmUtils.getOmRpcAddress((ConfigurationSource)conf, rpcAddrKey);
    }

    public static OMNodeDetails getOMNodeDetailsFromConf(OzoneConfiguration conf, String omServiceId, String omNodeId) throws IOException {
        InetSocketAddress omRpcAddress;
        String rpcAddrStr = OMNodeDetails.getOMNodeAddressFromConf(conf, omServiceId, omNodeId);
        if (rpcAddrStr == null || rpcAddrStr.isEmpty()) {
            return null;
        }
        try {
            omRpcAddress = NetUtils.createSocketAddr((String)rpcAddrStr);
        }
        catch (Exception e) {
            throw new IOException("Couldn't create socket address for OM " + omNodeId + " at " + rpcAddrStr, e);
        }
        String ratisPortKey = ConfUtils.addKeySuffixes((String)"ozone.om.ratis.port", (String[])new String[]{omServiceId, omNodeId});
        int ratisPort = conf.getInt(ratisPortKey, 9872);
        String httpAddr = OmUtils.getHttpAddressForOMPeerNode((ConfigurationSource)conf, omServiceId, omNodeId, omRpcAddress.getHostName());
        String httpsAddr = OmUtils.getHttpsAddressForOMPeerNode((ConfigurationSource)conf, omServiceId, omNodeId, omRpcAddress.getHostName());
        return new Builder().setOMNodeId(omNodeId).setRatisPort(ratisPort).setHttpAddress(httpAddr).setHttpsAddress(httpsAddr).setOMServiceId(omServiceId).setRpcAddress(omRpcAddress).build();
    }

    public OzoneManagerAdminProtocolProtos.OMNodeInfo getProtobuf() {
        return OzoneManagerAdminProtocolProtos.OMNodeInfo.newBuilder().setNodeID(this.getNodeId()).setHostAddress(this.getHostAddress()).setRpcPort(this.getRpcPort()).setRatisPort(this.getRatisPort()).setNodeState(this.isDecommissioned ? OzoneManagerAdminProtocolProtos.NodeState.DECOMMISSIONED : OzoneManagerAdminProtocolProtos.NodeState.ACTIVE).build();
    }

    public static OMNodeDetails getFromProtobuf(OzoneManagerAdminProtocolProtos.OMNodeInfo omNodeInfo) {
        OMNodeDetails nodeDetails = new Builder().setOMNodeId(omNodeInfo.getNodeID()).setHostAddress(omNodeInfo.getHostAddress()).setRpcPort(omNodeInfo.getRpcPort()).setRatisPort(omNodeInfo.getRatisPort()).build();
        if (omNodeInfo.hasNodeState() && omNodeInfo.getNodeState().equals((Object)OzoneManagerAdminProtocolProtos.NodeState.DECOMMISSIONED)) {
            nodeDetails.setDecommissioningState();
        }
        return nodeDetails;
    }

    public static class Builder {
        private String omServiceId;
        private String omNodeId;
        private String hostAddress;
        private InetSocketAddress rpcAddress;
        private int rpcPort;
        private int ratisPort;
        private String httpAddr;
        private String httpsAddr;

        public Builder setHostAddress(String hostName) {
            this.hostAddress = hostName;
            return this;
        }

        public Builder setRpcAddress(InetSocketAddress rpcAddr) {
            this.rpcAddress = rpcAddr;
            this.rpcPort = this.rpcAddress.getPort();
            return this;
        }

        public Builder setRatisAddress(InetSocketAddress ratisAddr) {
            this.hostAddress = ratisAddr.getHostName();
            this.ratisPort = ratisAddr.getPort();
            return this;
        }

        public Builder setRpcPort(int port) {
            this.rpcPort = port;
            return this;
        }

        public Builder setRatisPort(int port) {
            this.ratisPort = port;
            return this;
        }

        public Builder setOMServiceId(String serviceId) {
            this.omServiceId = serviceId;
            return this;
        }

        public Builder setOMNodeId(String nodeId) {
            this.omNodeId = nodeId;
            return this;
        }

        public Builder setHttpAddress(String httpAddress) {
            this.httpAddr = httpAddress;
            return this;
        }

        public Builder setHttpsAddress(String httpsAddress) {
            this.httpsAddr = httpsAddress;
            return this;
        }

        public OMNodeDetails build() {
            if (this.rpcAddress != null) {
                return new OMNodeDetails(this.omServiceId, this.omNodeId, this.rpcAddress, this.rpcPort, this.ratisPort, this.httpAddr, this.httpsAddr);
            }
            return new OMNodeDetails(this.omServiceId, this.omNodeId, this.hostAddress, this.rpcPort, this.ratisPort, this.httpAddr, this.httpsAddr);
        }
    }
}

