/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.IOException;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.util.CheckedRunnable;
import org.apache.hadoop.util.CheckedSupplier;
import org.apache.hadoop.util.Time;

public final class MetricUtil {
    private MetricUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends IOException> T captureLatencyNs(MutableRate metric, CheckedSupplier<T, E> block) throws E {
        long start = Time.monotonicNowNanos();
        try {
            T t = block.get();
            return t;
        }
        finally {
            metric.add(Time.monotonicNowNanos() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends IOException> void captureLatencyNs(MutableRate metric, CheckedRunnable<E> block) throws IOException {
        long start = Time.monotonicNowNanos();
        try {
            block.run();
        }
        finally {
            metric.add(Time.monotonicNowNanos() - start);
        }
    }
}

