/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;

public final class CacheMetrics
implements MetricsSource {
    public static final String SOURCE_NAME = CacheMetrics.class.getSimpleName();
    public static final String NAME = CacheMetrics.class.getSimpleName();
    private final Cache<?, ?> cache;
    private final String name;

    private CacheMetrics(Cache<?, ?> cache, String name) {
        this.cache = cache;
        this.name = name;
    }

    public static CacheMetrics create(Cache<?, ?> cache, String name) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (CacheMetrics)ms.register(NAME, "Cache Metrics", (Object)new CacheMetrics(cache, name));
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder recordBuilder = collector.addRecord(SOURCE_NAME).setContext("Cache metrics").tag((MetricsInfo)CacheMetricsInfo.CacheName, this.name);
        CacheStats stats = this.cache.stats();
        recordBuilder.addGauge((MetricsInfo)CacheMetricsInfo.Size, this.cache.size()).addGauge((MetricsInfo)CacheMetricsInfo.HitCount, stats.hitCount()).addGauge((MetricsInfo)CacheMetricsInfo.HitRate, stats.hitRate()).addGauge((MetricsInfo)CacheMetricsInfo.MissCount, stats.missCount()).addGauge((MetricsInfo)CacheMetricsInfo.MissRate, stats.missRate()).addGauge((MetricsInfo)CacheMetricsInfo.LoadExceptionCount, stats.loadExceptionCount()).addGauge((MetricsInfo)CacheMetricsInfo.LoadSuccessCount, stats.loadSuccessCount()).addGauge((MetricsInfo)CacheMetricsInfo.EvictionCount, stats.evictionCount());
    }

    public void unregister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(NAME);
    }

    static enum CacheMetricsInfo implements MetricsInfo
    {
        CacheName("Cache Metrics."),
        Size("Size of the cache."),
        HitCount("Number of time the lookup methods return a cached value."),
        HitRate("Ratio of cache requests which were hit."),
        MissCount("Number of times the requested value is not in the cache."),
        MissRate("Ratio of cache requests which were missed."),
        LoadSuccessCount("Number of times the cache successfully load new values"),
        LoadExceptionCount("Number of times the cache encounters exception loading new values."),
        EvictionCount("Number of values which were evicted.");

        private final String desc;

        private CacheMetricsInfo(String desc) {
            this.desc = desc;
        }

        public String description() {
            return this.desc;
        }
    }
}

