/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;

public class ChunkBufferImplWithByteBufferList
implements ChunkBuffer {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final List<ByteBuffer> buffers;
    private final int limit;
    private int limitPrecedingCurrent;
    private int currentIndex;

    ChunkBufferImplWithByteBufferList(List<ByteBuffer> buffers) {
        Preconditions.checkArgument((buffers != null ? 1 : 0) != 0, (Object)"buffer == null");
        this.buffers = !buffers.isEmpty() ? ImmutableList.copyOf(buffers) : ImmutableList.of((Object)EMPTY_BUFFER);
        this.limit = buffers.stream().mapToInt(Buffer::limit).sum();
        this.findCurrent();
    }

    private void findCurrent() {
        boolean found = false;
        for (int i = 0; i < this.buffers.size(); ++i) {
            ByteBuffer buf = this.buffers.get(i);
            int pos = buf.position();
            if (found) {
                Preconditions.checkArgument((pos == 0 ? 1 : 0) != 0, (Object)"all buffers after current one should have position=0");
                continue;
            }
            if (pos < buf.limit()) {
                found = true;
                this.currentIndex = i;
                continue;
            }
            this.limitPrecedingCurrent += buf.limit();
        }
        if (!found) {
            this.currentIndex = this.buffers.size() - 1;
            this.limitPrecedingCurrent -= this.current().limit();
        }
    }

    private ByteBuffer current() {
        return this.buffers.get(this.currentIndex);
    }

    private void advanceCurrent() {
        ByteBuffer current;
        if (this.currentIndex < this.buffers.size() - 1 && !(current = this.buffers.get(this.currentIndex)).hasRemaining()) {
            ++this.currentIndex;
            this.limitPrecedingCurrent += current.limit();
        }
    }

    private void rewindCurrent() {
        this.currentIndex = 0;
        this.limitPrecedingCurrent = 0;
    }

    @Override
    public int position() {
        return this.limitPrecedingCurrent + this.current().position();
    }

    @Override
    public int remaining() {
        return this.limit - this.position();
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public boolean hasRemaining() {
        return this.position() < this.limit;
    }

    @Override
    public ChunkBuffer rewind() {
        this.buffers.forEach(Buffer::rewind);
        this.rewindCurrent();
        return this;
    }

    @Override
    public ChunkBuffer clear() {
        this.buffers.forEach(Buffer::clear);
        this.rewindCurrent();
        return this;
    }

    @Override
    public ChunkBuffer put(ByteBuffer that) {
        int thisRemaining = this.remaining();
        int thatRemaining = that.remaining();
        if (thatRemaining > thisRemaining) {
            BufferOverflowException boe = new BufferOverflowException();
            boe.initCause(new IllegalArgumentException("Failed to put since that.remaining() = " + thatRemaining + " > this.remaining() = " + thisRemaining));
            throw boe;
        }
        while (thatRemaining > 0) {
            ByteBuffer b = this.current();
            int bytes = Math.min(b.remaining(), thatRemaining);
            that.limit(that.position() + bytes);
            b.put(that);
            thatRemaining -= bytes;
            this.advanceCurrent();
        }
        return this;
    }

    @Override
    public ChunkBuffer duplicate(int newPosition, int newLimit) {
        Preconditions.checkArgument((newPosition >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((newPosition <= newLimit ? 1 : 0) != 0);
        Preconditions.checkArgument((newLimit <= this.limit() ? 1 : 0) != 0);
        ArrayList<ByteBuffer> duplicates = new ArrayList<ByteBuffer>(this.buffers.size());
        int min = 0;
        for (ByteBuffer buf : this.buffers) {
            int max = min + buf.limit();
            int pos = ChunkBufferImplWithByteBufferList.relativeToRange(newPosition, min, max);
            int lim = ChunkBufferImplWithByteBufferList.relativeToRange(newLimit, min, max);
            ByteBuffer duplicate = buf.duplicate();
            duplicate.position(pos).limit(lim);
            duplicates.add(duplicate);
            min = max;
        }
        return new ChunkBufferImplWithByteBufferList(duplicates);
    }

    @Override
    public Iterable<ByteBuffer> iterate(int bufferSize) {
        return () -> new Iterator<ByteBuffer>(){

            @Override
            public boolean hasNext() {
                return ChunkBufferImplWithByteBufferList.this.hasRemaining();
            }

            @Override
            public ByteBuffer next() {
                if (!ChunkBufferImplWithByteBufferList.this.hasRemaining()) {
                    throw new NoSuchElementException();
                }
                ChunkBufferImplWithByteBufferList.this.findCurrent();
                ByteBuffer current = (ByteBuffer)ChunkBufferImplWithByteBufferList.this.buffers.get(ChunkBufferImplWithByteBufferList.this.currentIndex);
                ByteBuffer duplicated = current.duplicate();
                duplicated.limit(current.limit());
                current.position(current.limit());
                return duplicated;
            }
        };
    }

    @Override
    public List<ByteBuffer> asByteBufferList() {
        return this.buffers;
    }

    @Override
    public long writeTo(GatheringByteChannel channel) throws IOException {
        long bytes = channel.write(this.buffers.toArray(new ByteBuffer[0]));
        this.findCurrent();
        return bytes;
    }

    @Override
    public ByteString toByteStringImpl(Function<ByteBuffer, ByteString> f) {
        ByteString result = ByteString.EMPTY;
        for (ByteBuffer buffer : this.buffers) {
            result = result.concat(f.apply(buffer));
        }
        return result;
    }

    @Override
    public List<ByteString> toByteStringListImpl(Function<ByteBuffer, ByteString> f) {
        ArrayList<ByteString> byteStringList = new ArrayList<ByteString>();
        for (ByteBuffer buffer : this.buffers) {
            byteStringList.add(f.apply(buffer));
        }
        return byteStringList;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":n=" + this.buffers.size() + ":p=" + this.position() + ":l=" + this.limit();
    }

    private static int relativeToRange(int value, int min, int max) {
        int pos = value <= min ? 0 : (value <= max ? value - min : max - min);
        return pos;
    }
}

