/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.ozone.common.ChecksumByteBuffer;
import org.apache.hadoop.ozone.common.ChecksumByteBufferFactory;
import org.apache.hadoop.ozone.common.ChecksumData;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.hadoop.ozone.common.OzoneChecksumException;
import org.apache.hadoop.ozone.common.utils.BufferUtils;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Checksum {
    public static final Logger LOG = LoggerFactory.getLogger(Checksum.class);
    private final ContainerProtos.ChecksumType checksumType;
    private final int bytesPerChecksum;

    private static Function<ByteBuffer, ByteString> newMessageDigestFunction(String algorithm) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to get MessageDigest for " + algorithm, e);
        }
        return data -> {
            md.reset();
            md.update((ByteBuffer)data);
            return ByteString.copyFrom((byte[])md.digest());
        };
    }

    public static ByteString int2ByteString(int n) {
        return UnsafeByteOperations.unsafeWrap((byte[])Ints.toByteArray((int)n));
    }

    private static Function<ByteBuffer, ByteString> newChecksumByteBufferFunction(Supplier<ChecksumByteBuffer> constructor) {
        ChecksumByteBuffer algorithm = constructor.get();
        return data -> {
            algorithm.reset();
            algorithm.update((ByteBuffer)data);
            return Checksum.int2ByteString((int)algorithm.getValue());
        };
    }

    public Checksum(ContainerProtos.ChecksumType type, int bytesPerChecksum) {
        this.checksumType = type;
        this.bytesPerChecksum = bytesPerChecksum;
    }

    public ChecksumData computeChecksum(byte[] data, int off, int len) throws OzoneChecksumException {
        return this.computeChecksum(ByteBuffer.wrap(data, off, len));
    }

    public ChecksumData computeChecksum(byte[] data) throws OzoneChecksumException {
        return this.computeChecksum(ByteBuffer.wrap(data));
    }

    public ChecksumData computeChecksum(ByteBuffer data) throws OzoneChecksumException {
        if (!data.isReadOnly()) {
            data = data.asReadOnlyBuffer();
        }
        return this.computeChecksum(ChunkBuffer.wrap(data));
    }

    public ChecksumData computeChecksum(List<ByteString> byteStrings) throws OzoneChecksumException {
        List<ByteBuffer> buffers = BufferUtils.getReadOnlyByteBuffers(byteStrings);
        return this.computeChecksum(ChunkBuffer.wrap(buffers));
    }

    public ChecksumData computeChecksum(ChunkBuffer data) throws OzoneChecksumException {
        Function<ByteBuffer, ByteString> function;
        if (this.checksumType == ContainerProtos.ChecksumType.NONE) {
            return new ChecksumData(this.checksumType, this.bytesPerChecksum);
        }
        try {
            function = Algorithm.valueOf(this.checksumType).newChecksumFunction();
        }
        catch (Exception e) {
            throw new OzoneChecksumException(this.checksumType);
        }
        ArrayList<ByteString> checksumList = new ArrayList<ByteString>();
        for (ByteBuffer b : data.iterate(this.bytesPerChecksum)) {
            checksumList.add(Checksum.computeChecksum(b, function, this.bytesPerChecksum));
        }
        return new ChecksumData(this.checksumType, this.bytesPerChecksum, checksumList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteString computeChecksum(ByteBuffer data, Function<ByteBuffer, ByteString> function, int maxLength) {
        int limit = data.limit();
        try {
            int maxIndex = data.position() + maxLength;
            if (limit > maxIndex) {
                data.limit(maxIndex);
            }
            ByteString byteString = function.apply(data);
            return byteString;
        }
        finally {
            data.limit(limit);
        }
    }

    public static boolean verifyChecksum(ByteString byteString, ChecksumData checksumData, int startIndex) throws OzoneChecksumException {
        ByteBuffer buffer = byteString.asReadOnlyByteBuffer();
        return Checksum.verifyChecksum(buffer, checksumData, startIndex);
    }

    public static boolean verifyChecksum(byte[] data, ChecksumData checksumData) throws OzoneChecksumException {
        return Checksum.verifyChecksum(ByteBuffer.wrap(data), checksumData, 0);
    }

    private static boolean verifyChecksum(ByteBuffer data, ChecksumData checksumData, int startIndex) throws OzoneChecksumException {
        ContainerProtos.ChecksumType checksumType = checksumData.getChecksumType();
        if (checksumType == ContainerProtos.ChecksumType.NONE) {
            return true;
        }
        int bytesPerChecksum = checksumData.getBytesPerChecksum();
        Checksum checksum = new Checksum(checksumType, bytesPerChecksum);
        ChecksumData computed = checksum.computeChecksum(data);
        return checksumData.verifyChecksumDataMatches(computed, startIndex);
    }

    public static boolean verifyChecksum(List<ByteString> byteStrings, ChecksumData checksumData, int startIndex, boolean isSingleByteString) throws OzoneChecksumException {
        ContainerProtos.ChecksumType checksumType = checksumData.getChecksumType();
        if (checksumType == ContainerProtos.ChecksumType.NONE) {
            return true;
        }
        if (isSingleByteString) {
            return Checksum.verifyChecksum(byteStrings.get(0), checksumData, startIndex);
        }
        List<ByteBuffer> buffers = BufferUtils.getReadOnlyByteBuffers(byteStrings);
        int bytesPerChecksum = checksumData.getBytesPerChecksum();
        Checksum checksum = new Checksum(checksumType, bytesPerChecksum);
        ChecksumData computed = checksum.computeChecksum(ChunkBuffer.wrap(buffers));
        return checksumData.verifyChecksumDataMatches(computed, startIndex);
    }

    @VisibleForTesting
    public static ContainerProtos.ChecksumData getNoChecksumDataProto() {
        return new ChecksumData(ContainerProtos.ChecksumType.NONE, 0).getProtoBufMessage();
    }

    static enum Algorithm {
        NONE(() -> data -> ByteString.EMPTY),
        CRC32(() -> Checksum.access$100(ChecksumByteBufferFactory::crc32Impl)),
        CRC32C(() -> Checksum.access$100(ChecksumByteBufferFactory::crc32CImpl)),
        SHA256(() -> Checksum.access$000("SHA-256")),
        MD5(() -> Checksum.access$000("MD5"));

        private final Supplier<Function<ByteBuffer, ByteString>> constructor;

        static Algorithm valueOf(ContainerProtos.ChecksumType type) {
            return Algorithm.valueOf(type.name());
        }

        private Algorithm(Supplier<Function<ByteBuffer, ByteString>> constructor) {
            this.constructor = constructor;
        }

        Function<ByteBuffer, ByteString> newChecksumFunction() {
            return this.constructor.get();
        }
    }
}

