/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.audit;

import java.util.Map;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditEventStatus;
import org.apache.logging.log4j.message.Message;

public final class AuditMessage
implements Message {
    private final String message;
    private final String user;
    private final String ip;
    private final String op;
    private final Map<String, String> params;
    private final String ret;
    private final Throwable throwable;

    private AuditMessage(String user, String ip, String op, Map<String, String> params, String ret, Throwable throwable) {
        this.user = user;
        this.ip = ip;
        this.op = op;
        this.params = params;
        this.ret = ret;
        this.message = this.formMessage(user, ip, op, params, ret);
        this.throwable = throwable;
    }

    public String getFormattedMessage() {
        return this.message;
    }

    public String getFormat() {
        return null;
    }

    public Object[] getParameters() {
        return new Object[0];
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getOp() {
        return this.op;
    }

    private String formMessage(String userStr, String ipStr, String opStr, Map<String, String> paramsMap, String retStr) {
        return "user=" + userStr + " | ip=" + ipStr + " | op=" + opStr + " " + paramsMap + " | ret=" + retStr;
    }

    public static class Builder {
        private Throwable throwable;
        private String user;
        private String ip;
        private String op;
        private Map<String, String> params;
        private String ret;

        public Builder setUser(String usr) {
            this.user = usr;
            return this;
        }

        public Builder atIp(String ipAddr) {
            this.ip = ipAddr;
            return this;
        }

        public Builder forOperation(AuditAction action) {
            this.op = action.getAction();
            return this;
        }

        public Builder withParams(Map<String, String> args) {
            this.params = args;
            return this;
        }

        public Builder withResult(AuditEventStatus result) {
            this.ret = result.getStatus();
            return this;
        }

        public Builder withException(Throwable ex) {
            this.throwable = ex;
            return this;
        }

        public AuditMessage build() {
            return new AuditMessage(this.user, this.ip, this.op, this.params, this.ret, this.throwable);
        }
    }
}

