/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.util.List;

public final class JsonUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule((Module)new JavaTimeModule()).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    private static final ObjectWriter WRITER = MAPPER.writerWithDefaultPrettyPrinter();

    private JsonUtils() {
    }

    public static String toJsonStringWithDefaultPrettyPrinter(Object obj) throws IOException {
        return WRITER.writeValueAsString(obj);
    }

    public static String toJsonString(Object obj) throws IOException {
        return MAPPER.writeValueAsString(obj);
    }

    public static ArrayNode createArrayNode() {
        return MAPPER.createArrayNode();
    }

    public static ObjectNode createObjectNode(Object next) {
        return (ObjectNode)MAPPER.valueToTree(next);
    }

    public static List<?> toJsonList(String str, Class<?> elementType) throws IOException {
        CollectionType type = MAPPER.getTypeFactory().constructCollectionType(List.class, elementType);
        return (List)MAPPER.readValue(str, (JavaType)type);
    }
}

