/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.token;

import com.google.common.base.Strings;
import java.time.Instant;
import java.util.Objects;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.TokenIdentifier;

@InterfaceAudience.Private
public abstract class ShortLivedTokenIdentifier
extends TokenIdentifier {
    private String ownerId;
    private Instant expiry;
    private String certSerialId;

    public abstract String getService();

    protected ShortLivedTokenIdentifier() {
    }

    protected ShortLivedTokenIdentifier(String ownerId, Instant expiry, String certSerialId) {
        this.ownerId = ownerId;
        this.expiry = expiry;
        this.certSerialId = certSerialId;
    }

    public UserGroupInformation getUser() {
        if (Strings.isNullOrEmpty((String)this.getOwnerId())) {
            return UserGroupInformation.createRemoteUser((String)this.getService());
        }
        return UserGroupInformation.createRemoteUser((String)this.ownerId);
    }

    public boolean isExpired(Instant at) {
        return this.expiry.isBefore(at);
    }

    protected void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    protected void setExpiry(Instant expiry) {
        this.expiry = expiry;
    }

    protected void setCertSerialId(String certSerialId) {
        this.certSerialId = certSerialId;
    }

    public Instant getExpiry() {
        return this.expiry;
    }

    public String getCertSerialId() {
        return this.certSerialId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ShortLivedTokenIdentifier that = (ShortLivedTokenIdentifier)((Object)o);
        return Objects.equals(this.ownerId, that.ownerId) && Objects.equals(this.expiry, that.expiry) && Objects.equals(this.certSerialId, that.certSerialId);
    }

    public int hashCode() {
        return Objects.hash(this.ownerId, this.expiry, this.certSerialId);
    }

    public String toString() {
        return "ownerId=" + this.ownerId + ", expiry=" + this.expiry + ", certSerialId=" + this.certSerialId;
    }
}

