/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.XceiverClientReply;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.container.common.helpers.BlockNotCommittedException;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerNotOpenException;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.scm.storage.CheckedBiFunction;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.ozone.common.Checksum;
import org.apache.hadoop.ozone.common.ChecksumData;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;

public final class ContainerProtocolCalls {
    private ContainerProtocolCalls() {
    }

    public static ContainerProtos.ListBlockResponseProto listBlock(XceiverClientSpi xceiverClient, long containerID, Long startLocalID, int count, Token<? extends TokenIdentifier> token) throws IOException {
        ContainerProtos.ListBlockRequestProto.Builder listBlockBuilder = ContainerProtos.ListBlockRequestProto.newBuilder().setCount(count);
        if (startLocalID != null) {
            listBlockBuilder.setStartLocalID(startLocalID.longValue());
        }
        String datanodeID = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.ListBlock).setContainerID(containerID).setDatanodeUuid(datanodeID).setListBlock(listBlockBuilder.build());
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = xceiverClient.sendCommand(request, ContainerProtocolCalls.getValidatorList());
        return response.getListBlock();
    }

    public static ContainerProtos.GetBlockResponseProto getBlock(XceiverClientSpi xceiverClient, ContainerProtos.DatanodeBlockID datanodeBlockID, Token<? extends TokenIdentifier> token) throws IOException {
        ContainerProtos.GetBlockRequestProto.Builder readBlockRequest = ContainerProtos.GetBlockRequestProto.newBuilder().setBlockID(datanodeBlockID);
        String id = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.GetBlock).setContainerID(datanodeBlockID.getContainerID()).setDatanodeUuid(id).setGetBlock(readBlockRequest);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = xceiverClient.sendCommand(request, ContainerProtocolCalls.getValidatorList());
        return response.getGetBlock();
    }

    public static ContainerProtos.GetCommittedBlockLengthResponseProto getCommittedBlockLength(XceiverClientSpi xceiverClient, BlockID blockID, Token<OzoneBlockTokenIdentifier> token) throws IOException {
        ContainerProtos.GetCommittedBlockLengthRequestProto.Builder getBlockLengthRequestBuilder = ContainerProtos.GetCommittedBlockLengthRequestProto.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf());
        String id = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.GetCommittedBlockLength).setContainerID(blockID.getContainerID()).setDatanodeUuid(id).setGetCommittedBlockLength(getBlockLengthRequestBuilder);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = xceiverClient.sendCommand(request, ContainerProtocolCalls.getValidatorList());
        return response.getGetCommittedBlockLength();
    }

    public static ContainerProtos.PutBlockResponseProto putBlock(XceiverClientSpi xceiverClient, ContainerProtos.BlockData containerBlockData, Token<OzoneBlockTokenIdentifier> token) throws IOException {
        ContainerProtos.PutBlockRequestProto.Builder createBlockRequest = ContainerProtos.PutBlockRequestProto.newBuilder().setBlockData(containerBlockData);
        String id = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.PutBlock).setContainerID(containerBlockData.getBlockID().getContainerID()).setDatanodeUuid(id).setPutBlock(createBlockRequest);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = xceiverClient.sendCommand(request, ContainerProtocolCalls.getValidatorList());
        return response.getPutBlock();
    }

    public static XceiverClientReply putBlockAsync(XceiverClientSpi xceiverClient, ContainerProtos.BlockData containerBlockData, boolean eof, Token<? extends TokenIdentifier> token) throws IOException, InterruptedException, ExecutionException {
        ContainerProtos.PutBlockRequestProto.Builder createBlockRequest = ContainerProtos.PutBlockRequestProto.newBuilder().setBlockData(containerBlockData).setEof(eof);
        String id = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.PutBlock).setContainerID(containerBlockData.getBlockID().getContainerID()).setDatanodeUuid(id).setPutBlock(createBlockRequest);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        return xceiverClient.sendCommandAsync(request);
    }

    public static ContainerProtos.ReadChunkResponseProto readChunk(XceiverClientSpi xceiverClient, ContainerProtos.ChunkInfo chunk, BlockID blockID, List<CheckedBiFunction> validators, Token<? extends TokenIdentifier> token) throws IOException {
        ContainerProtos.ReadChunkRequestProto.Builder readChunkRequest = ContainerProtos.ReadChunkRequestProto.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf()).setChunkData(chunk).setReadChunkVersion(ContainerProtos.ReadChunkVersion.V1);
        String id = xceiverClient.getPipeline().getClosestNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.ReadChunk).setContainerID(blockID.getContainerID()).setDatanodeUuid(id).setReadChunk(readChunkRequest);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto reply = xceiverClient.sendCommand(request, validators);
        return reply.getReadChunk();
    }

    public static void writeChunk(XceiverClientSpi xceiverClient, ContainerProtos.ChunkInfo chunk, BlockID blockID, ByteString data, Token<OzoneBlockTokenIdentifier> token) throws IOException {
        ContainerProtos.WriteChunkRequestProto.Builder writeChunkRequest = ContainerProtos.WriteChunkRequestProto.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf()).setChunkData(chunk).setData(data);
        String id = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.WriteChunk).setContainerID(blockID.getContainerID()).setDatanodeUuid(id).setWriteChunk(writeChunkRequest);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        xceiverClient.sendCommand(request, ContainerProtocolCalls.getValidatorList());
    }

    public static XceiverClientReply writeChunkAsync(XceiverClientSpi xceiverClient, ContainerProtos.ChunkInfo chunk, BlockID blockID, ByteString data, Token<? extends TokenIdentifier> token, int replicationIndex) throws IOException, ExecutionException, InterruptedException {
        ContainerProtos.WriteChunkRequestProto.Builder writeChunkRequest = ContainerProtos.WriteChunkRequestProto.newBuilder().setBlockID(ContainerProtos.DatanodeBlockID.newBuilder().setContainerID(blockID.getContainerID()).setLocalID(blockID.getLocalID()).setBlockCommitSequenceId(blockID.getBlockCommitSequenceId()).setReplicaIndex(replicationIndex).build()).setChunkData(chunk).setData(data);
        String id = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.WriteChunk).setContainerID(blockID.getContainerID()).setDatanodeUuid(id).setWriteChunk(writeChunkRequest);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        return xceiverClient.sendCommandAsync(request);
    }

    public static ContainerProtos.PutSmallFileResponseProto writeSmallFile(XceiverClientSpi client, BlockID blockID, byte[] data, Token<OzoneBlockTokenIdentifier> token) throws IOException {
        ContainerProtos.BlockData containerBlockData = ContainerProtos.BlockData.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf()).build();
        ContainerProtos.PutBlockRequestProto.Builder createBlockRequest = ContainerProtos.PutBlockRequestProto.newBuilder().setBlockData(containerBlockData);
        ContainerProtos.KeyValue keyValue = ContainerProtos.KeyValue.newBuilder().setKey("OverWriteRequested").setValue("true").build();
        Checksum checksum = new Checksum(ContainerProtos.ChecksumType.CRC32, 256);
        ChecksumData checksumData = checksum.computeChecksum(data);
        ContainerProtos.ChunkInfo chunk = ContainerProtos.ChunkInfo.newBuilder().setChunkName(blockID.getLocalID() + "_chunk").setOffset(0L).setLen((long)data.length).addMetadata(keyValue).setChecksumData(checksumData.getProtoBufMessage()).build();
        ContainerProtos.PutSmallFileRequestProto putSmallFileRequest = ContainerProtos.PutSmallFileRequestProto.newBuilder().setChunkInfo(chunk).setBlock(createBlockRequest).setData(ByteString.copyFrom((byte[])data)).build();
        String id = client.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.PutSmallFile).setContainerID(blockID.getContainerID()).setDatanodeUuid(id).setPutSmallFile(putSmallFileRequest);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = client.sendCommand(request, ContainerProtocolCalls.getValidatorList());
        return response.getPutSmallFile();
    }

    @InterfaceStability.Evolving
    public static void createRecoveringContainer(XceiverClientSpi client, long containerID, String encodedToken, int replicaIndex) throws IOException {
        ContainerProtocolCalls.createContainerInternal(client, containerID, encodedToken, ContainerProtos.ContainerDataProto.State.RECOVERING, replicaIndex);
    }

    public static void createContainer(XceiverClientSpi client, long containerID, String encodedToken) throws IOException {
        ContainerProtocolCalls.createContainerInternal(client, containerID, encodedToken, null, 0);
    }

    private static void createContainerInternal(XceiverClientSpi client, long containerID, String encodedToken, ContainerProtos.ContainerDataProto.State state, int replicaIndex) throws IOException {
        ContainerProtos.CreateContainerRequestProto.Builder createRequest = ContainerProtos.CreateContainerRequestProto.newBuilder();
        createRequest.setContainerType(ContainerProtos.ContainerType.KeyValueContainer);
        if (state != null) {
            createRequest.setState(state);
        }
        if (replicaIndex > 0) {
            createRequest.setReplicaIndex(replicaIndex);
        }
        String id = client.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        if (encodedToken != null) {
            request.setEncodedToken(encodedToken);
        }
        request.setCmdType(ContainerProtos.Type.CreateContainer);
        request.setContainerID(containerID);
        request.setCreateContainer(createRequest.build());
        request.setDatanodeUuid(id);
        client.sendCommand(request.build(), ContainerProtocolCalls.getValidatorList());
    }

    public static void deleteContainer(XceiverClientSpi client, long containerID, boolean force, String encodedToken) throws IOException {
        ContainerProtos.DeleteContainerRequestProto.Builder deleteRequest = ContainerProtos.DeleteContainerRequestProto.newBuilder();
        deleteRequest.setForceDelete(force);
        String id = client.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.DeleteContainer);
        request.setContainerID(containerID);
        request.setDeleteContainer(deleteRequest);
        request.setDatanodeUuid(id);
        if (encodedToken != null) {
            request.setEncodedToken(encodedToken);
        }
        client.sendCommand(request.build(), ContainerProtocolCalls.getValidatorList());
    }

    public static void closeContainer(XceiverClientSpi client, long containerID, String encodedToken) throws IOException {
        String id = client.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.CloseContainer);
        request.setContainerID(containerID);
        request.setCloseContainer(ContainerProtos.CloseContainerRequestProto.getDefaultInstance());
        request.setDatanodeUuid(id);
        if (encodedToken != null) {
            request.setEncodedToken(encodedToken);
        }
        client.sendCommand(request.build(), ContainerProtocolCalls.getValidatorList());
    }

    public static ContainerProtos.ReadContainerResponseProto readContainer(XceiverClientSpi client, long containerID, String encodedToken) throws IOException {
        String id = client.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.ReadContainer);
        request.setContainerID(containerID);
        request.setReadContainer(ContainerProtos.ReadContainerRequestProto.getDefaultInstance());
        request.setDatanodeUuid(id);
        if (encodedToken != null) {
            request.setEncodedToken(encodedToken);
        }
        ContainerProtos.ContainerCommandResponseProto response = client.sendCommand(request.build(), ContainerProtocolCalls.getValidatorList());
        return response.getReadContainer();
    }

    public static ContainerProtos.GetSmallFileResponseProto readSmallFile(XceiverClientSpi client, BlockID blockID, Token<OzoneBlockTokenIdentifier> token) throws IOException {
        ContainerProtos.GetBlockRequestProto.Builder getBlock = ContainerProtos.GetBlockRequestProto.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf());
        ContainerProtos.GetSmallFileRequestProto getSmallFileRequest = ContainerProtos.GetSmallFileRequestProto.newBuilder().setBlock(getBlock).setReadChunkVersion(ContainerProtos.ReadChunkVersion.V1).build();
        String id = client.getPipeline().getClosestNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.GetSmallFile).setContainerID(blockID.getContainerID()).setDatanodeUuid(id).setGetSmallFile(getSmallFileRequest);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = client.sendCommand(request, ContainerProtocolCalls.getValidatorList());
        return response.getGetSmallFile();
    }

    public static void validateContainerResponse(ContainerProtos.ContainerCommandResponseProto response) throws StorageContainerException {
        if (response.getResult() == ContainerProtos.Result.SUCCESS) {
            return;
        }
        if (response.getResult() == ContainerProtos.Result.BLOCK_NOT_COMMITTED) {
            throw new BlockNotCommittedException(response.getMessage());
        }
        if (response.getResult() == ContainerProtos.Result.CLOSED_CONTAINER_IO) {
            throw new ContainerNotOpenException(response.getMessage());
        }
        throw new StorageContainerException(response.getMessage(), response.getResult());
    }

    public static List<CheckedBiFunction> getValidatorList() {
        ArrayList<CheckedBiFunction> validators = new ArrayList<CheckedBiFunction>(1);
        CheckedBiFunction validator = (request, response) -> ContainerProtocolCalls.validateContainerResponse(response);
        validators.add(validator);
        return validators;
    }

    public static HashMap<DatanodeDetails, ContainerProtos.GetBlockResponseProto> getBlockFromAllNodes(XceiverClientSpi xceiverClient, ContainerProtos.DatanodeBlockID datanodeBlockID, Token<OzoneBlockTokenIdentifier> token) throws IOException, InterruptedException {
        ContainerProtos.GetBlockRequestProto.Builder readBlockRequest = ContainerProtos.GetBlockRequestProto.newBuilder().setBlockID(datanodeBlockID);
        HashMap<DatanodeDetails, ContainerProtos.GetBlockResponseProto> datanodeToResponseMap = new HashMap<DatanodeDetails, ContainerProtos.GetBlockResponseProto>();
        String id = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.GetBlock).setContainerID(datanodeBlockID.getContainerID()).setDatanodeUuid(id).setGetBlock(readBlockRequest);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        Map<DatanodeDetails, ContainerProtos.ContainerCommandResponseProto> responses = xceiverClient.sendCommandOnAllNodes(request);
        for (Map.Entry<DatanodeDetails, ContainerProtos.ContainerCommandResponseProto> entry : responses.entrySet()) {
            datanodeToResponseMap.put(entry.getKey(), entry.getValue().getGetBlock());
        }
        return datanodeToResponseMap;
    }
}

