/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.common.helpers;

import java.time.Clock;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.ozone.common.MonotonicClock;

public class ExcludeList {
    private final Map<DatanodeDetails, Long> datanodes = new ConcurrentHashMap<DatanodeDetails, Long>();
    private final Set<ContainerID> containerIds = new HashSet<ContainerID>();
    private final Set<PipelineID> pipelineIds = new HashSet<PipelineID>();
    private long expiryTime = 0L;
    private Clock clock = new MonotonicClock(ZoneOffset.UTC);

    public ExcludeList() {
    }

    public ExcludeList(long autoExpiryTime, Clock clock) {
        this();
        this.expiryTime = autoExpiryTime;
        this.clock = clock;
    }

    public Set<ContainerID> getContainerIds() {
        return this.containerIds;
    }

    public Set<DatanodeDetails> getDatanodes() {
        HashSet<DatanodeDetails> dns = new HashSet();
        if (this.expiryTime > 0L) {
            Iterator<Map.Entry<DatanodeDetails, Long>> iterator = this.datanodes.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<DatanodeDetails, Long> entry = iterator.next();
                Long storedExpiryTime = entry.getValue();
                if (this.clock.millis() > storedExpiryTime) {
                    iterator.remove();
                    continue;
                }
                dns.add(entry.getKey());
            }
        } else {
            dns = this.datanodes.keySet();
        }
        return dns;
    }

    public void addDatanodes(Collection<DatanodeDetails> dns) {
        dns.forEach(dn -> this.addDatanode((DatanodeDetails)dn));
    }

    public void addDatanode(DatanodeDetails dn) {
        this.datanodes.put(dn, this.clock.millis() + this.expiryTime);
    }

    public void addConatinerId(ContainerID containerId) {
        this.containerIds.add(containerId);
    }

    public void addPipeline(PipelineID pipelineId) {
        this.pipelineIds.add(pipelineId);
    }

    public Set<PipelineID> getPipelineIds() {
        return this.pipelineIds;
    }

    public HddsProtos.ExcludeListProto getProtoBuf() {
        HddsProtos.ExcludeListProto.Builder builder = HddsProtos.ExcludeListProto.newBuilder();
        this.containerIds.forEach(id -> builder.addContainerIds(id.getId()));
        this.getDatanodes().forEach(dn -> builder.addDatanodes(dn.getUuidString()));
        this.pipelineIds.forEach(pipelineID -> builder.addPipelineIds(pipelineID.getProtobuf()));
        return builder.build();
    }

    public static ExcludeList getFromProtoBuf(HddsProtos.ExcludeListProto excludeListProto) {
        ExcludeList excludeList = new ExcludeList();
        excludeListProto.getContainerIdsList().forEach(id -> excludeList.addConatinerId(ContainerID.valueOf(id)));
        DatanodeDetails.Builder builder = DatanodeDetails.newBuilder();
        excludeListProto.getDatanodesList().forEach(dn -> {
            builder.setUuid(UUID.fromString(dn));
            excludeList.addDatanode(builder.build());
        });
        excludeListProto.getPipelineIdsList().forEach(pipelineID -> excludeList.addPipeline(PipelineID.getFromProtobuf(pipelineID)));
        return excludeList;
    }

    public boolean isEmpty() {
        return this.getDatanodes().isEmpty() && this.containerIds.isEmpty() && this.pipelineIds.isEmpty();
    }

    public void clear() {
        this.datanodes.clear();
        this.containerIds.clear();
        this.pipelineIds.clear();
    }

    public String toString() {
        return "ExcludeList {datanodes = " + this.getDatanodes() + ", containerIds = " + this.containerIds + ", pipelineIds = " + this.pipelineIds + '}';
    }
}

