/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.DatanodeAdminError;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplicaInfo;
import org.apache.hadoop.hdds.scm.container.ReplicationManagerReport;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizer;

@InterfaceStability.Unstable
public interface ScmClient
extends Closeable {
    public ContainerWithPipeline createContainer(String var1) throws IOException;

    public ContainerInfo getContainer(long var1) throws IOException;

    public ContainerWithPipeline getContainerWithPipeline(long var1) throws IOException;

    public List<ContainerReplicaInfo> getContainerReplicas(long var1) throws IOException;

    public void closeContainer(long var1) throws IOException;

    public void deleteContainer(long var1, Pipeline var3, boolean var4) throws IOException;

    public void deleteContainer(long var1, boolean var3) throws IOException;

    public List<ContainerInfo> listContainer(long var1, int var3) throws IOException;

    public List<ContainerInfo> listContainer(long var1, int var3, HddsProtos.LifeCycleState var4, HddsProtos.ReplicationType var5, ReplicationConfig var6) throws IOException;

    public ContainerProtos.ContainerDataProto readContainer(long var1, Pipeline var3) throws IOException;

    public ContainerProtos.ContainerDataProto readContainer(long var1) throws IOException;

    public long getContainerSize(long var1) throws IOException;

    public ContainerWithPipeline createContainer(HddsProtos.ReplicationType var1, HddsProtos.ReplicationFactor var2, String var3) throws IOException;

    public List<HddsProtos.Node> queryNode(HddsProtos.NodeOperationalState var1, HddsProtos.NodeState var2, HddsProtos.QueryScope var3, String var4) throws IOException;

    public List<DatanodeAdminError> decommissionNodes(List<String> var1) throws IOException;

    public List<DatanodeAdminError> recommissionNodes(List<String> var1) throws IOException;

    public List<DatanodeAdminError> startMaintenanceNodes(List<String> var1, int var2) throws IOException;

    public Pipeline createReplicationPipeline(HddsProtos.ReplicationType var1, HddsProtos.ReplicationFactor var2, HddsProtos.NodePool var3) throws IOException;

    public List<Pipeline> listPipelines() throws IOException;

    public Pipeline getPipeline(HddsProtos.PipelineID var1) throws IOException;

    public void activatePipeline(HddsProtos.PipelineID var1) throws IOException;

    public void deactivatePipeline(HddsProtos.PipelineID var1) throws IOException;

    public void closePipeline(HddsProtos.PipelineID var1) throws IOException;

    public boolean inSafeMode() throws IOException;

    public Map<String, Pair<Boolean, String>> getSafeModeRuleStatuses() throws IOException;

    public boolean forceExitSafeMode() throws IOException;

    public void startReplicationManager() throws IOException;

    public void stopReplicationManager() throws IOException;

    public boolean getReplicationManagerStatus() throws IOException;

    public ReplicationManagerReport getReplicationManagerReport() throws IOException;

    public StorageContainerLocationProtocolProtos.StartContainerBalancerResponseProto startContainerBalancer(Optional<Double> var1, Optional<Integer> var2, Optional<Integer> var3, Optional<Long> var4, Optional<Long> var5, Optional<Long> var6) throws IOException;

    public void stopContainerBalancer() throws IOException;

    public boolean getContainerBalancerStatus() throws IOException;

    public List<String> getScmRatisRoles() throws IOException;

    public int resetDeletedBlockRetryCount(List<Long> var1) throws IOException;

    public List<HddsProtos.DatanodeUsageInfoProto> getDatanodeUsageInfo(String var1, String var2) throws IOException;

    public List<HddsProtos.DatanodeUsageInfoProto> getDatanodeUsageInfo(boolean var1, int var2) throws IOException;

    public UpgradeFinalizer.StatusAndMessages finalizeScmUpgrade(String var1) throws IOException;

    public UpgradeFinalizer.StatusAndMessages queryUpgradeFinalizationProgress(String var1, boolean var2, boolean var3) throws IOException;
}

