/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.utils.LegacyHadoopConfigurationSource;

@InterfaceAudience.Private
public class OzoneConfiguration
extends Configuration
implements MutableConfigurationSource {
    public static OzoneConfiguration of(ConfigurationSource source) {
        if (source instanceof LegacyHadoopConfigurationSource) {
            return new OzoneConfiguration(((LegacyHadoopConfigurationSource)source).getOriginalHadoopConfiguration());
        }
        return (OzoneConfiguration)source;
    }

    public static OzoneConfiguration of(OzoneConfiguration source) {
        return source;
    }

    public static OzoneConfiguration of(Configuration conf) {
        Preconditions.checkNotNull((Object)conf);
        return conf instanceof OzoneConfiguration ? (OzoneConfiguration)conf : new OzoneConfiguration(conf);
    }

    public static <T> T newInstanceOf(Class<T> configurationClass) {
        OzoneConfiguration conf = new OzoneConfiguration();
        return (T)conf.getObject(configurationClass);
    }

    public static <T> OzoneConfiguration fromObject(T configObject) {
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.setFromObject(configObject);
        return conf;
    }

    public OzoneConfiguration() {
        OzoneConfiguration.activate();
        this.loadDefaults();
    }

    public OzoneConfiguration(Configuration conf) {
        super(conf);
        this.setClassLoader(conf.getClassLoader());
        if (!(conf instanceof OzoneConfiguration)) {
            this.loadDefaults();
            this.addResource(conf);
        }
    }

    private void loadDefaults() {
        try {
            Enumeration<URL> generatedDefaults = OzoneConfiguration.class.getClassLoader().getResources("ozone-default-generated.xml");
            while (generatedDefaults.hasMoreElements()) {
                this.addResource(generatedDefaults.nextElement());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.addResource("ozone-default.xml");
        this.addResource("core-site.xml");
        this.addResource("ozone-site.xml");
    }

    public List<Property> readPropertyFromXml(URL url) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{XMLConfiguration.class});
        Unmarshaller um = context.createUnmarshaller();
        XMLConfiguration config = (XMLConfiguration)um.unmarshal(url);
        return config.getProperties();
    }

    public static void activate() {
        Configuration.addDefaultResource((String)"hdfs-default.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
    }

    public Properties getAllPropertiesByTag(String tag) {
        Properties updatedProps = this.getProps();
        Properties propertiesByTag = super.getAllPropertiesByTag(tag);
        Properties props = new Properties();
        Enumeration<?> properties = propertiesByTag.propertyNames();
        while (properties.hasMoreElements()) {
            Object propertyName = properties.nextElement();
            String value = updatedProps.getProperty(propertyName.toString());
            if (value == null) continue;
            props.put(propertyName, value);
        }
        return props;
    }

    public Collection<String> getConfigKeys() {
        return this.getProps().keySet().stream().map(Object::toString).collect(Collectors.toList());
    }

    public Map<String, String> getPropsMatchPrefixAndTrimPrefix(String keyPrefix) {
        Properties props = this.getProps();
        HashMap<String, String> configMap = new HashMap<String, String>();
        for (String name : props.stringPropertyNames()) {
            if (!name.startsWith(keyPrefix)) continue;
            String value = this.get(name);
            String keyName = name.substring(keyPrefix.length());
            configMap.put(keyName, value);
        }
        return configMap;
    }

    private static void addDeprecatedKeys() {
        Configuration.addDeprecations((Configuration.DeprecationDelta[])new Configuration.DeprecationDelta[]{new Configuration.DeprecationDelta("ozone.datanode.pipeline.limit", "ozone.scm.datanode.pipeline.limit"), new Configuration.DeprecationDelta("hdds.ratis.raft.server.rpcslowness.timeout", "hdds.ratis.raft.server.rpc.slowness.timeout"), new Configuration.DeprecationDelta("dfs.datanode.keytab.file", "dfs.datanode.kerberos.keytab.file"), new Configuration.DeprecationDelta("ozone.scm.chunk.layout", "ozone.scm.container.layout")});
    }

    static {
        OzoneConfiguration.addDeprecatedKeys();
        OzoneConfiguration.activate();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlRootElement(name="property")
    public static class Property
    implements Comparable<Property> {
        private String name;
        private String value;
        private String tag;
        private String description;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        public int compareTo(Property o) {
            if (this == o) {
                return 0;
            }
            return this.getName().compareTo(o.getName());
        }

        public String toString() {
            return this.getName() + " " + this.getValue() + " " + this.getTag();
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Property && ((Property)obj).getName().equals(this.getName());
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlRootElement(name="configuration")
    public static class XMLConfiguration {
        @XmlElement(name="property", type=Property.class)
        private List<Property> properties = new ArrayList<Property>();

        public XMLConfiguration() {
        }

        public XMLConfiguration(List<Property> properties) {
            this.properties = properties;
        }

        public List<Property> getProperties() {
            return this.properties;
        }

        public void setProperties(List<Property> properties) {
            this.properties = properties;
        }
    }
}

