/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.client;

import java.util.regex.Pattern;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;
import org.apache.hadoop.hdds.conf.PostConstruct;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;

@ConfigGroup(prefix="ozone.replication")
public class ReplicationConfigValidator {
    @Config(key="allowed-configs", defaultValue="^((STANDALONE|RATIS)/(ONE|THREE))|(EC/(3-2|6-3|10-4))$", type=ConfigType.STRING, description="Regular expression to restrict enabled replication schemes", tags={ConfigTag.STORAGE})
    private String validationPattern;
    private Pattern validationRegexp;

    @PostConstruct
    public void init() {
        if (this.validationPattern != null && !this.validationPattern.equals("")) {
            this.validationRegexp = Pattern.compile(this.validationPattern);
        }
    }

    public ReplicationConfig validate(ReplicationConfig replicationConfig) {
        if (this.validationRegexp == null) {
            return replicationConfig;
        }
        if (!this.validationRegexp.matcher(replicationConfig.configFormat()).matches()) {
            String replication = replicationConfig.getReplication();
            if (HddsProtos.ReplicationType.EC == replicationConfig.getReplicationType()) {
                ECReplicationConfig ecConfig = (ECReplicationConfig)replicationConfig;
                replication = (Object)((Object)ecConfig.getCodec()) + "-" + ecConfig.getData() + "-" + ecConfig.getParity() + "-{CHUNK_SIZE}";
                throw new IllegalArgumentException("Invalid data-parity replication config for type " + replicationConfig.getReplicationType() + " and replication " + replication + ". Supported data-parity are 3-2,6-3,10-4");
            }
            throw new IllegalArgumentException("Invalid replication config for type " + replicationConfig.getReplicationType() + " and replication " + replication);
        }
        return replicationConfig;
    }
}

