/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.client;

import com.google.common.base.Strings;
import org.apache.hadoop.hdds.client.QuotaList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OzoneQuota {
    public static final Logger LOG = LoggerFactory.getLogger(OzoneQuota.class);
    public static final String OZONE_QUOTA_B = "B";
    public static final String OZONE_QUOTA_KB = "KB";
    public static final String OZONE_QUOTA_MB = "MB";
    public static final String OZONE_QUOTA_GB = "GB";
    public static final String OZONE_QUOTA_TB = "TB";
    private long quotaInNamespace;
    private long quotaInBytes;
    private RawQuotaInBytes rawQuotaInBytes;
    private static QuotaList quotaList = new QuotaList();

    public long getRawSize() {
        return this.rawQuotaInBytes.getSize();
    }

    public Units getUnit() {
        return this.rawQuotaInBytes.getUnit();
    }

    private OzoneQuota(RawQuotaInBytes rawQuotaInBytes) {
        this.rawQuotaInBytes = rawQuotaInBytes;
        this.quotaInBytes = rawQuotaInBytes.sizeInBytes();
    }

    private OzoneQuota(long quotaInNamespace, RawQuotaInBytes rawQuotaInBytes) {
        this.quotaInNamespace = quotaInNamespace;
        this.rawQuotaInBytes = rawQuotaInBytes;
        this.quotaInBytes = rawQuotaInBytes.sizeInBytes();
    }

    public static String formatQuota(OzoneQuota quota) {
        return String.valueOf(quota.getRawSize()) + (Object)((Object)quota.getUnit());
    }

    public static OzoneQuota parseSpaceQuota(String quotaInBytes) {
        if (Strings.isNullOrEmpty((String)quotaInBytes)) {
            throw new IllegalArgumentException("Quota string cannot be null or empty.");
        }
        String uppercase = quotaInBytes.toUpperCase().replaceAll("\\s+", "");
        String size = "";
        long nSize = 0L;
        Units currUnit = Units.B;
        try {
            for (String quota : quotaList.getOzoneQuotaArray()) {
                if (!uppercase.endsWith(quota)) continue;
                size = uppercase.substring(0, uppercase.length() - quota.length());
                currUnit = quotaList.getUnits(quota);
                break;
            }
            if (size.equals("")) {
                size = uppercase;
            }
            nSize = Long.parseLong(size);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid values for quota, to ensure that the Quota format is legal(supported values are B, KB, MB, GB and TB). And the quota value cannot be greater than Long.MAX_VALUE BYTES");
        }
        if (nSize <= 0L) {
            throw new IllegalArgumentException("Invalid values for space quota: " + nSize);
        }
        return new OzoneQuota(new RawQuotaInBytes(currUnit, nSize));
    }

    public static OzoneQuota parseNameSpaceQuota(String quotaInNamespace) {
        if (Strings.isNullOrEmpty((String)quotaInNamespace)) {
            throw new IllegalArgumentException("Quota string cannot be null or empty.");
        }
        long nameSpaceQuota = Long.parseLong(quotaInNamespace);
        if (nameSpaceQuota <= 0L) {
            throw new IllegalArgumentException("Invalid values for namespace quota: " + nameSpaceQuota);
        }
        return new OzoneQuota(nameSpaceQuota, new RawQuotaInBytes(Units.B, -1L));
    }

    public static OzoneQuota parseQuota(String quotaInBytes, String quotaInNamespace) {
        return new OzoneQuota(OzoneQuota.parseNameSpaceQuota((String)quotaInNamespace).quotaInNamespace, OzoneQuota.parseSpaceQuota((String)quotaInBytes).rawQuotaInBytes);
    }

    public static OzoneQuota getOzoneQuota(long quotaInBytes, long quotaInNamespace) {
        long size = 1L;
        Units unit = Units.B;
        for (Long quota : quotaList.getSizeQuotaArray()) {
            if (quotaInBytes % quota != 0L) continue;
            size = quotaInBytes / quota;
            unit = quotaList.getQuotaUnit(quota);
        }
        return new OzoneQuota(quotaInNamespace, new RawQuotaInBytes(unit, size));
    }

    public long getQuotaInNamespace() {
        return this.quotaInNamespace;
    }

    public long getQuotaInBytes() {
        return this.quotaInBytes;
    }

    public String toString() {
        return "Space Bytes Quota: " + this.rawQuotaInBytes.toString() + "\nCounts Quota: " + this.quotaInNamespace;
    }

    static {
        quotaList.addQuotaList(OZONE_QUOTA_TB, Units.TB, 0x10000000000L);
        quotaList.addQuotaList(OZONE_QUOTA_GB, Units.GB, 0x40000000L);
        quotaList.addQuotaList(OZONE_QUOTA_MB, Units.MB, 0x100000L);
        quotaList.addQuotaList(OZONE_QUOTA_KB, Units.KB, 1024L);
        quotaList.addQuotaList(OZONE_QUOTA_B, Units.B, 1L);
    }

    private static class RawQuotaInBytes {
        private Units unit;
        private long size;

        RawQuotaInBytes(Units unit, long size) {
            this.unit = unit;
            this.size = size;
        }

        public Units getUnit() {
            return this.unit;
        }

        public long getSize() {
            return this.size;
        }

        public long sizeInBytes() {
            long sQuota = -1L;
            for (Units quota : quotaList.getUnitQuotaArray()) {
                if (quota != this.unit) continue;
                sQuota = quotaList.getQuotaSize(quota);
                break;
            }
            return this.getSize() * sQuota;
        }

        public String toString() {
            return this.size + " " + (Object)((Object)this.unit);
        }
    }

    public static enum Units {
        B,
        KB,
        MB,
        GB,
        TB;

    }
}

