/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.EnumSet;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;

public class ECReplicationConfig
implements ReplicationConfig {
    public static final String EC_REPLICATION_PARAMS_DELIMITER = "-";
    private static final Pattern STRING_FORMAT = Pattern.compile("([a-zA-Z]+)-(\\d+)-(\\d+)-(\\d+)([kK])?");
    private int data;
    private int parity;
    private int ecChunkSize = 0x100000;
    private EcCodec codec = EcCodec.RS;

    public ECReplicationConfig(int data, int parity) {
        this.data = data;
        this.parity = parity;
    }

    public ECReplicationConfig(int data, int parity, EcCodec codec, int ecChunkSize) {
        this.data = data;
        this.parity = parity;
        this.codec = codec;
        this.ecChunkSize = ecChunkSize;
    }

    public ECReplicationConfig(String string) {
        Matcher matcher = STRING_FORMAT.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("EC replication config should be defined in the form rs-3-2-1024k, rs-6-3-1024; or rs-10-4-1024k. Provided configuration was: " + string);
        }
        try {
            this.codec = EcCodec.valueOf(matcher.group(1).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The codec " + matcher.group(1) + " is invalid. It must be one of " + EcCodec.allValuesAsString() + ".", e);
        }
        this.data = Integer.parseInt(matcher.group(2));
        this.parity = Integer.parseInt(matcher.group(3));
        if (this.data <= 0 || this.parity <= 0) {
            throw new IllegalArgumentException("Data and parity part in EC replication config supposed to be positive numbers");
        }
        int chunkSize = Integer.parseInt(matcher.group(4));
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("The ecChunkSize (" + chunkSize + ") be greater than zero");
        }
        if (matcher.group(5) != null) {
            chunkSize *= 1024;
        }
        this.ecChunkSize = chunkSize;
    }

    public ECReplicationConfig(HddsProtos.ECReplicationConfig ecReplicationConfig) {
        this.data = ecReplicationConfig.getData();
        this.parity = ecReplicationConfig.getParity();
        this.codec = EcCodec.valueOf(ecReplicationConfig.getCodec().toUpperCase());
        this.ecChunkSize = ecReplicationConfig.getEcChunkSize();
    }

    @Override
    public HddsProtos.ReplicationType getReplicationType() {
        return HddsProtos.ReplicationType.EC;
    }

    @Override
    public int getRequiredNodes() {
        return this.data + this.parity;
    }

    @Override
    @JsonIgnore
    public String getReplication() {
        return (Object)((Object)this.getCodec()) + EC_REPLICATION_PARAMS_DELIMITER + this.getData() + EC_REPLICATION_PARAMS_DELIMITER + this.getParity() + EC_REPLICATION_PARAMS_DELIMITER + this.getEcChunkSize();
    }

    public HddsProtos.ECReplicationConfig toProto() {
        return HddsProtos.ECReplicationConfig.newBuilder().setData(this.data).setParity(this.parity).setCodec(this.codec.toString()).setEcChunkSize(this.ecChunkSize).build();
    }

    public int getData() {
        return this.data;
    }

    public int getParity() {
        return this.parity;
    }

    public int getEcChunkSize() {
        return this.ecChunkSize;
    }

    public EcCodec getCodec() {
        return this.codec;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ECReplicationConfig that = (ECReplicationConfig)o;
        return this.data == that.data && this.parity == that.parity && this.codec == that.getCodec() && this.ecChunkSize == that.getEcChunkSize();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.data, this.parity, this.codec, this.ecChunkSize});
    }

    public String toString() {
        return HddsProtos.ReplicationType.EC + "/ECReplicationConfig{data=" + this.data + ", parity=" + this.parity + ", ecChunkSize=" + this.ecChunkSize + ", codec=" + (Object)((Object)this.codec) + '}';
    }

    @Override
    public String configFormat() {
        return HddsProtos.ReplicationType.EC.name() + "/" + this.data + EC_REPLICATION_PARAMS_DELIMITER + this.parity;
    }

    public static enum EcCodec {
        RS,
        XOR;


        public String toString() {
            return this.name().toLowerCase();
        }

        public static String allValuesAsString() {
            return EnumSet.allOf(EcCodec.class).stream().map(Enum::toString).collect(Collectors.joining(","));
        }
    }
}

