/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.client;

import java.util.Objects;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;

public class DefaultReplicationConfig {
    private ReplicationType type;
    private ReplicationFactor factor;
    private ECReplicationConfig ecReplicationConfig;

    public DefaultReplicationConfig(ReplicationType type, ReplicationFactor factor) {
        this.type = type;
        this.factor = factor;
        this.ecReplicationConfig = null;
    }

    public DefaultReplicationConfig(ReplicationConfig replicationConfig) {
        this.type = ReplicationType.fromProto(replicationConfig.getReplicationType());
        if (replicationConfig instanceof ECReplicationConfig) {
            this.ecReplicationConfig = (ECReplicationConfig)replicationConfig;
        } else {
            this.factor = ReplicationFactor.valueOf(replicationConfig.getRequiredNodes());
        }
    }

    public DefaultReplicationConfig(ReplicationType type, ECReplicationConfig ecReplicationConfig) {
        this.type = type;
        this.factor = null;
        this.ecReplicationConfig = ecReplicationConfig;
    }

    public DefaultReplicationConfig(ReplicationType type, ReplicationFactor factor, ECReplicationConfig ecReplicationConfig) {
        this.type = type;
        this.factor = factor;
        this.ecReplicationConfig = ecReplicationConfig;
    }

    public DefaultReplicationConfig(HddsProtos.DefaultReplicationConfig defaultReplicationConfig) {
        this.type = ReplicationType.fromProto(defaultReplicationConfig.getType());
        if (defaultReplicationConfig.hasEcReplicationConfig()) {
            this.ecReplicationConfig = new ECReplicationConfig(defaultReplicationConfig.getEcReplicationConfig());
        } else {
            this.factor = ReplicationFactor.fromProto(defaultReplicationConfig.getFactor());
        }
    }

    public ReplicationType getType() {
        return this.type;
    }

    public ReplicationFactor getFactor() {
        return this.factor;
    }

    public DefaultReplicationConfig copy() {
        return new DefaultReplicationConfig(this.type, this.factor, this.ecReplicationConfig);
    }

    public ECReplicationConfig getEcReplicationConfig() {
        return this.ecReplicationConfig;
    }

    public int getRequiredNodes() {
        if (this.type == ReplicationType.EC) {
            return this.ecReplicationConfig.getRequiredNodes();
        }
        return this.factor.getValue();
    }

    public HddsProtos.DefaultReplicationConfig toProto() {
        HddsProtos.DefaultReplicationConfig.Builder builder = HddsProtos.DefaultReplicationConfig.newBuilder().setType(ReplicationType.toProto(this.type));
        if (this.factor != null) {
            builder.setFactor(ReplicationFactor.toProto(this.factor));
        }
        if (this.ecReplicationConfig != null) {
            builder.setEcReplicationConfig(this.ecReplicationConfig.toProto());
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultReplicationConfig that = (DefaultReplicationConfig)o;
        return Objects.equals((Object)this.type, (Object)that.type) && Objects.equals((Object)this.factor, (Object)that.factor) && Objects.equals(this.ecReplicationConfig, that.ecReplicationConfig);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.factor, this.ecReplicationConfig});
    }
}

