/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.BlockExtendedInputStream;
import org.apache.hadoop.hdds.scm.storage.BlockLocationInfo;
import org.apache.hadoop.io.ByteBufferPool;
import org.apache.hadoop.ozone.client.io.BlockInputStreamFactory;
import org.apache.hadoop.ozone.client.io.ECBlockInputStream;
import org.apache.hadoop.ozone.client.io.ECBlockInputStreamFactory;
import org.apache.hadoop.ozone.client.io.ECBlockReconstructedInputStream;
import org.apache.hadoop.ozone.client.io.ECBlockReconstructedStripeInputStream;

public final class ECBlockInputStreamFactoryImpl
implements ECBlockInputStreamFactory {
    private final BlockInputStreamFactory inputStreamFactory;
    private final ByteBufferPool byteBufferPool;
    private final Supplier<ExecutorService> ecReconstructExecutorSupplier;

    public static ECBlockInputStreamFactory getInstance(BlockInputStreamFactory streamFactory, ByteBufferPool byteBufferPool, Supplier<ExecutorService> ecReconstructExecutorSupplier) {
        return new ECBlockInputStreamFactoryImpl(streamFactory, byteBufferPool, ecReconstructExecutorSupplier);
    }

    private ECBlockInputStreamFactoryImpl(BlockInputStreamFactory streamFactory, ByteBufferPool byteBufferPool, Supplier<ExecutorService> ecReconstructExecutorSupplier) {
        this.byteBufferPool = byteBufferPool;
        this.inputStreamFactory = streamFactory;
        this.ecReconstructExecutorSupplier = ecReconstructExecutorSupplier;
    }

    @Override
    public BlockExtendedInputStream create(boolean missingLocations, List<DatanodeDetails> failedLocations, ReplicationConfig repConfig, BlockLocationInfo blockInfo, boolean verifyChecksum, XceiverClientFactory xceiverFactory, Function<BlockID, Pipeline> refreshFunction) {
        if (missingLocations) {
            ECBlockReconstructedStripeInputStream sis = new ECBlockReconstructedStripeInputStream((ECReplicationConfig)repConfig, blockInfo, verifyChecksum, xceiverFactory, refreshFunction, this.inputStreamFactory, this.byteBufferPool, this.ecReconstructExecutorSupplier.get());
            if (failedLocations != null) {
                sis.addFailedDatanodes(failedLocations);
            }
            return new ECBlockReconstructedInputStream((ECReplicationConfig)repConfig, this.byteBufferPool, sis);
        }
        return new ECBlockInputStream((ECReplicationConfig)repConfig, blockInfo, verifyChecksum, xceiverFactory, refreshFunction, this.inputStreamFactory);
    }
}

