/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.BlockExtendedInputStream;
import org.apache.hadoop.hdds.scm.storage.BlockInputStream;
import org.apache.hadoop.hdds.scm.storage.BlockLocationInfo;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.io.ByteBufferPool;
import org.apache.hadoop.io.ElasticByteBufferPool;
import org.apache.hadoop.ozone.client.io.BlockInputStreamFactory;
import org.apache.hadoop.ozone.client.io.ECBlockInputStreamFactory;
import org.apache.hadoop.ozone.client.io.ECBlockInputStreamFactoryImpl;
import org.apache.hadoop.ozone.client.io.ECBlockInputStreamProxy;
import org.apache.hadoop.security.token.Token;

public class BlockInputStreamFactoryImpl
implements BlockInputStreamFactory {
    private ECBlockInputStreamFactory ecBlockStreamFactory;

    public static BlockInputStreamFactory getInstance(ByteBufferPool byteBufferPool, Supplier<ExecutorService> ecReconstructExecutorSupplier) {
        return new BlockInputStreamFactoryImpl(byteBufferPool, ecReconstructExecutorSupplier);
    }

    public BlockInputStreamFactoryImpl() {
        this((ByteBufferPool)new ElasticByteBufferPool(), Executors::newSingleThreadExecutor);
    }

    public BlockInputStreamFactoryImpl(ByteBufferPool byteBufferPool, Supplier<ExecutorService> ecReconstructExecutorSupplier) {
        this.ecBlockStreamFactory = ECBlockInputStreamFactoryImpl.getInstance(this, byteBufferPool, ecReconstructExecutorSupplier);
    }

    @Override
    public BlockExtendedInputStream create(ReplicationConfig repConfig, BlockLocationInfo blockInfo, Pipeline pipeline, Token<OzoneBlockTokenIdentifier> token, boolean verifyChecksum, XceiverClientFactory xceiverFactory, Function<BlockID, Pipeline> refreshFunction) {
        if (repConfig.getReplicationType().equals((Object)HddsProtos.ReplicationType.EC)) {
            return new ECBlockInputStreamProxy((ECReplicationConfig)repConfig, blockInfo, verifyChecksum, xceiverFactory, refreshFunction, this.ecBlockStreamFactory);
        }
        return new BlockInputStream(blockInfo.getBlockID(), blockInfo.getLength(), pipeline, token, verifyChecksum, xceiverFactory, refreshFunction);
    }
}

