/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.ContainerClientMetrics;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.XceiverClientReply;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.BlockOutputStream;
import org.apache.hadoop.hdds.scm.storage.BufferPool;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

public class ECBlockOutputStream
extends BlockOutputStream {
    private final DatanodeDetails datanodeDetails;
    private CompletableFuture<ContainerProtos.ContainerCommandResponseProto> currentChunkRspFuture = null;
    private CompletableFuture<ContainerProtos.ContainerCommandResponseProto> putBlkRspFuture = null;

    public ECBlockOutputStream(BlockID blockID, XceiverClientFactory xceiverClientManager, Pipeline pipeline, BufferPool bufferPool, OzoneClientConfig config, Token<? extends TokenIdentifier> token, ContainerClientMetrics clientMetrics) throws IOException {
        super(blockID, xceiverClientManager, pipeline, bufferPool, config, token, clientMetrics);
        this.datanodeDetails = pipeline.getClosestNode();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.currentChunkRspFuture = this.writeChunkToContainer(ChunkBuffer.wrap((ByteBuffer)ByteBuffer.wrap(b, off, len)));
        this.updateWrittenDataLength(len);
    }

    public CompletableFuture<ContainerProtos.ContainerCommandResponseProto> write(ByteBuffer buff) throws IOException {
        return this.writeChunkToContainer(ChunkBuffer.wrap((ByteBuffer)buff));
    }

    public CompletableFuture<ContainerProtos.ContainerCommandResponseProto> executePutBlock(boolean close, boolean force, long blockGroupLength) throws IOException {
        this.updateBlockGroupLengthInPutBlockMeta(blockGroupLength);
        return this.executePutBlock(close, force);
    }

    private void updateBlockGroupLengthInPutBlockMeta(long blockGroupLen) {
        ContainerProtos.KeyValue keyValue = ContainerProtos.KeyValue.newBuilder().setKey("blockGroupLen").setValue(String.valueOf(blockGroupLen)).build();
        List metadataList = this.getContainerBlockData().getMetadataList().stream().filter(kv -> !Objects.equals(kv.getKey(), "blockGroupLen")).collect(Collectors.toList());
        metadataList.add(keyValue);
        this.getContainerBlockData().clearMetadata();
        this.getContainerBlockData().addAllMetadata(metadataList);
    }

    @Override
    public CompletableFuture<ContainerProtos.ContainerCommandResponseProto> executePutBlock(boolean close, boolean force) throws IOException {
        this.checkOpen();
        CompletionStage flushFuture = null;
        try {
            ContainerProtos.BlockData blockData = this.getContainerBlockData().build();
            XceiverClientReply asyncReply = ContainerProtocolCalls.putBlockAsync((XceiverClientSpi)this.getXceiverClient(), (ContainerProtos.BlockData)blockData, (boolean)close, this.getToken());
            CompletableFuture future = asyncReply.getResponse();
            flushFuture = ((CompletableFuture)future.thenApplyAsync(e -> {
                try {
                    this.validateResponse((ContainerProtos.ContainerCommandResponseProto)e);
                }
                catch (IOException sce) {
                    throw new CompletionException(sce);
                }
                if (this.getIoException() == null) {
                    BlockID responseBlockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)e.getPutBlock().getCommittedBlockLength().getBlockID());
                    Preconditions.checkState((boolean)this.getBlockID().getContainerBlockID().equals((Object)responseBlockID.getContainerBlockID()));
                }
                return e;
            }, (Executor)this.getResponseExecutor())).exceptionally(e -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("putBlock failed for blockID {} with exception {}", (Object)this.getBlockID(), (Object)e.getLocalizedMessage());
                }
                CompletionException ce = new CompletionException((Throwable)e);
                this.setIoException(ce);
                throw ce;
            });
        }
        catch (IOException | ExecutionException e2) {
            throw new IOException("Unexpected Storage Container Exception: " + e2.toString(), e2);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            this.handleInterruptedException(ex, false);
        }
        this.putBlkRspFuture = flushFuture;
        return flushFuture;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.cleanup(false);
    }

    public CompletableFuture<ContainerProtos.ContainerCommandResponseProto> getCurrentChunkResponseFuture() {
        return this.currentChunkRspFuture;
    }

    public CompletableFuture<ContainerProtos.ContainerCommandResponseProto> getCurrentPutBlkResponseFuture() {
        return this.putBlkRspFuture;
    }

    public DatanodeDetails getDatanodeDetails() {
        return this.datanodeDetails;
    }

    @Override
    void validateResponse(ContainerProtos.ContainerCommandResponseProto responseProto) throws IOException {
        try {
            IOException exception = this.getIoException();
            if (exception != null) {
                return;
            }
            ContainerProtocolCalls.validateContainerResponse((ContainerProtos.ContainerCommandResponseProto)responseProto);
        }
        catch (IOException sce) {
            this.setIoException(sce);
        }
    }
}

