/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.hdds.scm.storage.ByteReaderStrategy;

public class ByteArrayReader
implements ByteReaderStrategy {
    private final byte[] readBuf;
    private int offset;
    private int targetLen;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Deep copy byte[] has bad impact on performance")
    public ByteArrayReader(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        this.readBuf = b;
        this.offset = off;
        this.targetLen = len;
    }

    @Override
    public int readFromBlock(InputStream is, int numBytesToRead) throws IOException {
        Preconditions.checkArgument((is != null ? 1 : 0) != 0);
        int numBytesRead = is.read(this.readBuf, this.offset, numBytesToRead);
        this.offset += numBytesRead;
        this.targetLen -= numBytesRead;
        return numBytesRead;
    }

    @Override
    public int getTargetLength() {
        return this.targetLen;
    }
}

