/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso.client;

import com.google.protobuf.MessageLite;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.omid.proto.TSOProto;
import org.apache.omid.tso.client.ConnectionException;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.SettableFuture;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSOClientRaw {
    private static final Logger LOG = LoggerFactory.getLogger(TSOClientRaw.class);
    private final BlockingQueue<SettableFuture<TSOProto.Response>> responseQueue = new ArrayBlockingQueue<SettableFuture<TSOProto.Response>>(5);
    private final Channel channel;

    public TSOClientRaw(String host, int port) throws InterruptedException, ExecutionException {
        InetSocketAddress addr = new InetSocketAddress(host, port);
        ThreadFactory workerThreadFactory = new ThreadFactoryBuilder().setNameFormat("tsoclient-worker-%d").build();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(3, workerThreadFactory);
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group((EventLoopGroup)workerGroup);
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addLast("lengthbaseddecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(8192, 0, 4, 0, 4));
                pipeline.addLast("lengthprepender", (ChannelHandler)new LengthFieldPrepender(4));
                pipeline.addLast("protobufdecoder", (ChannelHandler)new ProtobufDecoder((MessageLite)TSOProto.Response.getDefaultInstance()));
                pipeline.addLast("protobufencoder", (ChannelHandler)new ProtobufEncoder());
                pipeline.addLast("rawHandler", (ChannelHandler)new RawHandler());
            }
        });
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)100);
        ChannelFuture channelFuture = bootstrap.connect((SocketAddress)addr).await();
        this.channel = channelFuture.channel();
    }

    public void write(TSOProto.Request request) {
        this.channel.writeAndFlush((Object)request);
    }

    public Future<TSOProto.Response> getResponse() throws InterruptedException {
        SettableFuture future = SettableFuture.create();
        this.responseQueue.put((SettableFuture<TSOProto.Response>)future);
        return future;
    }

    public void close() throws InterruptedException {
        this.responseQueue.put((SettableFuture<TSOProto.Response>)SettableFuture.create());
        this.channel.close();
    }

    private class RawHandler
    extends ChannelInboundHandlerAdapter {
        private RawHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            LOG.info("Message received", msg);
            if (msg instanceof TSOProto.Response) {
                TSOProto.Response resp = (TSOProto.Response)msg;
                try {
                    SettableFuture future = (SettableFuture)TSOClientRaw.this.responseQueue.take();
                    future.set((Object)resp);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    LOG.warn("Interrupted in handler", (Throwable)ie);
                }
            } else {
                LOG.warn("Received unknown message", msg);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            LOG.info("Exception received", cause);
            try {
                SettableFuture future = (SettableFuture)TSOClientRaw.this.responseQueue.take();
                future.setException(cause);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                LOG.warn("Interrupted handling exception", (Throwable)ie);
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            LOG.info("Inactive");
            try {
                SettableFuture future = (SettableFuture)TSOClientRaw.this.responseQueue.take();
                future.setException((Throwable)new ConnectionException());
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                LOG.warn("Interrupted handling exception", (Throwable)ie);
            }
        }
    }
}

