/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import io.netty.channel.Channel;
import org.apache.commons.pool2.PooledObject;
import org.apache.omid.tso.Batch;
import org.apache.omid.tso.MonitoringContext;
import org.apache.omid.tso.MonitoringContextImpl;
import org.apache.omid.tso.PersistEvent;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestBatch {
    private static final Logger LOG = LoggerFactory.getLogger(TestBatch.class);
    private static final int BATCH_SIZE = 1000;
    private static final long ANY_ST = 1231L;
    private static final long ANY_CT = 2241L;
    @Mock
    private Channel channel;
    @Mock
    private MonitoringContextImpl monCtx;

    @BeforeMethod
    void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test(timeOut=10000L)
    public void testBatchFunctionality() {
        Batch batch = new Batch(0, 1000);
        Assert.assertTrue((boolean)batch.isEmpty(), (String)"Batch should be empty");
        Assert.assertFalse((boolean)batch.isFull(), (String)"Batch shouldn't be full");
        Assert.assertEquals((int)batch.getNumEvents(), (int)0, (String)"Num events should be 0");
        try {
            batch.get(1);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            batch.set(1, new PersistEvent());
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        for (int i = 0; i < 1000; ++i) {
            if (i % 4 == 0) {
                batch.addTimestamp(1231L, this.channel, (MonitoringContext)this.monCtx);
                continue;
            }
            if (i % 4 == 1) {
                batch.addCommit(1231L, 2241L, this.channel, (MonitoringContext)this.monCtx, Optional.absent());
                continue;
            }
            if (i % 4 == 2) {
                batch.addCommitRetry(1231L, this.channel, (MonitoringContext)this.monCtx);
                continue;
            }
            batch.addAbort(1231L, this.channel, (MonitoringContext)this.monCtx);
        }
        Assert.assertFalse((boolean)batch.isEmpty(), (String)"Batch should contain elements");
        Assert.assertTrue((boolean)batch.isFull(), (String)"Batch should be full");
        Assert.assertEquals((int)batch.getNumEvents(), (int)1000, (String)"Num events should be 1000");
        try {
            batch.addCommit(1231L, 2241L, this.channel, (MonitoringContext)this.monCtx, Optional.absent());
            Assert.fail((String)"Should throw an IllegalStateException");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"batch is full", (String)"message returned doesn't match");
            LOG.debug("IllegalStateException catch properly");
        }
        Assert.assertTrue((boolean)batch.isFull(), (String)"Batch shouldn't be empty");
        Assert.assertTrue((boolean)batch.get(0).getType().equals((Object)PersistEvent.Type.TIMESTAMP));
        Assert.assertTrue((boolean)batch.get(1).getType().equals((Object)PersistEvent.Type.COMMIT));
        Assert.assertTrue((boolean)batch.get(2).getType().equals((Object)PersistEvent.Type.COMMIT_RETRY));
        Assert.assertTrue((boolean)batch.get(3).getType().equals((Object)PersistEvent.Type.ABORT));
        batch.decreaseNumEvents();
        Assert.assertEquals((int)batch.getNumEvents(), (int)999, (String)"Num events should be 999");
        try {
            batch.get(999);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)batch.isFull(), (String)"Batch shouldn't be full");
        batch.clear();
        Assert.assertTrue((boolean)batch.isEmpty(), (String)"Batch should be empty");
        Assert.assertFalse((boolean)batch.isFull(), (String)"Batch shouldn't be full");
        Assert.assertEquals((int)batch.getNumEvents(), (int)0, (String)"Num events should be 0");
    }

    @Test(timeOut=10000L)
    public void testBatchFactoryFunctionality() throws Exception {
        Batch.BatchFactory factory = new Batch.BatchFactory(1000);
        Batch batch = factory.create();
        Assert.assertTrue((boolean)batch.isEmpty(), (String)"Batch should be empty");
        Assert.assertFalse((boolean)batch.isFull(), (String)"Batch shouldn't be full");
        Assert.assertEquals((int)batch.getNumEvents(), (int)0, (String)"Num events should be 0");
        PooledObject pooledBatch = factory.wrap(batch);
        Assert.assertEquals((Object)pooledBatch.getObject(), (Object)batch);
        batch.addTimestamp(1231L, this.channel, (MonitoringContext)this.monCtx);
        batch.addCommit(1231L, 2241L, this.channel, (MonitoringContext)this.monCtx, Optional.absent());
        batch.addCommitRetry(1231L, this.channel, (MonitoringContext)this.monCtx);
        batch.addAbort(1231L, this.channel, (MonitoringContext)this.monCtx);
        Assert.assertFalse((boolean)batch.isEmpty(), (String)"Batch should contain elements");
        Assert.assertFalse((boolean)batch.isFull(), (String)"Batch should NOT be full");
        Assert.assertEquals((int)batch.getNumEvents(), (int)4, (String)"Num events should be 4");
        factory.passivateObject(pooledBatch);
        Assert.assertTrue((boolean)batch.isEmpty(), (String)"Batch should NOT contain elements");
        Assert.assertFalse((boolean)batch.isFull(), (String)"Batch should NOT be full");
        Assert.assertEquals((int)batch.getNumEvents(), (int)0, (String)"Num events should be 0");
    }
}

