/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import com.google.protobuf.MessageLite;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;
import org.apache.omid.proto.TSOProto;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ProgrammableTSOServer
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ProgrammableTSOServer.class);
    private ChannelGroup allChannels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private Queue<Response> responseQueue = new LinkedList<Response>();
    private static final AttributeKey<TSOChannelContext> TSO_CTX = AttributeKey.valueOf((String)"TSO_CTX");

    @Inject
    public ProgrammableTSOServer(int port) {
        int workerThreadCount = (Runtime.getRuntime().availableProcessors() * 2 + 1) * 2;
        ThreadFactory bossThreadFactory = new ThreadFactoryBuilder().setNameFormat("tsoserver-boss-%d").build();
        ThreadFactory workerThreadFactory = new ThreadFactoryBuilder().setNameFormat("tsoserver-worker-%d").build();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(workerThreadCount, workerThreadFactory);
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(bossThreadFactory);
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup);
        bootstrap.channel(NioServerSocketChannel.class);
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addLast("lengthbaseddecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(0xA00000, 0, 4, 0, 4));
                pipeline.addLast("lengthprepender", (ChannelHandler)new LengthFieldPrepender(4));
                pipeline.addLast("protobufdecoder", (ChannelHandler)new ProtobufDecoder((MessageLite)TSOProto.Request.getDefaultInstance()));
                pipeline.addLast("protobufencoder", (ChannelHandler)new ProtobufEncoder());
                pipeline.addLast("handler", (ChannelHandler)ProgrammableTSOServer.this);
            }
        });
        Channel channel = bootstrap.bind((SocketAddress)new InetSocketAddress(port)).syncUninterruptibly().channel();
        this.allChannels.add((Object)channel);
        LOG.info("********** Dumb TSO Server running on port {} **********", (Object)port);
    }

    public void queueResponse(Response r) {
        this.responseQueue.add(r);
    }

    public void cleanResponses() {
        this.responseQueue.clear();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.allChannels.add((Object)ctx.channel());
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        block10: {
            block8: {
                TSOProto.Request request;
                block11: {
                    Response resp;
                    Channel channel;
                    block9: {
                        if (!(msg instanceof TSOProto.Request)) break block8;
                        request = (TSOProto.Request)msg;
                        channel = ctx.channel();
                        if (request.hasHandshakeRequest()) {
                            this.checkHandshake(ctx, request.getHandshakeRequest());
                            return;
                        }
                        if (!this.handshakeCompleted(ctx)) {
                            LOG.info("handshake not completed");
                            channel.close();
                        }
                        resp = this.responseQueue.poll();
                        if (!request.hasTimestampRequest()) break block9;
                        if (resp == null || resp.type != Response.ResponseType.TIMESTAMP) {
                            throw new IllegalStateException("Expecting TS response to send but got " + resp);
                        }
                        TimestampResponse tsResp = (TimestampResponse)resp;
                        this.sendTimestampResponse(tsResp.startTS, channel);
                        break block10;
                    }
                    if (!request.hasCommitRequest()) break block11;
                    if (resp == null) {
                        throw new IllegalStateException("Expecting COMMIT response to send but got null");
                    }
                    switch (resp.type) {
                        case COMMIT: {
                            CommitResponse commitResp = (CommitResponse)resp;
                            this.sendCommitResponse(commitResp.startTS, commitResp.commitTS, channel);
                            break block10;
                        }
                        case ABORT: {
                            AbortResponse abortResp = (AbortResponse)resp;
                            this.sendAbortResponse(abortResp.startTS, channel);
                            break block10;
                        }
                        default: {
                            throw new IllegalStateException("Expecting COMMIT response to send but got " + (Object)((Object)resp.type));
                        }
                    }
                }
                LOG.error("Invalid request {}", (Object)request);
                ctx.channel().close();
                break block10;
            }
            LOG.error("Unknown message type", msg);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause instanceof ClosedChannelException) {
            return;
        }
        LOG.warn("TSOHandler: Unexpected exception.", cause);
        ctx.channel().close();
    }

    private void checkHandshake(ChannelHandlerContext ctx, TSOProto.HandshakeRequest request) {
        TSOProto.HandshakeResponse.Builder response = TSOProto.HandshakeResponse.newBuilder();
        if (request.hasClientCapabilities()) {
            response.setClientCompatible(true).setServerCapabilities(TSOProto.Capabilities.newBuilder().build());
            TSOChannelContext tsoCtx = new TSOChannelContext();
            tsoCtx.setHandshakeComplete();
            ctx.channel().attr(TSO_CTX).set((Object)tsoCtx);
        } else {
            response.setClientCompatible(false);
        }
        ctx.channel().writeAndFlush((Object)TSOProto.Response.newBuilder().setHandshakeResponse(response.build()).build());
    }

    private boolean handshakeCompleted(ChannelHandlerContext ctx) {
        Object o = ctx.channel().attr(TSO_CTX).get();
        if (o instanceof TSOChannelContext) {
            TSOChannelContext tsoCtx = (TSOChannelContext)o;
            return tsoCtx.getHandshakeComplete();
        }
        return false;
    }

    private void sendTimestampResponse(long startTimestamp, Channel c) {
        TSOProto.Response.Builder builder = TSOProto.Response.newBuilder();
        TSOProto.TimestampResponse.Builder respBuilder = TSOProto.TimestampResponse.newBuilder();
        respBuilder.setStartTimestamp(startTimestamp);
        builder.setTimestampResponse(respBuilder.build());
        c.writeAndFlush((Object)builder.build());
    }

    private void sendCommitResponse(long startTimestamp, long commitTimestamp, Channel c) {
        TSOProto.Response.Builder builder = TSOProto.Response.newBuilder();
        TSOProto.CommitResponse.Builder commitBuilder = TSOProto.CommitResponse.newBuilder();
        commitBuilder.setAborted(false).setStartTimestamp(startTimestamp).setCommitTimestamp(commitTimestamp);
        builder.setCommitResponse(commitBuilder.build());
        c.writeAndFlush((Object)builder.build());
    }

    private void sendAbortResponse(long startTimestamp, Channel c) {
        TSOProto.Response.Builder builder = TSOProto.Response.newBuilder();
        TSOProto.CommitResponse.Builder commitBuilder = TSOProto.CommitResponse.newBuilder();
        commitBuilder.setAborted(true).setStartTimestamp(startTimestamp);
        builder.setCommitResponse(commitBuilder.build());
        c.writeAndFlush((Object)builder.build());
    }

    static abstract class Response {
        final ResponseType type;

        public Response(ResponseType type) {
            this.type = type;
        }

        static enum ResponseType {
            TIMESTAMP,
            COMMIT,
            ABORT;

        }
    }

    public static class AbortResponse
    extends Response {
        final long startTS;

        public AbortResponse(long startTS) {
            super(Response.ResponseType.ABORT);
            this.startTS = startTS;
        }
    }

    public static class CommitResponse
    extends Response {
        final long startTS;
        final long commitTS;

        public CommitResponse(long startTS, long commitTS) {
            super(Response.ResponseType.COMMIT);
            this.startTS = startTS;
            this.commitTS = commitTS;
        }
    }

    public static class TimestampResponse
    extends Response {
        final long startTS;

        public TimestampResponse(long startTS) {
            super(Response.ResponseType.TIMESTAMP);
            this.startTS = startTS;
        }
    }

    private static class TSOChannelContext {
        boolean handshakeComplete = false;

        TSOChannelContext() {
        }

        boolean getHandshakeComplete() {
            return this.handshakeComplete;
        }

        void setHandshakeComplete() {
            this.handshakeComplete = true;
        }
    }
}

