/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.io.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;

public class YAMLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(YAMLUtils.class);

    public void loadSettings(String resourcePath, String defaultResourcePath, Object bean) {
        try {
            Map properties = this.loadSettings(resourcePath, defaultResourcePath);
            BeanUtils.populate((Object)bean, (Map)properties);
        }
        catch (IOException | IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public void loadSettings(String resourcePath, Object bean) {
        try {
            Map properties = this.loadSettings(null, resourcePath);
            BeanUtils.populate((Object)bean, (Map)properties);
        }
        catch (IOException | IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public Map loadSettings(String resourcePath, String defaultResourcePath) throws IOException {
        Map defaultSetting = this.loadAsMap(defaultResourcePath);
        Preconditions.checkState((defaultSetting.size() > 0 ? 1 : 0) != 0, (Object)String.format("Failed to load file '%s' from classpath", defaultResourcePath));
        if (resourcePath != null) {
            Map userSetting = this.loadAsMap(resourcePath);
            defaultSetting.putAll(userSetting);
        }
        return defaultSetting;
    }

    public Map loadAsMap(String path) throws IOException {
        try {
            String content = Resources.toString((URL)Resources.getResource((String)path), (Charset)Charset.forName("UTF-8"));
            LOG.debug("Loaded resource file '{}'\n{}", (Object)path, (Object)content);
            return this.loadStringAsMap(content);
        }
        catch (IllegalArgumentException e) {
            return new HashMap();
        }
    }

    public Map loadStringAsMap(String content) {
        try {
            LoaderOptions options = new LoaderOptions();
            options.setTagInspector(tagInspector -> tagInspector.getClassName().startsWith("org.apache.omid"));
            Yaml yaml = new Yaml(options);
            Map settings = (Map)yaml.loadAs(content, Map.class);
            return settings != null ? settings : new HashMap(0);
        }
        catch (IllegalArgumentException e) {
            return new HashMap();
        }
    }
}

