/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ExecutionException;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.transaction.CellInfo;
import org.apache.omid.transaction.CellUtils;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.apache.phoenix.thirdparty.com.google.common.collect.Iterators;
import org.apache.phoenix.thirdparty.com.google.common.collect.PeekingIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactorScanner
implements InternalScanner {
    private static final Logger LOG = LoggerFactory.getLogger(CompactorScanner.class);
    private final InternalScanner internalScanner;
    private final CommitTable.Client commitTableClient;
    private final boolean isMajorCompaction;
    private final boolean retainNonTransactionallyDeletedCells;
    private final long lowWatermark;
    private final Region hRegion;
    private boolean hasMoreRows = false;
    private List<Cell> currentRowWorthValues = new ArrayList<Cell>();
    private final LRUMap<Long, Optional<CommitTable.CommitTimestamp>> commitCache;

    public CompactorScanner(ObserverContext<RegionCoprocessorEnvironment> e, InternalScanner internalScanner, CommitTable.Client commitTableClient, boolean isMajorCompaction, boolean preserveNonTransactionallyDeletedCells) throws IOException {
        this.internalScanner = internalScanner;
        this.commitTableClient = commitTableClient;
        this.isMajorCompaction = isMajorCompaction;
        this.retainNonTransactionallyDeletedCells = preserveNonTransactionallyDeletedCells;
        this.lowWatermark = this.getLowWatermarkFromCommitTable();
        this.hRegion = ((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion();
        this.commitCache = new LRUMap(1000);
        LOG.info("Scanner cleaning up uncommitted txs older than LW [{}] in region [{}]", (Object)this.lowWatermark, (Object)this.hRegion.getRegionInfo());
    }

    public boolean next(List<Cell> results) throws IOException {
        return this.next(results, -1);
    }

    public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
        int limit = scannerContext.getBatchLimit();
        return this.next(result, limit);
    }

    public boolean next(List<Cell> result, int limit) throws IOException {
        if (this.currentRowWorthValues.isEmpty()) {
            ArrayList<Cell> scanResult = new ArrayList<Cell>();
            this.hasMoreRows = this.internalScanner.next(scanResult);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Row: Result {} limit {} more rows? {}", new Object[]{scanResult, limit, this.hasMoreRows});
            }
            SortedMap<Cell, Optional<Cell>> cellToSc = CellUtils.mapCellsToShadowCells(scanResult);
            HashMap<String, CellInfo> lastTimestampedCellsInRow = new HashMap<String, CellInfo>();
            PeekingIterator iter = Iterators.peekingIterator(cellToSc.entrySet().iterator());
            while (iter.hasNext()) {
                Optional<CommitTable.CommitTimestamp> commitTimestamp;
                Map.Entry entry = (Map.Entry)iter.next();
                Cell cell = (Cell)entry.getKey();
                Optional shadowCellOp = (Optional)entry.getValue();
                if (cell.getTimestamp() > this.lowWatermark) {
                    this.retain(this.currentRowWorthValues, cell, (Optional<Cell>)shadowCellOp);
                    continue;
                }
                if (this.shouldRetainNonTransactionallyDeletedCell(cell)) {
                    this.retain(this.currentRowWorthValues, cell, (Optional<Cell>)shadowCellOp);
                    continue;
                }
                if (this.isMajorCompaction && CellUtils.isTombstone(cell)) {
                    if (shadowCellOp.isPresent()) {
                        this.skipToNextColumn(cell, (PeekingIterator<Map.Entry<Cell, Optional<Cell>>>)iter);
                        continue;
                    }
                    commitTimestamp = this.queryCommitTimestamp(cell);
                    if (!commitTimestamp.isPresent() || !((CommitTable.CommitTimestamp)commitTimestamp.get()).isValid()) continue;
                    this.skipToNextColumn(cell, (PeekingIterator<Map.Entry<Cell, Optional<Cell>>>)iter);
                    continue;
                }
                if (shadowCellOp.isPresent()) {
                    this.saveLastTimestampedCell(lastTimestampedCellsInRow, cell, (Cell)shadowCellOp.get());
                    continue;
                }
                commitTimestamp = this.queryCommitTimestamp(cell);
                if (commitTimestamp.isPresent() && ((CommitTable.CommitTimestamp)commitTimestamp.get()).isValid()) {
                    byte[] shadowCellValue = Bytes.toBytes((long)((CommitTable.CommitTimestamp)commitTimestamp.get()).getValue());
                    Cell shadowCell = CellUtils.buildShadowCellFromCell(cell, shadowCellValue);
                    this.saveLastTimestampedCell(lastTimestampedCellsInRow, cell, shadowCell);
                    continue;
                }
                LOG.trace("Discarding cell {}", (Object)cell);
            }
            this.retainLastTimestampedCellsSaved(this.currentRowWorthValues, lastTimestampedCellsInRow);
            Collections.sort(this.currentRowWorthValues, CellComparator.getInstance());
        }
        if (this.currentRowWorthValues.size() <= limit || limit == -1) {
            result.addAll(this.currentRowWorthValues);
            this.currentRowWorthValues.clear();
        } else {
            result.addAll(this.currentRowWorthValues.subList(0, limit));
            this.currentRowWorthValues.subList(0, limit).clear();
        }
        LOG.trace("Results to preserve {}", result);
        return this.hasMoreRows;
    }

    public void close() throws IOException {
        this.internalScanner.close();
    }

    @VisibleForTesting
    public boolean shouldRetainNonTransactionallyDeletedCell(Cell cell) {
        return (CellUtil.isDelete((Cell)cell) || cell.getType() == Cell.Type.DeleteFamily) && this.retainNonTransactionallyDeletedCells;
    }

    private void saveLastTimestampedCell(Map<String, CellInfo> lastCells, Cell cell, Cell shadowCell) {
        String cellKey = Bytes.toString((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength()) + ":" + Bytes.toString((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength());
        LOG.trace("Cell Key: {}", (Object)cellKey);
        if (!lastCells.containsKey(cellKey)) {
            lastCells.put(cellKey, new CellInfo(cell, shadowCell));
        } else if (lastCells.get(cellKey).getTimestamp() < cell.getTimestamp()) {
            lastCells.put(cellKey, new CellInfo(cell, shadowCell));
        } else {
            LOG.trace("Forgetting old cell {}", (Object)cell);
        }
    }

    private long getLowWatermarkFromCommitTable() throws IOException {
        try {
            LOG.trace("About to read log watermark from commit table");
            return (Long)this.commitTableClient.readLowWatermark().get();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOG.warn("Interrupted getting low watermark from commit table", (Throwable)ie);
            throw new IOException("Interrupted getting low watermark from commit table");
        }
        catch (ExecutionException ee) {
            LOG.warn("Problem getting low watermark from commit table");
            throw new IOException("Problem getting low watermark from commit table", ee.getCause());
        }
    }

    private Result getShadowCell(byte[] row, byte[] family, byte[] qualifier, long timestamp) throws IOException {
        Get g = new Get(row);
        g.addColumn(family, qualifier);
        g.setTimestamp(timestamp);
        Result r = this.hRegion.get(g);
        return r;
    }

    private Optional<CommitTable.CommitTimestamp> getCommitTimestampWithRaces(Cell cell) throws IOException {
        try {
            byte[] family = CellUtil.cloneFamily((Cell)cell);
            byte[] qualifier = CellUtils.addShadowCellSuffixPrefix(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
            Optional ct = (Optional)this.commitTableClient.getCommitTimestamp(cell.getTimestamp()).get();
            if (ct.isPresent() && ((CommitTable.CommitTimestamp)ct.get()).isValid()) {
                return Optional.of((Object)ct.get());
            }
            Result r = this.getShadowCell(CellUtil.cloneRow((Cell)cell), family, qualifier, cell.getTimestamp());
            if (r.containsColumn(CellUtil.cloneFamily((Cell)cell), qualifier)) {
                Optional retval = Optional.of((Object)new CommitTable.CommitTimestamp(CommitTable.CommitTimestamp.Location.SHADOW_CELL, Bytes.toLong((byte[])r.getValue(family, qualifier)), true));
                return retval;
            }
            Boolean invalidated = (Boolean)this.commitTableClient.tryInvalidateTransaction(cell.getTimestamp()).get();
            if (invalidated.booleanValue()) {
                Result r2 = this.getShadowCell(CellUtil.cloneRow((Cell)cell), family, qualifier, cell.getTimestamp());
                if (r2.containsColumn(CellUtil.cloneFamily((Cell)cell), qualifier)) {
                    Optional retval = Optional.of((Object)new CommitTable.CommitTimestamp(CommitTable.CommitTimestamp.Location.SHADOW_CELL, Bytes.toLong((byte[])r2.getValue(family, qualifier)), true));
                    this.commitTableClient.deleteCommitEntry(cell.getTimestamp());
                    return retval;
                }
                return Optional.absent();
            }
            Optional ct2 = (Optional)this.commitTableClient.getCommitTimestamp(cell.getTimestamp()).get();
            if (ct2.isPresent()) {
                return Optional.of((Object)ct2.get());
            }
            Result r2 = this.getShadowCell(CellUtil.cloneRow((Cell)cell), family, qualifier, cell.getTimestamp());
            if (r2.containsColumn(CellUtil.cloneFamily((Cell)cell), qualifier)) {
                Optional retval = Optional.of((Object)new CommitTable.CommitTimestamp(CommitTable.CommitTimestamp.Location.SHADOW_CELL, Bytes.toLong((byte[])r2.getValue(family, qualifier)), true));
                return retval;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while getting commit timestamp from commit table");
        }
        catch (ExecutionException e) {
            throw new IOException("Error getting commit timestamp from commit table", e);
        }
        return Optional.absent();
    }

    private Optional<CommitTable.CommitTimestamp> queryCommitTimestamp(Cell cell) throws IOException {
        Optional cachedValue = (Optional)this.commitCache.get((Object)cell.getTimestamp());
        if (cachedValue != null) {
            return cachedValue;
        }
        Optional<CommitTable.CommitTimestamp> value = this.getCommitTimestampWithRaces(cell);
        this.commitCache.put((Object)cell.getTimestamp(), value);
        return value;
    }

    private void retain(List<Cell> result, Cell cell, Optional<Cell> shadowCell) {
        LOG.trace("Retaining cell {}", (Object)cell);
        result.add(cell);
        if (shadowCell.isPresent()) {
            LOG.trace("...with shadow cell {}", (Object)cell, shadowCell.get());
            result.add((Cell)shadowCell.get());
        } else {
            LOG.trace("...without shadow cell! (TS is above Low Watermark)");
        }
    }

    private void retainLastTimestampedCellsSaved(List<Cell> result, Map<String, CellInfo> lastTimestampedCellsInRow) {
        for (CellInfo cellInfo : lastTimestampedCellsInRow.values()) {
            LOG.trace("Retaining last cell {} with shadow cell {}", (Object)cellInfo.getCell(), (Object)cellInfo.getShadowCell());
            result.add(cellInfo.getCell());
            result.add(cellInfo.getShadowCell());
        }
    }

    private void skipToNextColumn(Cell cell, PeekingIterator<Map.Entry<Cell, Optional<Cell>>> iter) {
        boolean isFamilyDelete = CellUtils.isFamilyDeleteCell(cell);
        while (iter.hasNext() && CellUtil.matchingFamily((Cell)((Cell)((Map.Entry)iter.peek()).getKey()), (Cell)cell) && (CellUtil.matchingQualifier((Cell)((Cell)((Map.Entry)iter.peek()).getKey()), (Cell)cell) || isFamilyDelete)) {
            iter.next();
        }
    }
}

