/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.committable.hbase;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;

public class RegionSplitter {
    public static SplitAlgorithm newSplitAlgoInstance(Configuration conf, String splitClassName) throws IOException {
        Class splitClass;
        if (splitClassName.equals(UniformSplit.class.getSimpleName())) {
            splitClass = UniformSplit.class;
        } else {
            try {
                splitClass = conf.getClassByName(splitClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Couldn't load split class " + splitClassName, e);
            }
            if (splitClass == null) {
                throw new IOException("Failed loading split class " + splitClassName);
            }
            if (!SplitAlgorithm.class.isAssignableFrom(splitClass)) {
                throw new IOException("Specified split class doesn't implement SplitAlgorithm");
            }
        }
        try {
            return splitClass.asSubclass(SplitAlgorithm.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IOException("Problem loading split algorithm: ", e);
        }
    }

    public static class UniformSplit
    implements SplitAlgorithm {
        static final byte xFF = -1;
        byte[] firstRowBytes = ArrayUtils.EMPTY_BYTE_ARRAY;
        byte[] lastRowBytes = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};

        @Override
        public byte[] split(byte[] start, byte[] end) {
            return Bytes.split((byte[])start, (byte[])end, (int)1)[1];
        }

        @Override
        public byte[][] split(int numRegions) {
            Preconditions.checkArgument((Bytes.compareTo((byte[])this.lastRowBytes, (byte[])this.firstRowBytes) > 0 ? 1 : 0) != 0, (String)"last row (%s) is configured less than first row (%s)", (Object)Bytes.toStringBinary((byte[])this.lastRowBytes), (Object)Bytes.toStringBinary((byte[])this.firstRowBytes));
            byte[][] splits = Bytes.split((byte[])this.firstRowBytes, (byte[])this.lastRowBytes, (boolean)true, (int)(numRegions - 1));
            Preconditions.checkState((splits != null ? 1 : 0) != 0, (Object)("Could not split region with given user input: " + this));
            return (byte[][])Arrays.copyOfRange(splits, 1, splits.length - 1);
        }

        @Override
        public byte[] firstRow() {
            return this.firstRowBytes;
        }

        @Override
        public byte[] lastRow() {
            return this.lastRowBytes;
        }

        @Override
        public void setFirstRow(String userInput) {
            this.firstRowBytes = Bytes.toBytesBinary((String)userInput);
        }

        @Override
        public void setLastRow(String userInput) {
            this.lastRowBytes = Bytes.toBytesBinary((String)userInput);
        }

        @Override
        public void setFirstRow(byte[] userInput) {
            this.firstRowBytes = userInput;
        }

        @Override
        public void setLastRow(byte[] userInput) {
            this.lastRowBytes = userInput;
        }

        @Override
        public byte[] strToRow(String input) {
            return Bytes.toBytesBinary((String)input);
        }

        @Override
        public String rowToStr(byte[] row) {
            return Bytes.toStringBinary((byte[])row);
        }

        @Override
        public String separator() {
            return ",";
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [" + this.rowToStr(this.firstRow()) + "," + this.rowToStr(this.lastRow()) + "]";
        }
    }

    public static interface SplitAlgorithm {
        public byte[] split(byte[] var1, byte[] var2);

        public byte[][] split(int var1);

        public byte[] firstRow();

        public byte[] lastRow();

        public void setFirstRow(String var1);

        public void setLastRow(String var1);

        public byte[] strToRow(String var1);

        public String rowToStr(byte[] var1);

        public String separator();

        public void setFirstRow(byte[] var1);

        public void setLastRow(byte[] var1);
    }
}

