/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.transaction;

import org.apache.omid.transaction.TTable;
import org.apache.omid.tso.client.CellId;
import org.apache.phoenix.thirdparty.com.google.common.base.Charsets;
import org.apache.phoenix.thirdparty.com.google.common.hash.Hasher;
import org.apache.phoenix.thirdparty.com.google.common.hash.Hashing;

public class HBaseCellId
implements CellId {
    private final TTable table;
    private final byte[] row;
    private final byte[] family;
    private final byte[] qualifier;
    private long timestamp;

    public HBaseCellId(TTable table, byte[] row, byte[] family, byte[] qualifier, long timestamp) {
        this.timestamp = timestamp;
        this.table = table;
        this.row = row;
        this.family = family;
        this.qualifier = qualifier;
    }

    public TTable getTable() {
        return this.table;
    }

    public byte[] getRow() {
        return this.row;
    }

    public byte[] getFamily() {
        return this.family;
    }

    public byte[] getQualifier() {
        return this.qualifier;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return new String(this.table.getTableName(), Charsets.UTF_8) + ":" + new String(this.row, Charsets.UTF_8) + ":" + new String(this.family, Charsets.UTF_8) + ":" + new String(this.qualifier, Charsets.UTF_8) + ":" + this.timestamp;
    }

    public long getCellId() {
        return HBaseCellId.getHasher().putBytes(this.table.getTableName()).putBytes(this.row).putBytes(this.family).putBytes(this.qualifier).hash().asLong();
    }

    public long getTableId() {
        return HBaseCellId.getHasher().putBytes(this.table.getTableName()).hash().asLong();
    }

    public long getRowId() {
        return HBaseCellId.getHasher().putBytes(this.table.getTableName()).putBytes(this.row).hash().asLong();
    }

    public static Hasher getHasher() {
        return Hashing.murmur3_128().newHasher();
    }
}

