/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.db;

import java.sql.SQLException;
import javax.annotation.PostConstruct;
import javax.script.ScriptException;
import javax.sql.DataSource;
import org.apache.nifi.registry.db.TestDataSourceFactory;
import org.postgresql.ds.PGSimpleDataSource;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.jdbc.JdbcDatabaseDelegate;

@Configuration
@Profile(value={"postgres-11"})
public class Postgres11DataSourceFactory
extends TestDataSourceFactory {
    private static final PostgreSQLContainer POSTGRESQL_CONTAINER = new PostgreSQLContainer("postgres:11");

    @Override
    protected DataSource createDataSource() {
        PGSimpleDataSource dataSource = new PGSimpleDataSource();
        dataSource.setUrl(POSTGRESQL_CONTAINER.getJdbcUrl());
        dataSource.setUser(POSTGRESQL_CONTAINER.getUsername());
        dataSource.setPassword(POSTGRESQL_CONTAINER.getPassword());
        return dataSource;
    }

    @PostConstruct
    public void initDatabase() throws SQLException, ScriptException {
        JdbcDatabaseDelegate databaseDelegate = new JdbcDatabaseDelegate((JdbcDatabaseContainer)POSTGRESQL_CONTAINER, "");
        databaseDelegate.execute("DROP DATABASE test; CREATE DATABASE test;", "", 0, false, true);
    }

    static {
        POSTGRESQL_CONTAINER.start();
    }
}

