/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.db;

import com.mysql.cj.jdbc.MysqlDataSource;
import java.sql.SQLException;
import javax.annotation.PostConstruct;
import javax.script.ScriptException;
import javax.sql.DataSource;
import org.apache.nifi.registry.db.TestDataSourceFactory;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.jdbc.JdbcDatabaseDelegate;

public abstract class MySqlDataSourceFactory
extends TestDataSourceFactory {
    protected abstract MySQLContainer mysqlContainer();

    @Override
    protected DataSource createDataSource() {
        MySQLContainer container = this.mysqlContainer();
        MysqlDataSource dataSource = new MysqlDataSource();
        dataSource.setUrl(container.getJdbcUrl());
        dataSource.setUser(container.getUsername());
        dataSource.setPassword(container.getPassword());
        dataSource.setDatabaseName(container.getDatabaseName());
        return dataSource;
    }

    @PostConstruct
    public void initDatabase() throws SQLException, ScriptException {
        JdbcDatabaseDelegate databaseDelegate = new JdbcDatabaseDelegate((JdbcDatabaseContainer)this.mysqlContainer(), "");
        databaseDelegate.execute("DROP DATABASE test; CREATE DATABASE test;", "", 0, false, true);
    }
}

