/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.db;

import java.sql.SQLException;
import javax.annotation.PostConstruct;
import javax.script.ScriptException;
import javax.sql.DataSource;
import org.apache.nifi.registry.db.TestDataSourceFactory;
import org.mariadb.jdbc.MariaDbDataSource;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.MariaDBContainer;
import org.testcontainers.jdbc.JdbcDatabaseDelegate;

public abstract class MariaDBDataSourceFactory
extends TestDataSourceFactory {
    protected abstract MariaDBContainer mariaDBContainer();

    @Override
    protected DataSource createDataSource() {
        try {
            MariaDBContainer container = this.mariaDBContainer();
            MariaDbDataSource dataSource = new MariaDbDataSource();
            dataSource.setUrl(container.getJdbcUrl());
            dataSource.setUser(container.getUsername());
            dataSource.setPassword(container.getPassword());
            dataSource.setDatabaseName(container.getDatabaseName());
            return dataSource;
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to create MariaDB DataSource", e);
        }
    }

    @PostConstruct
    public void initDatabase() throws SQLException, ScriptException {
        JdbcDatabaseDelegate databaseDelegate = new JdbcDatabaseDelegate((JdbcDatabaseContainer)this.mariaDBContainer(), "");
        databaseDelegate.execute("DROP DATABASE test; CREATE DATABASE test;", "", 0, false, true);
    }
}

