/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.revision.standard;

import org.apache.nifi.registry.revision.api.UpdateResult;

public class StandardUpdateResult<T>
implements UpdateResult<T> {
    private final T entity;
    private final String entityId;
    private final String updaterIdentity;

    public StandardUpdateResult(T entity, String entityId, String updaterIdentity) {
        this.entity = entity;
        this.entityId = entityId;
        this.updaterIdentity = updaterIdentity;
        if (this.entity == null) {
            throw new IllegalArgumentException("Entity is required");
        }
        if (this.entityId == null || this.entityId.trim().isEmpty()) {
            throw new IllegalArgumentException("Entity id is required");
        }
        if (this.updaterIdentity == null || this.updaterIdentity.trim().isEmpty()) {
            throw new IllegalArgumentException("Updater identity is required");
        }
    }

    public T getEntity() {
        return this.entity;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String updaterIdentity() {
        return this.updaterIdentity;
    }
}

