/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.revision.standard;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.registry.revision.api.EntityModification;
import org.apache.nifi.registry.revision.api.Revision;
import org.apache.nifi.registry.revision.api.RevisionUpdate;

public class StandardRevisionUpdate<T>
implements RevisionUpdate<T> {
    private final T entity;
    private final EntityModification lastModification;
    private final Set<Revision> updatedRevisions;

    public StandardRevisionUpdate(T entity, EntityModification lastModification) {
        this(entity, lastModification, null);
    }

    public StandardRevisionUpdate(T entity, EntityModification lastModification, Set<Revision> updatedRevisions) {
        this.entity = entity;
        this.lastModification = lastModification;
        Set<Revision> set = this.updatedRevisions = updatedRevisions == null ? new HashSet<Revision>() : new HashSet<Revision>(updatedRevisions);
        if (lastModification != null) {
            this.updatedRevisions.add(lastModification.getRevision());
        }
    }

    public T getEntity() {
        return this.entity;
    }

    public EntityModification getLastModification() {
        return this.lastModification;
    }

    public Set<Revision> getUpdatedRevisions() {
        return Collections.unmodifiableSet(this.updatedRevisions);
    }

    public String toString() {
        return "[Entity=" + this.entity + ", Last Modification=" + this.lastModification + "]";
    }
}

