/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.revision.naive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.nifi.registry.revision.api.DeleteRevisionTask;
import org.apache.nifi.registry.revision.api.EntityModification;
import org.apache.nifi.registry.revision.api.ExpiredRevisionClaimException;
import org.apache.nifi.registry.revision.api.InvalidRevisionException;
import org.apache.nifi.registry.revision.api.Revision;
import org.apache.nifi.registry.revision.api.RevisionClaim;
import org.apache.nifi.registry.revision.api.RevisionManager;
import org.apache.nifi.registry.revision.api.RevisionUpdate;
import org.apache.nifi.registry.revision.api.UpdateResult;
import org.apache.nifi.registry.revision.api.UpdateRevisionTask;
import org.apache.nifi.registry.revision.standard.RevisionComparator;
import org.apache.nifi.registry.revision.standard.StandardRevisionUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NaiveRevisionManager
implements RevisionManager {
    private static final Logger logger = LoggerFactory.getLogger(NaiveRevisionManager.class);
    private final ConcurrentMap<String, Revision> revisionMap = new ConcurrentHashMap<String, Revision>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(Collection<Revision> revisions) {
        NaiveRevisionManager naiveRevisionManager = this;
        synchronized (naiveRevisionManager) {
            this.revisionMap.clear();
            for (Revision revision : revisions) {
                this.revisionMap.put(revision.getEntityId(), revision);
            }
        }
    }

    public List<Revision> getAllRevisions() {
        return new ArrayList<Revision>(this.revisionMap.values());
    }

    public Map<String, Revision> getRevisionMap() {
        return new HashMap<String, Revision>(this.revisionMap);
    }

    public Revision getRevision(String componentId) {
        return this.revisionMap.computeIfAbsent(componentId, id -> new Revision(Long.valueOf(0L), null, componentId));
    }

    public <T> T deleteRevision(RevisionClaim claim, DeleteRevisionTask<T> task) throws ExpiredRevisionClaimException {
        logger.debug("Attempting to delete revision using {}", (Object)claim);
        ArrayList<Revision> revisionList = new ArrayList<Revision>(claim.getRevisions());
        revisionList.sort(new RevisionComparator());
        String failedId = null;
        for (Revision revision : revisionList) {
            Revision curRevision = this.getRevision(revision.getEntityId());
            if (curRevision.equals((Object)revision)) continue;
            throw new ExpiredRevisionClaimException("Invalid Revision was given for entity with ID '" + failedId + "'");
        }
        Object taskResult = task.performTask();
        for (Revision revision : revisionList) {
            this.revisionMap.remove(revision.getEntityId());
        }
        return (T)taskResult;
    }

    public <T> RevisionUpdate<T> updateRevision(RevisionClaim originalClaim, UpdateRevisionTask<T> task) throws ExpiredRevisionClaimException {
        logger.debug("Attempting to update revision using {}", (Object)originalClaim);
        ArrayList<Revision> revisionList = new ArrayList<Revision>(originalClaim.getRevisions());
        revisionList.sort(new RevisionComparator());
        for (Revision revision : revisionList) {
            Object currentRevision;
            boolean verified = revision.equals(currentRevision = this.getRevision(revision.getEntityId()));
            if (verified) continue;
            throw new InvalidRevisionException("Invalid Revision was given for entity with ID '" + revision.getEntityId() + "'");
        }
        logger.debug("Successfully verified Revision Claim for all revisions");
        UpdateResult updateResult = task.update();
        if (updateResult == null) {
            return null;
        }
        HashSet<Revision> incrementedRevisions = new HashSet<Revision>();
        for (Revision incomingRevision : revisionList) {
            String entityId = incomingRevision.getEntityId();
            String clientId = incomingRevision.getClientId();
            Revision existingRevision = (Revision)this.revisionMap.get(entityId);
            Revision incrementedRevision = existingRevision.incrementRevision(clientId);
            incrementedRevisions.add(incrementedRevision);
            this.revisionMap.put(entityId, incrementedRevision);
        }
        Object updatedEntity = updateResult.getEntity();
        String updaterIdentity = updateResult.updaterIdentity();
        Revision updatedEntityRevision = (Revision)this.revisionMap.get(updateResult.getEntityId());
        EntityModification entityModification = new EntityModification(updatedEntityRevision, updaterIdentity);
        return new StandardRevisionUpdate<Object>(updatedEntity, entityModification, incrementedRevisions);
    }
}

