/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.handlers;

import java.io.InputStream;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.ClientType;
import software.amazon.awssdk.core.checksums.Md5Checksum;
import software.amazon.awssdk.core.checksums.SdkChecksum;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.SdkHttpHeaders;
import software.amazon.awssdk.services.s3.checksums.ChecksumCalculatingInputStream;
import software.amazon.awssdk.services.s3.checksums.ChecksumValidatingInputStream;
import software.amazon.awssdk.services.s3.checksums.ChecksumsEnabledValidator;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;

@SdkInternalApi
public final class SyncChecksumValidationInterceptor
implements ExecutionInterceptor {
    public Optional<RequestBody> modifyHttpContent(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        if (ChecksumsEnabledValidator.putObjectChecksumEnabled(context.request(), ClientType.SYNC, executionAttributes, (SdkHttpHeaders)context.httpRequest()) && context.requestBody().isPresent()) {
            Md5Checksum checksum = new Md5Checksum();
            ChecksumCalculatingInputStream is = new ChecksumCalculatingInputStream(((RequestBody)context.requestBody().get()).contentStreamProvider().newStream(), (SdkChecksum)checksum);
            executionAttributes.putAttribute(ChecksumsEnabledValidator.CHECKSUM, (Object)checksum);
            return Optional.of(RequestBody.fromContentProvider(() -> is, (long)((RequestBody)context.requestBody().get()).contentLength(), (String)((RequestBody)context.requestBody().get()).contentType()));
        }
        return context.requestBody();
    }

    public Optional<InputStream> modifyHttpResponseContent(Context.ModifyHttpResponse context, ExecutionAttributes executionAttributes) {
        if (ChecksumsEnabledValidator.getObjectChecksumEnabledPerResponse(context.request(), (SdkHttpHeaders)context.httpResponse()) && context.responseBody().isPresent()) {
            Md5Checksum checksum = new Md5Checksum();
            long contentLength = context.httpResponse().firstMatchingHeader("Content-Length").map(Long::parseLong).orElse(0L);
            if (contentLength > 0L) {
                return Optional.of(new ChecksumValidatingInputStream((InputStream)context.responseBody().get(), (SdkChecksum)checksum, contentLength));
            }
        }
        return context.responseBody();
    }

    public void afterUnmarshalling(Context.AfterUnmarshalling context, ExecutionAttributes executionAttributes) {
        if (ChecksumsEnabledValidator.putObjectChecksumEnabled(context.request(), ClientType.SYNC, executionAttributes, (SdkHttpHeaders)context.httpResponse())) {
            ChecksumsEnabledValidator.validatePutObjectChecksum((PutObjectResponse)context.response(), executionAttributes);
        }
    }
}

