/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.ssl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.security.util.ClientAuth;
import org.apache.nifi.security.util.KeyStoreUtils;
import org.apache.nifi.security.util.KeystoreType;
import org.apache.nifi.security.util.SslContextFactory;
import org.apache.nifi.security.util.StandardTlsConfiguration;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsException;
import org.apache.nifi.security.util.TlsPlatform;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.util.StringUtils;

@Tags(value={"ssl", "secure", "certificate", "keystore", "truststore", "jks", "p12", "pkcs12", "pkcs", "tls"})
@CapabilityDescription(value="Standard implementation of the SSLContextService. Provides the ability to configure keystore and/or truststore properties once and reuse that configuration throughout the application. This service can be used to communicate with both legacy and modern systems. If you only need to communicate with non-legacy systems, then the StandardRestrictedSSLContextService is recommended as it only allows a specific set of SSL protocols to be chosen.")
public class StandardSSLContextService
extends AbstractControllerService
implements SSLContextService {
    public static final PropertyDescriptor TRUSTSTORE = new PropertyDescriptor.Builder().name("Truststore Filename").description("The fully-qualified filename of the Truststore").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue(null).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).sensitive(false).build();
    public static final PropertyDescriptor TRUSTSTORE_TYPE = new PropertyDescriptor.Builder().name("Truststore Type").description("The Type of the Truststore").allowableValues((Enum[])KeystoreType.values()).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(false).build();
    public static final PropertyDescriptor TRUSTSTORE_PASSWORD = new PropertyDescriptor.Builder().name("Truststore Password").description("The password for the Truststore").defaultValue(null).addValidator(Validator.VALID).required(false).sensitive(true).build();
    public static final PropertyDescriptor KEYSTORE = new PropertyDescriptor.Builder().name("Keystore Filename").description("The fully-qualified filename of the Keystore").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue(null).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).sensitive(false).build();
    public static final PropertyDescriptor KEYSTORE_TYPE = new PropertyDescriptor.Builder().name("Keystore Type").description("The Type of the Keystore").allowableValues((Enum[])KeystoreType.values()).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(false).build();
    public static final PropertyDescriptor KEYSTORE_PASSWORD = new PropertyDescriptor.Builder().name("Keystore Password").defaultValue(null).description("The password for the Keystore").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    static final PropertyDescriptor KEY_PASSWORD = new PropertyDescriptor.Builder().name("key-password").displayName("Key Password").description("The password for the key. If this is not specified, but the Keystore Filename, Password, and Type are specified, then the Keystore Password will be assumed to be the same as the Key Password.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).required(false).build();
    public static final PropertyDescriptor SSL_ALGORITHM = new PropertyDescriptor.Builder().name("SSL Protocol").displayName("TLS Protocol").defaultValue("TLS").required(false).allowableValues(StandardSSLContextService.getProtocolAllowableValues()).description("SSL or TLS Protocol Version for encrypted connections. Supported versions include insecure legacy options and depend on the specific version of Java used.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(false).build();
    private static final List<PropertyDescriptor> properties;
    protected ConfigurationContext configContext;
    private boolean isValidated;
    private static final int VALIDATION_CACHE_EXPIRATION = 5;
    private int validationCacheCount = 0;

    @OnEnabled
    public void onConfigured(ConfigurationContext context) throws InitializationException {
        this.configContext = context;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        Map<PropertyDescriptor, String> properties = this.evaluateProperties((PropertyContext)context);
        results.addAll(StandardSSLContextService.validateStore(properties, KeystoreValidationGroup.KEYSTORE));
        results.addAll(StandardSSLContextService.validateStore(properties, KeystoreValidationGroup.TRUSTSTORE));
        if (!results.isEmpty()) {
            StringBuilder sb = new StringBuilder((Object)((Object)this) + " is not valid due to:");
            for (ValidationResult result : results) {
                sb.append("\n").append(result.toString());
            }
            throw new InitializationException(sb.toString());
        }
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        super.onPropertyModified(descriptor, oldValue, newValue);
        this.resetValidationCache();
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        if (this.isValidated) {
            ++this.validationCacheCount;
            if (this.validationCacheCount > 5) {
                this.resetValidationCache();
            } else {
                return results;
            }
        }
        Map<PropertyDescriptor, String> properties = this.evaluateProperties((PropertyContext)validationContext);
        results.addAll(StandardSSLContextService.validateStore(properties, KeystoreValidationGroup.KEYSTORE));
        results.addAll(StandardSSLContextService.validateStore(properties, KeystoreValidationGroup.TRUSTSTORE));
        this.isValidated = results.isEmpty();
        return results;
    }

    private Map<PropertyDescriptor, String> evaluateProperties(PropertyContext context) {
        HashMap<PropertyDescriptor, String> evaluatedProperties = new HashMap<PropertyDescriptor, String>(this.getSupportedPropertyDescriptors().size(), 1.0f);
        for (PropertyDescriptor pd : this.getSupportedPropertyDescriptors()) {
            PropertyValue pv = pd.isExpressionLanguageSupported() ? context.getProperty(pd).evaluateAttributeExpressions() : context.getProperty(pd);
            evaluatedProperties.put(pd, pv.isSet() ? pv.getValue() : null);
        }
        return evaluatedProperties;
    }

    private void resetValidationCache() {
        this.validationCacheCount = 0;
        this.isValidated = false;
    }

    protected int getValidationCacheExpiration() {
        return 5;
    }

    public TlsConfiguration createTlsConfiguration() {
        return new StandardTlsConfiguration(this.getKeyStoreFile(), this.getKeyStorePassword(), this.getKeyPassword(), this.getKeyStoreType(), this.getTrustStoreFile(), this.getTrustStorePassword(), this.getTrustStoreType(), this.getSslAlgorithm());
    }

    public SSLContext createContext() {
        TlsConfiguration tlsConfiguration = this.createTlsConfiguration();
        if (!tlsConfiguration.isTruststorePopulated()) {
            this.getLogger().warn("Trust Store properties not found: using platform default Certificate Authorities");
        }
        try {
            TrustManager[] trustManagers = SslContextFactory.getTrustManagers((TlsConfiguration)tlsConfiguration);
            return SslContextFactory.createSslContext((TlsConfiguration)tlsConfiguration, (TrustManager[])trustManagers);
        }
        catch (TlsException e) {
            this.getLogger().error("Unable to create SSLContext: {}", new Object[]{e.getLocalizedMessage()});
            throw new ProcessException("Unable to create SSLContext", (Throwable)e);
        }
    }

    @Deprecated
    public SSLContext createSSLContext(ClientAuth clientAuth) throws ProcessException {
        return this.createContext();
    }

    @Deprecated
    public SSLContext createSSLContext(SSLContextService.ClientAuth clientAuth) throws ProcessException {
        return this.createContext();
    }

    public X509TrustManager createTrustManager() {
        try {
            X509TrustManager trustManager = SslContextFactory.getX509TrustManager((TlsConfiguration)this.createTlsConfiguration());
            if (trustManager == null) {
                throw new ProcessException("X.509 Trust Manager not found using configured properties");
            }
            return trustManager;
        }
        catch (TlsException e) {
            throw new ProcessException("Unable to create X.509 Trust Manager", (Throwable)e);
        }
    }

    public String getTrustStoreFile() {
        return this.configContext.getProperty(TRUSTSTORE).evaluateAttributeExpressions().getValue();
    }

    public String getTrustStoreType() {
        return this.configContext.getProperty(TRUSTSTORE_TYPE).getValue();
    }

    public String getTrustStorePassword() {
        PropertyValue truststorePassword = this.configContext.getProperty(TRUSTSTORE_PASSWORD);
        return truststorePassword.isSet() ? truststorePassword.getValue() : "";
    }

    public boolean isTrustStoreConfigured() {
        return this.getTrustStoreFile() != null && this.getTrustStoreType() != null;
    }

    public String getKeyStoreFile() {
        return this.configContext.getProperty(KEYSTORE).evaluateAttributeExpressions().getValue();
    }

    public String getKeyStoreType() {
        return this.configContext.getProperty(KEYSTORE_TYPE).getValue();
    }

    public String getKeyStorePassword() {
        return this.configContext.getProperty(KEYSTORE_PASSWORD).getValue();
    }

    public String getKeyPassword() {
        return this.configContext.getProperty(KEY_PASSWORD).getValue();
    }

    public boolean isKeyStoreConfigured() {
        return this.getKeyStoreFile() != null && this.getKeyStorePassword() != null && this.getKeyStoreType() != null;
    }

    public String getSslAlgorithm() {
        return this.configContext.getProperty(SSL_ALGORITHM).getValue();
    }

    private static Collection<ValidationResult> validateStore(Map<PropertyDescriptor, String> properties, KeystoreValidationGroup keyStoreOrTrustStore) {
        List<ValidationResult> results = keyStoreOrTrustStore == KeystoreValidationGroup.KEYSTORE ? StandardSSLContextService.validateKeystore(properties) : StandardSSLContextService.validateTruststore(properties);
        if (StandardSSLContextService.keystorePropertiesEmpty(properties) && StandardSSLContextService.truststorePropertiesEmpty(properties)) {
            results.add(new ValidationResult.Builder().valid(false).explanation("Either the keystore and/or truststore must be populated").subject("Keystore/truststore properties").build());
        }
        return results;
    }

    private static boolean keystorePropertiesEmpty(Map<PropertyDescriptor, String> properties) {
        return StringUtils.isBlank((String)properties.get(KEYSTORE)) && StringUtils.isBlank((String)properties.get(KEYSTORE_PASSWORD)) && StringUtils.isBlank((String)properties.get(KEYSTORE_TYPE));
    }

    private static boolean truststorePropertiesEmpty(Map<PropertyDescriptor, String> properties) {
        return StringUtils.isBlank((String)properties.get(TRUSTSTORE)) && StringUtils.isBlank((String)properties.get(TRUSTSTORE_PASSWORD)) && StringUtils.isBlank((String)properties.get(TRUSTSTORE_TYPE));
    }

    private static int countNulls(Object ... objects) {
        int count = 0;
        for (Object x : objects) {
            if (x != null) continue;
            ++count;
        }
        return count;
    }

    private static List<ValidationResult> validateKeystore(Map<PropertyDescriptor, String> properties) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        String filename = properties.get(KEYSTORE);
        String password = properties.get(KEYSTORE_PASSWORD);
        String keyPassword = properties.get(KEY_PASSWORD);
        String type = properties.get(KEYSTORE_TYPE);
        int nulls = StandardSSLContextService.countNulls(filename, password, type);
        if (nulls != 3 && nulls != 0) {
            results.add(new ValidationResult.Builder().valid(false).explanation("Must set either 0 or 3 properties for Keystore").subject("Keystore Properties").build());
        } else if (nulls == 0) {
            List<ValidationResult> fileValidationResults = StandardSSLContextService.validateKeystoreFile(filename, password, keyPassword, type);
            results.addAll(fileValidationResults);
        }
        return results;
    }

    private static List<ValidationResult> validateTruststore(Map<PropertyDescriptor, String> properties) {
        String filename = properties.get(TRUSTSTORE);
        String password = properties.get(TRUSTSTORE_PASSWORD);
        String type = properties.get(TRUSTSTORE_TYPE);
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        if (!StringUtils.isBlank((String)filename) && !StringUtils.isBlank((String)type)) {
            results.addAll(StandardSSLContextService.validateTruststoreFile(filename, password, type));
        } else if (!StringUtils.isBlank((String)filename) || !StringUtils.isBlank((String)type)) {
            results.add(new ValidationResult.Builder().valid(false).explanation("If the truststore filename or type are set, both must be populated").subject("Truststore Properties").build());
        }
        return results;
    }

    private static List<ValidationResult> validateTruststoreFile(String filename, String password, String type) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        File file = new File(filename);
        if (!file.exists() || !file.canRead()) {
            results.add(new ValidationResult.Builder().valid(false).subject("Truststore Properties").explanation("Cannot access file " + file.getAbsolutePath()).build());
        } else {
            char[] passwordChars = new char[]{};
            if (!StringUtils.isBlank((String)password)) {
                passwordChars = password.toCharArray();
            }
            try {
                boolean storeValid = KeyStoreUtils.isStoreValid((URL)file.toURI().toURL(), (KeystoreType)KeystoreType.valueOf((String)type), (char[])passwordChars);
                if (!storeValid) {
                    results.add(new ValidationResult.Builder().subject("Truststore Properties").valid(false).explanation("Invalid truststore password or type specified for file " + filename).build());
                }
            }
            catch (MalformedURLException e) {
                results.add(new ValidationResult.Builder().subject("Truststore Properties").valid(false).explanation("Malformed URL from file: " + e).build());
            }
        }
        return results;
    }

    private static List<ValidationResult> validateKeystoreFile(String filename, String password, String keyPassword, String type) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        File file = new File(filename);
        if (!file.exists() || !file.canRead()) {
            results.add(new ValidationResult.Builder().valid(false).subject("Keystore Properties").explanation("Cannot access file " + file.getAbsolutePath()).build());
        } else {
            char[] passwordChars = new char[]{};
            if (!StringUtils.isBlank((String)password)) {
                passwordChars = password.toCharArray();
            }
            try {
                boolean keyPasswordValid;
                boolean storeValid = KeyStoreUtils.isStoreValid((URL)file.toURI().toURL(), (KeystoreType)KeystoreType.valueOf((String)type), (char[])passwordChars);
                if (!storeValid) {
                    results.add(new ValidationResult.Builder().subject("Keystore Properties").valid(false).explanation("Invalid keystore password or type specified for file " + filename).build());
                }
                char[] keyPasswordChars = new char[]{};
                if (StringUtils.isBlank((String)keyPassword) || keyPassword.equals(password)) {
                    keyPasswordChars = passwordChars;
                }
                if (!StringUtils.isBlank((String)keyPassword)) {
                    keyPasswordChars = keyPassword.toCharArray();
                }
                if (!(keyPasswordValid = KeyStoreUtils.isKeyPasswordCorrect((URL)file.toURI().toURL(), (KeystoreType)KeystoreType.valueOf((String)type), (char[])passwordChars, (char[])keyPasswordChars))) {
                    results.add(new ValidationResult.Builder().subject("Keystore Properties").valid(false).explanation("Invalid key password specified for file " + filename).build());
                }
            }
            catch (MalformedURLException e) {
                results.add(new ValidationResult.Builder().subject("Keystore Properties").valid(false).explanation("Malformed URL from file: " + e).build());
            }
        }
        return results;
    }

    public String toString() {
        return "SSLContextService[id=" + this.getIdentifier() + "]";
    }

    private static AllowableValue[] getProtocolAllowableValues() {
        ArrayList<AllowableValue> allowableValues = new ArrayList<AllowableValue>();
        allowableValues.add(new AllowableValue("SSL", "SSL", "Negotiate latest SSL or TLS protocol version based on platform supported versions"));
        allowableValues.add(new AllowableValue("TLS", "TLS", "Negotiate latest TLS protocol version based on platform supported versions"));
        for (String supportedProtocol : TlsPlatform.getSupportedProtocols()) {
            String description = String.format("Require %s protocol version", supportedProtocol);
            allowableValues.add(new AllowableValue(supportedProtocol, supportedProtocol, description));
        }
        return allowableValues.toArray(new AllowableValue[0]);
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(KEYSTORE);
        props.add(KEYSTORE_PASSWORD);
        props.add(KEY_PASSWORD);
        props.add(KEYSTORE_TYPE);
        props.add(TRUSTSTORE);
        props.add(TRUSTSTORE_PASSWORD);
        props.add(TRUSTSTORE_TYPE);
        props.add(SSL_ALGORITHM);
        properties = Collections.unmodifiableList(props);
    }

    public static enum KeystoreValidationGroup {
        KEYSTORE,
        TRUSTSTORE;

    }
}

