/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.c2.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;

public class ConfigurationProviderKey {
    private final List<MediaType> acceptValues;
    private final Map<String, List<String>> parameters;

    public ConfigurationProviderKey(List<MediaType> acceptValues, Map<String, List<String>> parameters) {
        this.acceptValues = Collections.unmodifiableList(new ArrayList<MediaType>(acceptValues));
        this.parameters = Collections.unmodifiableMap(parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.unmodifiableList(new ArrayList((Collection)e.getValue())))));
    }

    public List<MediaType> getAcceptValues() {
        return this.acceptValues;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationProviderKey that = (ConfigurationProviderKey)o;
        if (!this.acceptValues.equals(that.acceptValues)) {
            return false;
        }
        return this.parameters.equals(that.parameters);
    }

    public String toString() {
        return "ConfigurationProviderKey{acceptValues=" + this.acceptValues + ", parameters=" + this.parameters + '}';
    }

    public int hashCode() {
        int result = this.acceptValues.hashCode();
        result = 31 * result + this.parameters.hashCode();
        return result;
    }
}

