/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.c2.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.wordnik.swagger.annotations.Api;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.nifi.minifi.c2.api.Configuration;
import org.apache.nifi.minifi.c2.api.ConfigurationProvider;
import org.apache.nifi.minifi.c2.api.ConfigurationProviderException;
import org.apache.nifi.minifi.c2.api.InvalidParameterException;
import org.apache.nifi.minifi.c2.api.security.authorization.AuthorizationException;
import org.apache.nifi.minifi.c2.api.security.authorization.Authorizer;
import org.apache.nifi.minifi.c2.api.util.Pair;
import org.apache.nifi.minifi.c2.service.ConfigurationProviderInfo;
import org.apache.nifi.minifi.c2.service.ConfigurationProviderKey;
import org.apache.nifi.minifi.c2.service.ConfigurationProviderValue;
import org.apache.nifi.minifi.c2.util.HttpRequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/config")
@Api(value="/config", description="Provides configuration for MiNiFi instances")
public class ConfigService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigService.class);
    private final Authorizer authorizer;
    private final ObjectMapper objectMapper;
    private final Supplier<ConfigurationProviderInfo> configurationProviderInfo;
    private final LoadingCache<ConfigurationProviderKey, ConfigurationProviderValue> configurationCache;

    public ConfigService(List<ConfigurationProvider> configurationProviders, Authorizer authorizer) {
        this(configurationProviders, authorizer, 1000L, 300000L);
    }

    public ConfigService(List<ConfigurationProvider> configurationProviders, Authorizer authorizer, long maximumCacheSize, long cacheTtlMillis) {
        this.authorizer = authorizer;
        this.objectMapper = new ObjectMapper();
        if (configurationProviders == null || configurationProviders.size() == 0) {
            throw new IllegalArgumentException("Expected at least one configuration provider");
        }
        this.configurationProviderInfo = Suppliers.memoizeWithExpiration(() -> this.initContentTypeInfo(configurationProviders), (long)cacheTtlMillis, (TimeUnit)TimeUnit.MILLISECONDS);
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (maximumCacheSize >= 0L) {
            cacheBuilder = cacheBuilder.maximumSize(maximumCacheSize);
        }
        if (cacheTtlMillis >= 0L) {
            cacheBuilder = cacheBuilder.refreshAfterWrite(cacheTtlMillis, TimeUnit.MILLISECONDS);
        }
        this.configurationCache = cacheBuilder.build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
    }

    public ConfigurationProviderValue initConfigurationProviderValue(ConfigurationProviderKey key) {
        if (logger.isDebugEnabled()) {
            logger.debug("Attempting to load and cache configuration with key " + key);
        }
        try {
            List acceptValues = key.getAcceptValues();
            Pair providerPair = this.getProvider(acceptValues);
            Map parameters = key.getParameters();
            Integer version = null;
            List versionList = (List)parameters.get("version");
            if (versionList != null && versionList.size() > 0) {
                try {
                    version = Integer.parseInt((String)versionList.get(0));
                }
                catch (NumberFormatException e) {
                    throw new InvalidParameterException("Unable to parse " + version + " as integer.", (Throwable)e);
                }
            }
            return new ConfigurationProviderValue(((ConfigurationProvider)providerPair.getSecond()).getConfiguration(((MediaType)providerPair.getFirst()).toString(), version, parameters), (MediaType)providerPair.getFirst(), null);
        }
        catch (ConfigurationProviderException e) {
            return new ConfigurationProviderValue(null, null, e);
        }
    }

    protected ConfigurationProviderInfo initContentTypeInfo(List<ConfigurationProvider> configurationProviders) {
        ArrayList<Pair> mediaTypeList = new ArrayList<Pair>();
        ArrayList<String> contentTypes = new ArrayList<String>();
        LinkedHashSet<MediaType> seenMediaTypes = new LinkedHashSet<MediaType>();
        for (ConfigurationProvider configurationProvider : configurationProviders) {
            try {
                for (String contentTypeString : configurationProvider.getContentTypes()) {
                    MediaType mediaType = MediaType.valueOf((String)contentTypeString);
                    if (!seenMediaTypes.add(mediaType)) continue;
                    contentTypes.add(contentTypeString);
                    mediaTypeList.add(new Pair((Object)mediaType, (Object)configurationProvider));
                }
            }
            catch (ConfigurationProviderException e) {
                return new ConfigurationProviderInfo(null, null, e);
            }
        }
        return new ConfigurationProviderInfo(mediaTypeList, contentTypes, null);
    }

    @GET
    @Path(value="/contentTypes")
    @Produces(value={"application/json"})
    public Response getContentTypes(@Context HttpServletRequest request, @Context UriInfo uriInfo) {
        List contentTypes;
        try {
            this.authorizer.authorize(SecurityContextHolder.getContext().getAuthentication(), uriInfo);
        }
        catch (AuthorizationException e) {
            logger.warn(HttpRequestUtil.getClientString((ServletRequest)request) + " not authorized to access " + uriInfo, (Throwable)e);
            return Response.status((int)403).build();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            contentTypes = ((ConfigurationProviderInfo)this.configurationProviderInfo.get()).getContentTypes();
        }
        catch (ConfigurationProviderException e) {
            logger.warn("Unable to initialize content type information.", (Throwable)e);
            return Response.status((int)500).build();
        }
        try {
            this.objectMapper.writerWithDefaultPrettyPrinter().writeValue((OutputStream)byteArrayOutputStream, (Object)contentTypes);
        }
        catch (IOException e) {
            logger.warn("Unable to write configuration providers to output stream.", (Throwable)e);
            return Response.status((int)500).build();
        }
        return Response.ok().type(MediaType.APPLICATION_JSON_TYPE).entity((Object)byteArrayOutputStream.toByteArray()).build();
    }

    @GET
    public Response getConfig(@Context HttpServletRequest request, @Context HttpHeaders httpHeaders, @Context UriInfo uriInfo) {
        try {
            this.authorizer.authorize(SecurityContextHolder.getContext().getAuthentication(), uriInfo);
        }
        catch (AuthorizationException e) {
            logger.warn(HttpRequestUtil.getClientString((ServletRequest)request) + " not authorized to access " + uriInfo, (Throwable)e);
            return Response.status((int)403).build();
        }
        HashMap parameters = new HashMap();
        for (Map.Entry entry : uriInfo.getQueryParameters().entrySet()) {
            parameters.put(entry.getKey(), entry.getValue());
        }
        List<MediaType> acceptValues = httpHeaders.getAcceptableMediaTypes();
        boolean defaultAccept = false;
        if (acceptValues.size() == 0) {
            acceptValues = Arrays.asList(MediaType.WILDCARD_TYPE);
            defaultAccept = true;
        }
        if (logger.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("Handling request from ").append(HttpRequestUtil.getClientString((ServletRequest)request)).append(" with parameters ").append(parameters).append(" and Accept");
            if (defaultAccept) {
                builder = builder.append(" default value");
            }
            builder = builder.append(": ").append(acceptValues.stream().map(Object::toString).collect(Collectors.joining(", ")));
            logger.debug(builder.toString());
        }
        try {
            ConfigurationProviderValue configurationProviderValue = (ConfigurationProviderValue)this.configurationCache.get((Object)new ConfigurationProviderKey(acceptValues, parameters));
            Configuration configuration = configurationProviderValue.getConfiguration();
            Response.ResponseBuilder ok = Response.ok();
            ok = ok.header("X-Content-Version", (Object)configuration.getVersion());
            ok = ok.type(configurationProviderValue.getMediaType());
            byte[] buffer = new byte[1024];
            try (InputStream inputStream = configuration.getInputStream();
                 ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                int read;
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
                while ((read = inputStream.read(buffer)) >= 0) {
                    outputStream.write(buffer, 0, read);
                    md5.update(buffer, 0, read);
                    sha256.update(buffer, 0, read);
                }
                ok = ok.header("Content-MD5", (Object)ConfigService.bytesToHex((byte[])md5.digest()));
                ok = ok.header("X-Content-SHA-256", (Object)ConfigService.bytesToHex((byte[])sha256.digest()));
                ok = ok.entity((Object)outputStream.toByteArray());
            }
            catch (IOException | NoSuchAlgorithmException | ConfigurationProviderException e) {
                logger.error("Error reading or checksumming configuration file", e);
                throw new WebApplicationException(500);
            }
            return ok.build();
        }
        catch (AuthorizationException e) {
            logger.warn(HttpRequestUtil.getClientString((ServletRequest)request) + " not authorized to access " + uriInfo, (Throwable)e);
            return Response.status((int)403).build();
        }
        catch (InvalidParameterException e) {
            logger.info(HttpRequestUtil.getClientString((ServletRequest)request) + " made invalid request with " + HttpRequestUtil.getQueryString((HttpServletRequest)request), (Throwable)e);
            return Response.status((int)400).entity((Object)"Invalid request.").build();
        }
        catch (ConfigurationProviderException e) {
            logger.warn("Unable to get configuration.", (Throwable)e);
            return Response.status((int)500).build();
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof WebApplicationException) {
                throw (WebApplicationException)cause;
            }
            logger.error(HttpRequestUtil.getClientString((ServletRequest)request) + " made request with " + HttpRequestUtil.getQueryString((HttpServletRequest)request) + " that caused error.", cause);
            return Response.status((int)500).entity((Object)"Internal error").build();
        }
    }

    protected static String bytesToHex(byte[] in) {
        StringBuilder builder = new StringBuilder();
        for (byte b : in) {
            builder.append(String.format("%02x", b));
        }
        return builder.toString();
    }

    private Pair<MediaType, ConfigurationProvider> getProvider(List<MediaType> acceptValues) throws ConfigurationProviderException {
        List mediaTypeList;
        try {
            mediaTypeList = ((ConfigurationProviderInfo)this.configurationProviderInfo.get()).getMediaTypeList();
        }
        catch (ConfigurationProviderException.Wrapper e) {
            throw e.unwrap();
        }
        for (MediaType accept : acceptValues) {
            for (Pair pair : mediaTypeList) {
                MediaType mediaType = (MediaType)pair.getFirst();
                if (!accept.isCompatible(mediaType)) continue;
                return new Pair((Object)mediaType, pair.getSecond());
            }
        }
        throw new WebApplicationException(Response.status((int)406).entity((Object)("Unable to find configuration provider for \"Accept: " + acceptValues.stream().map(Object::toString).collect(Collectors.joining(", ")) + "\" supported media types are " + mediaTypeList.stream().map(Pair::getFirst).map(Object::toString).collect(Collectors.joining(", ")))).build());
    }
}

