/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.c2.security.authorization;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.nifi.minifi.c2.api.security.authorization.AuthorityGranter;
import org.springframework.core.io.Resource;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.yaml.snakeyaml.Yaml;

public class PrincipalStringAuthorityGranter
implements AuthorityGranter {
    private final Map<String, List<String>> grantedAuthorityMap;

    public PrincipalStringAuthorityGranter(Resource configYaml) throws IOException {
        try (InputStream inputStream = configYaml.getInputStream();){
            Object yaml = new Yaml().load(inputStream);
            if (!(yaml instanceof Map)) {
                throw new IllegalArgumentException("Expected authority map of Principal -> Authority list");
            }
            this.grantedAuthorityMap = (Map)yaml;
        }
    }

    public Collection<GrantedAuthority> grantAuthorities(Authentication authentication) {
        List authorities = (List)this.grantedAuthorityMap.get(authentication.getPrincipal().toString());
        if (authorities == null) {
            return null;
        }
        return authorities.stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList());
    }
}

