/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.c2.security.authorization;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.nifi.minifi.c2.api.security.authorization.AuthorizationException;
import org.apache.nifi.minifi.c2.api.security.authorization.Authorizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.yaml.snakeyaml.Yaml;

/*
 * Exception performing whole class analysis ignored.
 */
public class GrantedAuthorityAuthorizer
implements Authorizer {
    private static final Logger logger = LoggerFactory.getLogger(GrantedAuthorityAuthorizer.class);
    public static final String DENY = "deny";
    public static final String ALLOW = "allow";
    public static final String DEFAULT_ACTION = "Default Action";
    private final Map<String, Object> grantedAuthorityMap;

    public GrantedAuthorityAuthorizer(Resource configYaml) throws IOException {
        try (InputStream inputStream = configYaml.getInputStream();){
            this.grantedAuthorityMap = (Map)GrantedAuthorityAuthorizer.as(Map.class, (Object)new Yaml().load(inputStream), (T o) -> new IllegalArgumentException("Expected yaml map for root of configuration but was " + o));
        }
    }

    public void authorize(Authentication authentication, UriInfo uriInfo) throws AuthorizationException {
        if (authentication == null) {
            throw new AuthorizationException("null authentication object provided.");
        }
        if (!authentication.isAuthenticated()) {
            throw new AuthorizationException(authentication + " not authenticated.");
        }
        Set authorities = authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
        String defaultAction = (String)GrantedAuthorityAuthorizer.as(String.class, (Object)this.grantedAuthorityMap.getOrDefault("Default Action", "deny"));
        String path = uriInfo.getAbsolutePath().getPath();
        Map pathAuthorizations = (Map)GrantedAuthorityAuthorizer.as(Map.class, this.grantedAuthorityMap.get("Paths"));
        if (pathAuthorizations == null && !"allow".equalsIgnoreCase(defaultAction)) {
            throw new AuthorizationException("Didn't find authorizations for " + path + " and default policy is " + defaultAction + " instead of allow");
        }
        Map pathAuthorization = (Map)GrantedAuthorityAuthorizer.as(Map.class, pathAuthorizations.get(path));
        if (pathAuthorization == null && !"allow".equalsIgnoreCase(defaultAction)) {
            throw new AuthorizationException("Didn't find authorizations for " + path + " and default policy is " + defaultAction + " instead of allow");
        }
        defaultAction = (String)GrantedAuthorityAuthorizer.as(String.class, (Object)pathAuthorization.getOrDefault("Default Action", defaultAction));
        List actions = (List)GrantedAuthorityAuthorizer.as(List.class, pathAuthorization.get("Actions"));
        MultivaluedMap queryParameters = uriInfo.getQueryParameters();
        for (Map action : actions) {
            String ruleAction = (String)GrantedAuthorityAuthorizer.as(String.class, action.get("Action"));
            if (ruleAction == null || !"allow".equalsIgnoreCase(ruleAction) && !"deny".equalsIgnoreCase(ruleAction)) {
                throw new AuthorizationException("Expected Action key of allow or deny for " + action);
            }
            String authorization = (String)GrantedAuthorityAuthorizer.as(String.class, action.get("Authorization"));
            if (authorization != null && !authorities.contains(authorization)) continue;
            Map parameters = (Map)GrantedAuthorityAuthorizer.as(Map.class, action.get("Query Parameters"));
            if (parameters != null) {
                boolean foundParameterMismatch = false;
                for (Map.Entry parameter : parameters.entrySet()) {
                    Object value = parameter.getValue();
                    if (value instanceof String) {
                        value = Arrays.asList((String)value);
                    }
                    if (Objects.equals(queryParameters.get(parameter.getKey()), value)) continue;
                    foundParameterMismatch = true;
                    break;
                }
                if (foundParameterMismatch) continue;
            }
            if ("allow".equalsIgnoreCase(ruleAction)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Action " + action + "matched which resulted in " + ruleAction);
                }
                return;
            }
            throw new AuthorizationException("Action " + action + " matched which resulted in " + ruleAction);
        }
        if ("allow".equalsIgnoreCase(defaultAction)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Found no matching actions so falling back to default action " + defaultAction);
            }
        } else {
            throw new AuthorizationException("Didn't find authorizations for " + path + " and default policy is " + defaultAction + " instead of allow");
        }
    }

    private static <T> T as(Class<T> clazz, Object object) throws AuthorizationException {
        return (T)GrantedAuthorityAuthorizer.as(clazz, (Object)object, (T o) -> new AuthorizationException("Expected " + clazz + " but was " + o));
    }

    private static <T, E extends Throwable> T as(Class<T> clazz, Object object, Function<Object, E> exceptionSupplier) throws E {
        if (object == null) {
            return null;
        }
        if (!clazz.isInstance(object)) {
            throw (Throwable)exceptionSupplier.apply(object);
        }
        return clazz.cast(object);
    }
}

