/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.c2.security.authentication;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

public class X509AuthenticationToken
extends AbstractAuthenticationToken {
    private final X509Certificate[] x509Certificates;
    private final String subjectDn;

    public X509AuthenticationToken(X509Certificate[] x509Certificates) {
        this(x509Certificates, null);
        this.setAuthenticated(false);
    }

    protected X509AuthenticationToken(X509Certificate[] x509Certificates, Collection<GrantedAuthority> grantedAuthorities) {
        super(grantedAuthorities);
        this.x509Certificates = (X509Certificate[])Arrays.copyOf(x509Certificates, x509Certificates.length, X509Certificate[].class);
        X509Certificate x509Certificate = x509Certificates[0];
        this.subjectDn = x509Certificate.getSubjectDN().getName().trim();
    }

    public X509Certificate[] getCredentials() {
        return this.x509Certificates;
    }

    public String getPrincipal() {
        return this.subjectDn;
    }
}

