/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.c2.security.authentication;

import org.apache.nifi.minifi.c2.api.security.authorization.AuthorityGranter;
import org.apache.nifi.minifi.c2.security.authentication.C2AuthenticationToken;
import org.apache.nifi.minifi.c2.security.authentication.X509AuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class X509AuthenticationProvider
implements AuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(X509AuthenticationProvider.class);
    private final AuthorityGranter authorityGranter;

    public X509AuthenticationProvider(AuthorityGranter authorityGranter) {
        this.authorityGranter = authorityGranter;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        X509AuthenticationToken x509AuthenticationToken = (X509AuthenticationToken)authentication;
        if (logger.isDebugEnabled()) {
            logger.debug("Authenticating " + X509AuthenticationToken.class.getSimpleName() + " with principal " + x509AuthenticationToken.getPrincipal());
        }
        return new C2AuthenticationToken(x509AuthenticationToken.getPrincipal(), (Object)x509AuthenticationToken.getCredentials(), this.authorityGranter.grantAuthorities(authentication));
    }

    public boolean supports(Class<?> authentication) {
        return X509AuthenticationToken.class.isAssignableFrom(authentication);
    }
}

