/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.c2.security.authentication;

import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.nifi.minifi.c2.security.authentication.X509AuthenticationToken;
import org.apache.nifi.minifi.c2.util.HttpRequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class X509AuthenticationFilter
extends GenericFilterBean {
    private static final Logger logger = LoggerFactory.getLogger(X509AuthenticationFilter.class);
    private AuthenticationManager authenticationManager;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.authenticateIfPossible(request);
        chain.doFilter(request, response);
    }

    private void authenticateIfPossible(ServletRequest request) {
        if (!request.isSecure()) {
            return;
        }
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (certs == null || certs.length == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to get certificates in request from " + HttpRequestUtil.getClientString((ServletRequest)request));
            }
            return;
        }
        Authentication authentication = this.authenticationManager.authenticate((Authentication)new X509AuthenticationToken(certs));
        if (authentication.isAuthenticated()) {
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
    }

    @Autowired
    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }
}

