/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.c2.security;

import javax.servlet.Filter;
import org.apache.nifi.minifi.c2.security.authentication.C2AnonymousAuthenticationFilter;
import org.apache.nifi.minifi.c2.security.authentication.X509AuthenticationFilter;
import org.apache.nifi.minifi.c2.security.authentication.X509AuthenticationProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@ImportResource(value={"classpath:minifi-c2-web-security-context.xml"})
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    private AuthenticationProvider authenticationProvider;
    private X509AuthenticationFilter x509AuthenticationFilter;
    private C2AnonymousAuthenticationFilter c2AnonymousAuthenticationFilter;

    public SecurityConfiguration() {
        super(true);
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(new String[]{"/access", "/access/config", "/access/token", "/access/kerberos"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.rememberMe().disable()).authorizeRequests().anyRequest()).fullyAuthenticated().and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        http.addFilterBefore((Filter)this.x509AuthenticationFilter, AnonymousAuthenticationFilter.class);
        http.anonymous().authenticationFilter((AnonymousAuthenticationFilter)this.c2AnonymousAuthenticationFilter);
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider(this.authenticationProvider);
    }

    @Autowired
    public void setX509AuthenticationProvider(X509AuthenticationProvider x509AuthenticationProvider) {
        this.authenticationProvider = x509AuthenticationProvider;
    }

    @Autowired
    public void setX509AuthenticationFilter(X509AuthenticationFilter x509AuthenticationFilter) {
        this.x509AuthenticationFilter = x509AuthenticationFilter;
    }

    @Autowired
    public void setC2AnonymousAuthenticationFilter(C2AnonymousAuthenticationFilter c2AnonymousAuthenticationFilter) {
        this.c2AnonymousAuthenticationFilter = c2AnonymousAuthenticationFilter;
    }
}

