/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.status.reporters;

import java.io.IOException;
import java.util.Properties;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.minifi.bootstrap.QueryableStatusAggregator;
import org.apache.nifi.minifi.bootstrap.status.PeriodicStatusReporter;
import org.apache.nifi.minifi.commons.status.FlowStatusReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusLogger
extends PeriodicStatusReporter {
    private volatile QueryableStatusAggregator queryableStatusAggregator;
    private volatile LogLevel logLevel;
    private volatile String statusQuery;
    private static final Logger logger = LoggerFactory.getLogger(StatusLogger.class);
    public static final String LOGGER_STATUS_REPORTER_PROPERTY_PREFIX = "nifi.minifi.status.reporter.log";
    public static final String REPORT_PERIOD_KEY = "nifi.minifi.status.reporter.log.period";
    public static final String LOGGING_LEVEL_KEY = "nifi.minifi.status.reporter.log.level";
    public static final String QUERY_KEY = "nifi.minifi.status.reporter.log.query";
    static final String ENCOUNTERED_IO_EXCEPTION = "Encountered an IO Exception while attempting to query the flow status.";

    @Override
    public void initialize(Properties properties, QueryableStatusAggregator queryableStatusAggregator) {
        this.queryableStatusAggregator = queryableStatusAggregator;
        String periodString = properties.getProperty(REPORT_PERIOD_KEY);
        if (periodString == null) {
            throw new IllegalStateException("nifi.minifi.status.reporter.log.period is null but it is required. Please configure it.");
        }
        try {
            this.setPeriod(Integer.parseInt(periodString));
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("nifi.minifi.status.reporter.log.period is not a valid number.", e);
        }
        String loglevelString = properties.getProperty(LOGGING_LEVEL_KEY);
        if (loglevelString == null) {
            throw new IllegalStateException("nifi.minifi.status.reporter.log.level is null but it is required. Please configure it.");
        }
        try {
            this.logLevel = LogLevel.valueOf((String)loglevelString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Value set for nifi.minifi.status.reporter.log.level is not a valid log level.");
        }
        if (LogLevel.FATAL.equals((Object)this.logLevel)) {
            throw new IllegalStateException("Cannot log status at the FATAL level. Please configure nifi.minifi.status.reporter.log.level to another value.");
        }
        this.statusQuery = properties.getProperty(QUERY_KEY);
        if (this.statusQuery == null) {
            throw new IllegalStateException("nifi.minifi.status.reporter.log.query is null but it is required. Please configure it.");
        }
        this.reportRunner = new ReportStatusRunner();
    }

    private class ReportStatusRunner
    implements Runnable {
        private ReportStatusRunner() {
        }

        @Override
        public void run() {
            try {
                String toLog;
                IOException exception = null;
                try {
                    FlowStatusReport flowStatusReport = StatusLogger.this.queryableStatusAggregator.statusReport(StatusLogger.this.statusQuery);
                    toLog = flowStatusReport.toString();
                }
                catch (IOException e) {
                    toLog = StatusLogger.ENCOUNTERED_IO_EXCEPTION;
                    exception = e;
                }
                switch (StatusLogger.this.logLevel) {
                    case TRACE: {
                        logger.trace(toLog, (Throwable)exception);
                        break;
                    }
                    case DEBUG: {
                        logger.debug(toLog, (Throwable)exception);
                        break;
                    }
                    case INFO: {
                        logger.info(toLog, (Throwable)exception);
                        break;
                    }
                    case WARN: {
                        logger.warn(toLog, (Throwable)exception);
                        break;
                    }
                    case ERROR: {
                        logger.error(toLog, (Throwable)exception);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Cannot log status at level " + StatusLogger.this.logLevel + ". Please configure another.");
                    }
                }
            }
            catch (Exception e) {
                switch (StatusLogger.this.logLevel) {
                    case ERROR: {
                        logger.error("Unexpected exception when attempting to report the status", (Throwable)e);
                        break;
                    }
                    default: {
                        logger.warn("Unexpected exception when attempting to report the status", (Throwable)e);
                    }
                }
            }
        }
    }
}

