/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.configuration.ingestors;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.nifi.minifi.bootstrap.ConfigurationFileHolder;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeNotifier;
import org.apache.nifi.minifi.bootstrap.configuration.ListenerHandleResult;
import org.apache.nifi.minifi.bootstrap.configuration.differentiators.WholeConfigDifferentiator;
import org.apache.nifi.minifi.bootstrap.configuration.differentiators.interfaces.Differentiator;
import org.apache.nifi.minifi.bootstrap.configuration.ingestors.interfaces.ChangeIngestor;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestChangeIngestor
implements ChangeIngestor {
    private static final Map<String, Supplier<Differentiator<InputStream>>> DIFFERENTIATOR_CONSTRUCTOR_MAP;
    public static final String GET_TEXT = "This is a config change listener for an Apache NiFi - MiNiFi instance.\nUse this rest server to upload a conf.yml to configure the MiNiFi instance.\nSend a POST http request to '/' to upload the file.";
    public static final String OTHER_TEXT = "This is not a support HTTP operation. Please use GET to get more information or POST to upload a new config.yml file.\n";
    public static final String POST = "POST";
    public static final String GET = "GET";
    private static final Logger logger;
    private static final String RECEIVE_HTTP_BASE_KEY = "nifi.minifi.notifier.ingestors.receive.http";
    public static final String PORT_KEY = "nifi.minifi.notifier.ingestors.receive.http.port";
    public static final String HOST_KEY = "nifi.minifi.notifier.ingestors.receive.http.host";
    public static final String TRUSTSTORE_LOCATION_KEY = "nifi.minifi.notifier.ingestors.receive.http.truststore.location";
    public static final String TRUSTSTORE_PASSWORD_KEY = "nifi.minifi.notifier.ingestors.receive.http.truststore.password";
    public static final String TRUSTSTORE_TYPE_KEY = "nifi.minifi.notifier.ingestors.receive.http.truststore.type";
    public static final String KEYSTORE_LOCATION_KEY = "nifi.minifi.notifier.ingestors.receive.http.keystore.location";
    public static final String KEYSTORE_PASSWORD_KEY = "nifi.minifi.notifier.ingestors.receive.http.keystore.password";
    public static final String KEYSTORE_TYPE_KEY = "nifi.minifi.notifier.ingestors.receive.http.keystore.type";
    public static final String NEED_CLIENT_AUTH_KEY = "nifi.minifi.notifier.ingestors.receive.http.need.client.auth";
    public static final String DIFFERENTIATOR_KEY = "nifi.minifi.notifier.ingestors.receive.http.differentiator";
    private final Server jetty;
    private volatile Differentiator<InputStream> differentiator;
    private volatile ConfigurationChangeNotifier configurationChangeNotifier;

    public RestChangeIngestor() {
        QueuedThreadPool queuedThreadPool = new QueuedThreadPool();
        queuedThreadPool.setDaemon(true);
        this.jetty = new Server((ThreadPool)queuedThreadPool);
    }

    @Override
    public void initialize(Properties properties, ConfigurationFileHolder configurationFileHolder, ConfigurationChangeNotifier configurationChangeNotifier) {
        logger.info("Initializing");
        String differentiatorName = properties.getProperty(DIFFERENTIATOR_KEY);
        if (differentiatorName != null && !differentiatorName.isEmpty()) {
            Supplier<Differentiator<InputStream>> differentiatorSupplier = DIFFERENTIATOR_CONSTRUCTOR_MAP.get(differentiatorName);
            if (differentiatorSupplier == null) {
                throw new IllegalArgumentException("Property, nifi.minifi.notifier.ingestors.receive.http.differentiator, has value " + differentiatorName + " which does not correspond to any in the PullHttpChangeIngestor Map:" + DIFFERENTIATOR_CONSTRUCTOR_MAP.keySet());
            }
            this.differentiator = differentiatorSupplier.get();
        } else {
            this.differentiator = WholeConfigDifferentiator.getInputStreamDifferentiator();
        }
        this.differentiator.initialize(properties, configurationFileHolder);
        if (properties.getProperty(KEYSTORE_LOCATION_KEY) != null) {
            this.createSecureConnector(properties);
        } else {
            this.createConnector(properties);
        }
        this.configurationChangeNotifier = configurationChangeNotifier;
        HandlerCollection handlerCollection = new HandlerCollection(true, new Handler[0]);
        handlerCollection.addHandler((Handler)new JettyHandler());
        this.jetty.setHandler((Handler)handlerCollection);
    }

    @Override
    public void start() {
        try {
            this.jetty.start();
            logger.info("RestChangeIngester has started and is listening on port {}.", new Object[]{this.getPort()});
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() throws IOException {
        logger.warn("Shutting down the jetty server");
        try {
            this.jetty.stop();
            this.jetty.destroy();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        logger.warn("Done shutting down the jetty server");
    }

    public URI getURI() {
        return this.jetty.getURI();
    }

    public int getPort() {
        if (!this.jetty.isStarted()) {
            throw new IllegalStateException("Jetty server not started");
        }
        return ((ServerConnector)this.jetty.getConnectors()[0]).getLocalPort();
    }

    private void createConnector(Properties properties) {
        ServerConnector http = new ServerConnector(this.jetty);
        http.setPort(Integer.parseInt(properties.getProperty(PORT_KEY, "0")));
        http.setHost(properties.getProperty(HOST_KEY, "localhost"));
        http.setIdleTimeout(30000L);
        this.jetty.addConnector((Connector)http);
        logger.info("Added an http connector on the host '{}' and port '{}'", new Object[]{http.getHost(), http.getPort()});
    }

    private void createSecureConnector(Properties properties) {
        SslContextFactory ssl = new SslContextFactory();
        if (properties.getProperty(KEYSTORE_LOCATION_KEY) != null) {
            ssl.setKeyStorePath(properties.getProperty(KEYSTORE_LOCATION_KEY));
            ssl.setKeyStorePassword(properties.getProperty(KEYSTORE_PASSWORD_KEY));
            ssl.setKeyStoreType(properties.getProperty(KEYSTORE_TYPE_KEY));
        }
        if (properties.getProperty(TRUSTSTORE_LOCATION_KEY) != null) {
            ssl.setTrustStorePath(properties.getProperty(TRUSTSTORE_LOCATION_KEY));
            ssl.setTrustStorePassword(properties.getProperty(TRUSTSTORE_PASSWORD_KEY));
            ssl.setTrustStoreType(properties.getProperty(TRUSTSTORE_TYPE_KEY));
            ssl.setNeedClientAuth(Boolean.parseBoolean(properties.getProperty(NEED_CLIENT_AUTH_KEY, "true")));
        }
        ServerConnector https = new ServerConnector(this.jetty, ssl);
        https.setPort(Integer.parseInt(properties.getProperty(PORT_KEY, "0")));
        https.setHost(properties.getProperty(HOST_KEY, "localhost"));
        https.setIdleTimeout(30000L);
        this.jetty.addConnector((Connector)https);
        logger.info("Added an https connector on the host '{}' and port '{}'", new Object[]{https.getHost(), https.getPort()});
    }

    protected void setDifferentiator(Differentiator<InputStream> differentiator) {
        this.differentiator = differentiator;
    }

    static {
        HashMap<String, Supplier<Differentiator>> tempMap = new HashMap<String, Supplier<Differentiator>>();
        tempMap.put("Whole Config", WholeConfigDifferentiator::getInputStreamDifferentiator);
        DIFFERENTIATOR_CONSTRUCTOR_MAP = Collections.unmodifiableMap(tempMap);
        logger = LoggerFactory.getLogger(RestChangeIngestor.class);
    }

    private class JettyHandler
    extends AbstractHandler {
        private JettyHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            block31: {
                this.logRequest(request);
                baseRequest.setHandled(true);
                if (RestChangeIngestor.POST.equals(request.getMethod())) {
                    try (ByteArrayOutputStream pipedOutputStream = new ByteArrayOutputStream();
                         TeeInputStream teeInputStream = new TeeInputStream((InputStream)request.getInputStream(), (OutputStream)pipedOutputStream);){
                        String responseText;
                        int statusCode;
                        if (RestChangeIngestor.this.differentiator.isNew(teeInputStream)) {
                            while (teeInputStream.available() != 0) {
                                teeInputStream.read();
                            }
                            ByteBuffer newConfig = ByteBuffer.wrap(pipedOutputStream.toByteArray());
                            ByteBuffer readOnlyNewConfig = newConfig.asReadOnlyBuffer();
                            Collection<ListenerHandleResult> listenerHandleResults = RestChangeIngestor.this.configurationChangeNotifier.notifyListeners(readOnlyNewConfig);
                            statusCode = 200;
                            for (ListenerHandleResult result : listenerHandleResults) {
                                if (result.succeeded()) continue;
                                statusCode = 500;
                                break;
                            }
                            responseText = this.getPostText(listenerHandleResults);
                        } else {
                            statusCode = 409;
                            responseText = "Request received but instance is already running this config.";
                        }
                        this.writeOutput(response, responseText, statusCode);
                        break block31;
                    }
                }
                if (RestChangeIngestor.GET.equals(request.getMethod())) {
                    this.writeOutput(response, RestChangeIngestor.GET_TEXT, 200);
                } else {
                    this.writeOutput(response, RestChangeIngestor.OTHER_TEXT, 404);
                }
            }
        }

        private String getPostText(Collection<ListenerHandleResult> listenerHandleResults) {
            StringBuilder postResult = new StringBuilder("The result of notifying listeners:\n");
            for (ListenerHandleResult result : listenerHandleResults) {
                postResult.append(result.toString());
                postResult.append("\n");
            }
            return postResult.toString();
        }

        private void writeOutput(HttpServletResponse response, String responseText, int responseCode) throws IOException {
            response.setStatus(responseCode);
            response.setContentType("text/plain");
            response.setContentLength(responseText.length());
            try (PrintWriter writer = response.getWriter();){
                writer.print(responseText);
                writer.flush();
            }
        }

        private void logRequest(HttpServletRequest request) {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            logger.info("request method = " + request.getMethod());
            logger.info("request url = " + request.getRequestURL());
            logger.info("context path = " + request.getContextPath());
            logger.info("request content type = " + request.getContentType());
            logger.info("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        }
    }
}

