/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.configuration.ingestors;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.nifi.minifi.bootstrap.ConfigurationFileHolder;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeNotifier;
import org.apache.nifi.minifi.bootstrap.configuration.differentiators.WholeConfigDifferentiator;
import org.apache.nifi.minifi.bootstrap.configuration.differentiators.interfaces.Differentiator;
import org.apache.nifi.minifi.bootstrap.configuration.ingestors.AbstractPullChangeIngestor;
import org.apache.nifi.minifi.bootstrap.util.ByteBufferInputStream;
import org.apache.nifi.minifi.commons.schema.ConfigSchema;
import org.apache.nifi.minifi.commons.schema.SecurityPropertiesSchema;
import org.apache.nifi.minifi.commons.schema.common.ConvertableSchema;
import org.apache.nifi.minifi.commons.schema.common.StringUtil;
import org.apache.nifi.minifi.commons.schema.serialization.SchemaLoader;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class PullHttpChangeIngestor
extends AbstractPullChangeIngestor {
    private static final int NOT_MODIFIED_STATUS_CODE = 304;
    private static final Map<String, Supplier<Differentiator<ByteBuffer>>> DIFFERENTIATOR_CONSTRUCTOR_MAP;
    private static final String DEFAULT_CONNECT_TIMEOUT_MS = "5000";
    private static final String DEFAULT_READ_TIMEOUT_MS = "15000";
    private static final String PULL_HTTP_BASE_KEY = "nifi.minifi.notifier.ingestors.pull.http";
    public static final String PULL_HTTP_POLLING_PERIOD_KEY = "nifi.minifi.notifier.ingestors.pull.http.period.ms";
    public static final String PORT_KEY = "nifi.minifi.notifier.ingestors.pull.http.port";
    public static final String HOST_KEY = "nifi.minifi.notifier.ingestors.pull.http.hostname";
    public static final String PATH_KEY = "nifi.minifi.notifier.ingestors.pull.http.path";
    public static final String QUERY_KEY = "nifi.minifi.notifier.ingestors.pull.http.query";
    public static final String PROXY_HOST_KEY = "nifi.minifi.notifier.ingestors.pull.http.proxy.hostname";
    public static final String PROXY_PORT_KEY = "nifi.minifi.notifier.ingestors.pull.http.proxy.port";
    public static final String PROXY_USERNAME = "nifi.minifi.notifier.ingestors.pull.http.proxy.username";
    public static final String PROXY_PASSWORD = "nifi.minifi.notifier.ingestors.pull.http.proxy.password";
    public static final String TRUSTSTORE_LOCATION_KEY = "nifi.minifi.notifier.ingestors.pull.http.truststore.location";
    public static final String TRUSTSTORE_PASSWORD_KEY = "nifi.minifi.notifier.ingestors.pull.http.truststore.password";
    public static final String TRUSTSTORE_TYPE_KEY = "nifi.minifi.notifier.ingestors.pull.http.truststore.type";
    public static final String KEYSTORE_LOCATION_KEY = "nifi.minifi.notifier.ingestors.pull.http.keystore.location";
    public static final String KEYSTORE_PASSWORD_KEY = "nifi.minifi.notifier.ingestors.pull.http.keystore.password";
    public static final String KEYSTORE_TYPE_KEY = "nifi.minifi.notifier.ingestors.pull.http.keystore.type";
    public static final String CONNECT_TIMEOUT_KEY = "nifi.minifi.notifier.ingestors.pull.http.connect.timeout.ms";
    public static final String READ_TIMEOUT_KEY = "nifi.minifi.notifier.ingestors.pull.http.read.timeout.ms";
    public static final String DIFFERENTIATOR_KEY = "nifi.minifi.notifier.ingestors.pull.http.differentiator";
    public static final String USE_ETAG_KEY = "nifi.minifi.notifier.ingestors.pull.http.use.etag";
    public static final String OVERRIDE_SECURITY = "nifi.minifi.notifier.ingestors.pull.http.override.security";
    private final AtomicReference<OkHttpClient> httpClientReference = new AtomicReference();
    private final AtomicReference<Integer> portReference = new AtomicReference();
    private final AtomicReference<String> hostReference = new AtomicReference();
    private final AtomicReference<String> pathReference = new AtomicReference();
    private final AtomicReference<String> queryReference = new AtomicReference();
    private volatile Differentiator<ByteBuffer> differentiator;
    private volatile String connectionScheme;
    private volatile String lastEtag = "";
    private volatile boolean useEtag = false;
    private volatile boolean overrideSecurity = false;

    public PullHttpChangeIngestor() {
        logger = LoggerFactory.getLogger(PullHttpChangeIngestor.class);
    }

    @Override
    public void initialize(Properties properties, ConfigurationFileHolder configurationFileHolder, ConfigurationChangeNotifier configurationChangeNotifier) {
        super.initialize(properties, configurationFileHolder, configurationChangeNotifier);
        this.pollingPeriodMS.set(Integer.parseInt(properties.getProperty(PULL_HTTP_POLLING_PERIOD_KEY, "300000")));
        if (this.pollingPeriodMS.get() < 1) {
            throw new IllegalArgumentException("Property, nifi.minifi.notifier.ingestors.pull.http.period.ms, for the polling period ms must be set with a positive integer.");
        }
        String host = properties.getProperty(HOST_KEY);
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("Property, nifi.minifi.notifier.ingestors.pull.http.hostname, for the hostname to pull configurations from must be specified.");
        }
        String path = properties.getProperty(PATH_KEY, "/");
        String query = properties.getProperty(QUERY_KEY, "");
        String portString = (String)properties.get(PORT_KEY);
        if (portString == null) {
            throw new IllegalArgumentException("Property, nifi.minifi.notifier.ingestors.pull.http.port, for the hostname to pull configurations from must be specified.");
        }
        Integer port = Integer.parseInt(portString);
        this.portReference.set(port);
        this.hostReference.set(host);
        this.pathReference.set(path);
        this.queryReference.set(query);
        String useEtagString = (String)properties.getOrDefault((Object)USE_ETAG_KEY, "false");
        if (!"true".equalsIgnoreCase(useEtagString) && !"false".equalsIgnoreCase(useEtagString)) {
            throw new IllegalArgumentException("Property, nifi.minifi.notifier.ingestors.pull.http.use.etag, to specify whether to use the ETag header, must either be a value boolean value (\"true\" or \"false\") or left to the default value of \"false\". It is set to \"" + useEtagString + "\".");
        }
        this.useEtag = Boolean.parseBoolean(useEtagString);
        String overrideSecurityProperties = (String)properties.getOrDefault((Object)OVERRIDE_SECURITY, "false");
        if (!"true".equalsIgnoreCase(overrideSecurityProperties) && !"false".equalsIgnoreCase(overrideSecurityProperties)) {
            throw new IllegalArgumentException("Property, nifi.minifi.notifier.ingestors.pull.http.override.security, to specify whether to override security properties must either be a value boolean value (\"true\" or \"false\") or left to the default value of \"false\". It is set to \"" + overrideSecurityProperties + "\".");
        }
        this.overrideSecurity = Boolean.parseBoolean(overrideSecurityProperties);
        this.httpClientReference.set(null);
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        okHttpClientBuilder.connectTimeout(Long.parseLong(properties.getProperty(CONNECT_TIMEOUT_KEY, DEFAULT_CONNECT_TIMEOUT_MS)), TimeUnit.MILLISECONDS);
        okHttpClientBuilder.readTimeout(Long.parseLong(properties.getProperty(READ_TIMEOUT_KEY, DEFAULT_READ_TIMEOUT_MS)), TimeUnit.MILLISECONDS);
        okHttpClientBuilder.followRedirects(true);
        String proxyHost = properties.getProperty(PROXY_HOST_KEY, "");
        if (!proxyHost.isEmpty()) {
            String proxyPort = properties.getProperty(PROXY_PORT_KEY);
            if (proxyPort == null || proxyPort.isEmpty()) {
                throw new IllegalArgumentException("Proxy port required if proxy specified.");
            }
            okHttpClientBuilder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, Integer.parseInt(proxyPort))));
            String proxyUsername = properties.getProperty(PROXY_USERNAME);
            if (proxyUsername != null) {
                String proxyPassword = properties.getProperty(PROXY_PASSWORD);
                if (proxyPassword == null) {
                    throw new IllegalArgumentException("Must specify proxy password with proxy username.");
                }
                okHttpClientBuilder.proxyAuthenticator((route, response) -> response.request().newBuilder().addHeader("Proxy-Authorization", Credentials.basic((String)proxyUsername, (String)proxyPassword)).build());
            }
        }
        if (properties.containsKey(KEYSTORE_LOCATION_KEY)) {
            try {
                this.setSslSocketFactory(okHttpClientBuilder, properties);
                this.connectionScheme = "https";
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        } else {
            this.connectionScheme = "http";
        }
        this.httpClientReference.set(okHttpClientBuilder.build());
        String differentiatorName = properties.getProperty(DIFFERENTIATOR_KEY);
        if (differentiatorName != null && !differentiatorName.isEmpty()) {
            Supplier<Differentiator<ByteBuffer>> differentiatorSupplier = DIFFERENTIATOR_CONSTRUCTOR_MAP.get(differentiatorName);
            if (differentiatorSupplier == null) {
                throw new IllegalArgumentException("Property, nifi.minifi.notifier.ingestors.pull.http.differentiator, has value " + differentiatorName + " which does not correspond to any in the PullHttpChangeIngestor Map:" + DIFFERENTIATOR_CONSTRUCTOR_MAP.keySet());
            }
            this.differentiator = differentiatorSupplier.get();
        } else {
            this.differentiator = WholeConfigDifferentiator.getByteBufferDifferentiator();
        }
        this.differentiator.initialize(properties, configurationFileHolder);
    }

    @Override
    public void run() {
        logger.debug("Attempting to pull new config");
        HttpUrl.Builder builder = new HttpUrl.Builder().host(this.hostReference.get()).port(this.portReference.get().intValue()).encodedPath(this.pathReference.get());
        String query = this.queryReference.get();
        if (!StringUtil.isNullOrEmpty((String)query)) {
            builder = builder.encodedQuery(query);
        }
        HttpUrl url = builder.scheme(this.connectionScheme).build();
        Request.Builder requestBuilder = new Request.Builder().get().url(url);
        if (this.useEtag) {
            requestBuilder.addHeader("If-None-Match", this.lastEtag);
        }
        Request request = requestBuilder.build();
        ResponseBody body = null;
        try (Response response = this.httpClientReference.get().newCall(request).execute();){
            logger.debug("Response received: {}", (Object)response.toString());
            int code = response.code();
            if (code == 304) {
                return;
            }
            if (code >= 400) {
                throw new IOException("Got response code " + code + " while trying to pull configuration: " + response.body().string());
            }
            body = response.body();
            if (body == null) {
                logger.warn("No body returned when pulling a new configuration");
                return;
            }
            ByteBuffer bodyByteBuffer = ByteBuffer.wrap(body.bytes());
            ByteBuffer readOnlyNewConfig = null;
            if (this.overrideSecurity) {
                readOnlyNewConfig = bodyByteBuffer.asReadOnlyBuffer();
            } else {
                logger.debug("Preserving previous security properties...");
                File configFile = new File(((Properties)this.properties.get()).getProperty("nifi.minifi.config"));
                ConvertableSchema configSchema = SchemaLoader.loadConvertableSchemaFromYaml((InputStream)new FileInputStream(configFile));
                ConfigSchema currentSchema = (ConfigSchema)configSchema.convert();
                SecurityPropertiesSchema secProps = currentSchema.getSecurityProperties();
                configSchema = SchemaLoader.loadConvertableSchemaFromYaml((InputStream)new ByteBufferInputStream(bodyByteBuffer.duplicate()));
                ConfigSchema newSchema = (ConfigSchema)configSchema.convert();
                newSchema.setSecurityProperties(secProps);
                readOnlyNewConfig = ByteBuffer.wrap(new Yaml().dump((Object)newSchema.toMap()).getBytes()).asReadOnlyBuffer();
            }
            if (this.differentiator.isNew(readOnlyNewConfig)) {
                logger.debug("New change received, notifying listener");
                this.configurationChangeNotifier.notifyListeners(readOnlyNewConfig);
                logger.debug("Listeners notified");
            } else {
                logger.debug("Pulled config same as currently running.");
            }
            if (this.useEtag) {
                this.lastEtag = "\"" + response.header("ETag").trim() + "\"";
            }
        }
        catch (Exception e) {
            logger.warn("Hit an exception while trying to pull", (Throwable)e);
        }
    }

    private void setSslSocketFactory(OkHttpClient.Builder okHttpClientBuilder, Properties properties) throws Exception {
        SSLContext tempSslContext;
        String keystoreLocation = properties.getProperty(KEYSTORE_LOCATION_KEY);
        String keystorePass = properties.getProperty(KEYSTORE_PASSWORD_KEY);
        String keystoreType = properties.getProperty(KEYSTORE_TYPE_KEY);
        this.assertKeystorePropertiesSet(keystoreLocation, keystorePass, keystoreType);
        KeyStore keyStore = KeyStore.getInstance(keystoreType);
        try (FileInputStream keyStoreStream = new FileInputStream(keystoreLocation);){
            keyStore.load(keyStoreStream, keystorePass.toCharArray());
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keystorePass.toCharArray());
        String truststoreLocation = properties.getProperty(TRUSTSTORE_LOCATION_KEY);
        String truststorePass = properties.getProperty(TRUSTSTORE_PASSWORD_KEY);
        String truststoreType = properties.getProperty(TRUSTSTORE_TYPE_KEY);
        this.assertTruststorePropertiesSet(truststoreLocation, truststorePass, truststoreType);
        KeyStore truststore = KeyStore.getInstance(truststoreType);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("X509");
        truststore.load(new FileInputStream(truststoreLocation), truststorePass.toCharArray());
        trustManagerFactory.init(truststore);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        if (trustManagers[0] == null) {
            throw new IllegalStateException("List of trust managers is null");
        }
        X509TrustManager x509TrustManager = (X509TrustManager)trustManagers[0];
        try {
            tempSslContext = SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("Unable to use 'TLS' for the PullHttpChangeIngestor due to NoSuchAlgorithmException. Will attempt to use the default algorithm.", (Throwable)e);
            tempSslContext = SSLContext.getDefault();
        }
        SSLContext sslContext = tempSslContext;
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        okHttpClientBuilder.sslSocketFactory(sslSocketFactory, x509TrustManager);
    }

    private void assertKeystorePropertiesSet(String location, String password, String type) {
        if (location == null || location.isEmpty()) {
            throw new IllegalArgumentException("nifi.minifi.notifier.ingestors.pull.http.keystore.location is null or is empty");
        }
        if (password == null || password.isEmpty()) {
            throw new IllegalArgumentException("nifi.minifi.notifier.ingestors.pull.http.keystore.location is set but nifi.minifi.notifier.ingestors.pull.http.keystore.password is not (or is empty). If the location is set, the password must also be.");
        }
        if (type == null || type.isEmpty()) {
            throw new IllegalArgumentException("nifi.minifi.notifier.ingestors.pull.http.keystore.location is set but nifi.minifi.notifier.ingestors.pull.http.keystore.type is not (or is empty). If the location is set, the type must also be.");
        }
    }

    private void assertTruststorePropertiesSet(String location, String password, String type) {
        if (location == null || location.isEmpty()) {
            throw new IllegalArgumentException("nifi.minifi.notifier.ingestors.pull.http.truststore.location is not set or is empty");
        }
        if (password == null || password.isEmpty()) {
            throw new IllegalArgumentException("nifi.minifi.notifier.ingestors.pull.http.truststore.location is set but nifi.minifi.notifier.ingestors.pull.http.truststore.password is not (or is empty). If the location is set, the password must also be.");
        }
        if (type == null || type.isEmpty()) {
            throw new IllegalArgumentException("nifi.minifi.notifier.ingestors.pull.http.truststore.location is set but nifi.minifi.notifier.ingestors.pull.http.truststore.type is not (or is empty). If the location is set, the type must also be.");
        }
    }

    protected void setDifferentiator(Differentiator<ByteBuffer> differentiator) {
        this.differentiator = differentiator;
    }

    public void setLastEtag(String lastEtag) {
        this.lastEtag = lastEtag;
    }

    public void setUseEtag(boolean useEtag) {
        this.useEtag = useEtag;
    }

    static {
        HashMap<String, Supplier<Differentiator>> tempMap = new HashMap<String, Supplier<Differentiator>>();
        tempMap.put("Whole Config", WholeConfigDifferentiator::getByteBufferDifferentiator);
        DIFFERENTIATOR_CONSTRUCTOR_MAP = Collections.unmodifiableMap(tempMap);
    }
}

