/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.configuration.differentiators;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.minifi.bootstrap.ConfigurationFileHolder;
import org.apache.nifi.minifi.bootstrap.configuration.differentiators.interfaces.Differentiator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WholeConfigDifferentiator {
    private static final Logger logger = LoggerFactory.getLogger(WholeConfigDifferentiator.class);
    public static final String WHOLE_CONFIG_KEY = "Whole Config";
    volatile ConfigurationFileHolder configurationFileHolder;

    boolean compareInputStreamToConfigFile(InputStream inputStream) throws IOException {
        logger.debug("Checking if change is different");
        AtomicReference<ByteBuffer> currentConfigFileReference = this.configurationFileHolder.getConfigFileReference();
        ByteBuffer currentConfigFile = currentConfigFileReference.get();
        ByteBuffer byteBuffer = ByteBuffer.allocate(currentConfigFile.limit());
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            dataInputStream.readFully(byteBuffer.array());
        }
        catch (EOFException e) {
            logger.debug("New config is shorter than the current. Must be different.");
            return true;
        }
        logger.debug("Read the input");
        if (dataInputStream.available() != 0) {
            return true;
        }
        return byteBuffer.compareTo(currentConfigFile) != 0;
    }

    public void initialize(Properties properties, ConfigurationFileHolder configurationFileHolder) {
        this.configurationFileHolder = configurationFileHolder;
    }

    public static Differentiator<InputStream> getInputStreamDifferentiator() {
        return new InputStreamInput();
    }

    public static Differentiator<ByteBuffer> getByteBufferDifferentiator() {
        return new ByteBufferInput();
    }

    public static class ByteBufferInput
    extends WholeConfigDifferentiator
    implements Differentiator<ByteBuffer> {
        @Override
        public boolean isNew(ByteBuffer inputBuffer) {
            AtomicReference<ByteBuffer> currentConfigFileReference = this.configurationFileHolder.getConfigFileReference();
            ByteBuffer currentConfigFile = currentConfigFileReference.get();
            return inputBuffer.compareTo(currentConfigFile) != 0;
        }
    }

    public static class InputStreamInput
    extends WholeConfigDifferentiator
    implements Differentiator<InputStream> {
        @Override
        public boolean isNew(InputStream inputStream) throws IOException {
            return this.compareInputStreamToConfigFile(inputStream);
        }
    }
}

