/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.configuration;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.nifi.minifi.bootstrap.ConfigurationFileHolder;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeException;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeListener;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeNotifier;
import org.apache.nifi.minifi.bootstrap.configuration.ListenerHandleResult;
import org.apache.nifi.minifi.bootstrap.configuration.ingestors.interfaces.ChangeIngestor;
import org.apache.nifi.minifi.bootstrap.util.ByteBufferInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationChangeCoordinator
implements Closeable,
ConfigurationChangeNotifier {
    public static final String NOTIFIER_PROPERTY_PREFIX = "nifi.minifi.notifier";
    public static final String NOTIFIER_INGESTORS_KEY = "nifi.minifi.notifier.ingestors";
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationChangeCoordinator.class);
    private final Set<ConfigurationChangeListener> configurationChangeListeners = new HashSet<ConfigurationChangeListener>();
    private final Set<ChangeIngestor> changeIngestors = new HashSet<ChangeIngestor>();

    public void initialize(Properties properties, ConfigurationFileHolder configurationFileHolder, Collection<ConfigurationChangeListener> changeListenerSet) {
        String ingestorsCsv = properties.getProperty(NOTIFIER_INGESTORS_KEY);
        if (ingestorsCsv != null && !ingestorsCsv.isEmpty()) {
            for (String ingestorClassname : Arrays.asList(ingestorsCsv.split(","))) {
                ingestorClassname = ingestorClassname.trim();
                try {
                    Class<?> ingestorClass = Class.forName(ingestorClassname);
                    ChangeIngestor changeIngestor = (ChangeIngestor)ingestorClass.newInstance();
                    changeIngestor.initialize(properties, configurationFileHolder, this);
                    this.changeIngestors.add(changeIngestor);
                    logger.info("Initialized ");
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException("Issue instantiating ingestor " + ingestorClassname, e);
                }
            }
        }
        this.configurationChangeListeners.clear();
        this.configurationChangeListeners.addAll(changeListenerSet);
    }

    public void start() {
        this.changeIngestors.forEach(ChangeIngestor::start);
    }

    @Override
    public Set<ConfigurationChangeListener> getChangeListeners() {
        return Collections.unmodifiableSet(this.configurationChangeListeners);
    }

    @Override
    public Collection<ListenerHandleResult> notifyListeners(ByteBuffer newConfig) {
        logger.info("Notifying Listeners of a change");
        ArrayList<ListenerHandleResult> listenerHandleResults = new ArrayList<ListenerHandleResult>(this.configurationChangeListeners.size());
        for (ConfigurationChangeListener listener : this.getChangeListeners()) {
            ListenerHandleResult result;
            try {
                listener.handleChange(new ByteBufferInputStream(newConfig.duplicate()));
                result = new ListenerHandleResult(listener);
            }
            catch (ConfigurationChangeException ex) {
                result = new ListenerHandleResult(listener, ex);
            }
            listenerHandleResults.add(result);
            logger.info("Listener notification result:" + result.toString());
        }
        return listenerHandleResults;
    }

    @Override
    public void close() throws IOException {
        for (ChangeIngestor changeIngestor : this.changeIngestors) {
            changeIngestor.close();
        }
    }
}

