/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.minifi.bootstrap.RunMiNiFi;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeCoordinator;
import org.apache.nifi.minifi.bootstrap.status.PeriodicStatusReporter;

public class ShutdownHook
extends Thread {
    private final Process nifiProcess;
    private final RunMiNiFi runner;
    private final int gracefulShutdownSeconds;
    private final ExecutorService executor;
    private volatile String secretKey;

    public ShutdownHook(Process nifiProcess, RunMiNiFi runner, String secretKey, int gracefulShutdownSeconds, ExecutorService executor) {
        this.nifiProcess = nifiProcess;
        this.runner = runner;
        this.secretKey = secretKey;
        this.gracefulShutdownSeconds = gracefulShutdownSeconds;
        this.executor = executor;
    }

    void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @Override
    public void run() {
        this.executor.shutdown();
        System.out.println("Initiating shutdown of bootstrap change ingestors...");
        ConfigurationChangeCoordinator notifier = this.runner.getChangeCoordinator();
        if (notifier != null) {
            try {
                notifier.close();
            }
            catch (IOException ioe) {
                System.out.println("Could not successfully stop notifier due to " + ioe);
            }
        }
        System.out.println("Initiating shutdown of bootstrap periodic status reporters...");
        for (PeriodicStatusReporter periodicStatusReporter : this.runner.getPeriodicStatusReporters()) {
            try {
                periodicStatusReporter.stop();
            }
            catch (Exception exception) {
                System.out.println("Could not successfully stop periodic status reporter " + periodicStatusReporter.getClass() + " due to " + exception);
            }
        }
        this.runner.setAutoRestartNiFi(false);
        int ccPort = this.runner.getNiFiCommandControlPort();
        if (ccPort > 0) {
            System.out.println("Initiating Shutdown of MiNiFi...");
            try {
                Socket socket = new Socket("localhost", ccPort);
                OutputStream out = socket.getOutputStream();
                out.write(("SHUTDOWN " + this.secretKey + "\n").getBytes(StandardCharsets.UTF_8));
                out.flush();
                socket.close();
            }
            catch (IOException ioe) {
                System.out.println("Failed to Shutdown MiNiFi due to " + ioe);
            }
        }
        System.out.println("Waiting for Apache MiNiFi to finish shutting down...");
        long startWait = System.nanoTime();
        while (RunMiNiFi.isAlive(this.nifiProcess)) {
            long waitNanos = System.nanoTime() - startWait;
            long waitSeconds = TimeUnit.NANOSECONDS.toSeconds(waitNanos);
            if (waitSeconds >= (long)this.gracefulShutdownSeconds && this.gracefulShutdownSeconds > 0) {
                if (!RunMiNiFi.isAlive(this.nifiProcess)) break;
                System.out.println("MiNiFi has not finished shutting down after " + this.gracefulShutdownSeconds + " seconds. Killing process.");
                this.nifiProcess.destroy();
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            File statusFile = this.runner.getStatusFile();
            if (!statusFile.delete()) {
                System.err.println("Failed to delete status file " + statusFile.getAbsolutePath() + "; this file should be cleaned up manually");
            }
        }
        catch (IOException ex) {
            System.err.println("Failed to retrieve status file " + ex);
        }
        System.out.println("MiNiFi is done shutting down");
    }
}

