/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermission;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.bootstrap.util.OSUtils;
import org.apache.nifi.minifi.bootstrap.ConfigurationFileHolder;
import org.apache.nifi.minifi.bootstrap.MiNiFiListener;
import org.apache.nifi.minifi.bootstrap.QueryableStatusAggregator;
import org.apache.nifi.minifi.bootstrap.ShutdownHook;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeCoordinator;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeException;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeListener;
import org.apache.nifi.minifi.bootstrap.status.PeriodicStatusReporter;
import org.apache.nifi.minifi.commons.status.FlowStatusReport;
import org.apache.nifi.util.Tuple;
import org.apache.nifi.util.file.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunMiNiFi
implements QueryableStatusAggregator,
ConfigurationFileHolder {
    public static final String DEFAULT_CONFIG_FILE = "./conf/bootstrap.conf";
    public static final String DEFAULT_NIFI_PROPS_FILE = "./conf/nifi.properties";
    public static final String DEFAULT_JAVA_CMD = "java";
    public static final String DEFAULT_PID_DIR = "bin";
    public static final String DEFAULT_LOG_DIR = "./logs";
    public static final String CONF_DIR_KEY = "conf.dir";
    public static final String MINIFI_CONFIG_FILE_KEY = "nifi.minifi.config";
    public static final String GRACEFUL_SHUTDOWN_PROP = "graceful.shutdown.seconds";
    public static final String DEFAULT_GRACEFUL_SHUTDOWN_VALUE = "20";
    public static final String MINIFI_PID_DIR_PROP = "org.apache.nifi.minifi.bootstrap.config.pid.dir";
    public static final String MINIFI_PID_FILE_NAME = "minifi.pid";
    public static final String MINIFI_STATUS_FILE_NAME = "minifi.status";
    public static final String MINIFI_LOCK_FILE_NAME = "minifi.lock";
    public static final String PID_KEY = "pid";
    public static final int STARTUP_WAIT_SECONDS = 60;
    public static final String SHUTDOWN_CMD = "SHUTDOWN";
    public static final String RELOAD_CMD = "RELOAD";
    public static final String PING_CMD = "PING";
    public static final String DUMP_CMD = "DUMP";
    public static final String FLOW_STATUS_REPORT_CMD = "FLOW_STATUS_REPORT";
    private static final int UNINITIALIZED_CC_PORT = -1;
    private volatile boolean autoRestartNiFi = true;
    private volatile int ccPort = -1;
    private volatile long minifiPid = -1L;
    private volatile String secretKey;
    private volatile ShutdownHook shutdownHook;
    private volatile boolean nifiStarted;
    private final Lock startedLock = new ReentrantLock();
    private final Lock lock = new ReentrantLock();
    private final Condition startupCondition = this.lock.newCondition();
    private final File bootstrapConfigFile;
    private final Logger cmdLogger = LoggerFactory.getLogger((String)"org.apache.nifi.minifi.bootstrap.Command");
    private final Logger defaultLogger = LoggerFactory.getLogger(RunMiNiFi.class);
    private final ExecutorService loggingExecutor;
    private volatile Set<Future<?>> loggingFutures = new HashSet(2);
    private volatile int gracefulShutdownSeconds;
    private Set<PeriodicStatusReporter> periodicStatusReporters;
    private ConfigurationChangeCoordinator changeCoordinator;
    private MiNiFiConfigurationChangeListener changeListener;
    private final AtomicReference<ByteBuffer> currentConfigFileReference = new AtomicReference();
    private AtomicBoolean reloading = new AtomicBoolean(false);
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");

    @Override
    public AtomicReference<ByteBuffer> getConfigFileReference() {
        return this.currentConfigFileReference;
    }

    public RunMiNiFi(File bootstrapConfigFile) throws IOException {
        this.bootstrapConfigFile = bootstrapConfigFile;
        this.loggingExecutor = Executors.newFixedThreadPool(2, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread t = Executors.defaultThreadFactory().newThread(runnable);
                t.setDaemon(true);
                t.setName("MiNiFi logging handler");
                return t;
            }
        });
    }

    private static void printUsage() {
        System.out.println("Usage:");
        System.out.println();
        System.out.println("java org.apache.nifi.minifi.bootstrap.RunMiNiFi <command> [options]");
        System.out.println();
        System.out.println("Valid commands include:");
        System.out.println("");
        System.out.println("Start : Start a new instance of Apache MiNiFi");
        System.out.println("Stop : Stop a running instance of Apache MiNiFi");
        System.out.println("Restart : Stop Apache MiNiFi, if it is running, and then start a new instance");
        System.out.println("Status : Determine if there is a running instance of Apache MiNiFi");
        System.out.println("Dump : Write a Thread Dump to the file specified by [options], or to the log if no file is given");
        System.out.println("Run : Start a new instance of Apache MiNiFi and monitor the Process, restarting if the instance dies");
        System.out.println("FlowStatus : Get the status of the MiNiFi flow. For usage, read the System Admin Guide 'FlowStatus Query Options' section.");
        System.out.println();
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        if (args.length < 1 || args.length > 3) {
            RunMiNiFi.printUsage();
            return;
        }
        File dumpFile = null;
        String cmd = args[0];
        if (cmd.equals("dump")) {
            dumpFile = args.length > 1 ? new File(args[1]) : null;
        }
        switch (cmd.toLowerCase()) {
            case "start": 
            case "run": 
            case "stop": 
            case "status": 
            case "dump": 
            case "restart": 
            case "env": 
            case "flowstatus": {
                break;
            }
            default: {
                RunMiNiFi.printUsage();
                return;
            }
        }
        File configFile = RunMiNiFi.getBootstrapConfFile();
        RunMiNiFi runMiNiFi = new RunMiNiFi(configFile);
        Integer exitStatus = null;
        switch (cmd.toLowerCase()) {
            case "start": {
                runMiNiFi.start();
                break;
            }
            case "run": {
                runMiNiFi.start();
                break;
            }
            case "stop": {
                runMiNiFi.stop();
                break;
            }
            case "status": {
                exitStatus = runMiNiFi.status();
                break;
            }
            case "restart": {
                runMiNiFi.stop();
                runMiNiFi.start();
                break;
            }
            case "dump": {
                runMiNiFi.dump(dumpFile);
                break;
            }
            case "env": {
                runMiNiFi.env();
                break;
            }
            case "flowstatus": {
                if (args.length == 2) {
                    System.out.println(runMiNiFi.statusReport(args[1]));
                    break;
                }
                System.out.println("The 'flowStatus' command requires an input query. See the System Admin Guide 'FlowStatus Script Query' section for complete details.");
            }
        }
        if (exitStatus != null) {
            System.exit(exitStatus);
        }
    }

    public static File getBootstrapConfFile() {
        String nifiHome;
        String configFilename = System.getProperty("org.apache.nifi.minifi.bootstrap.config.file");
        if (configFilename == null && (nifiHome = System.getenv("MINIFI_HOME")) != null) {
            File nifiHomeFile = new File(nifiHome.trim());
            File configFile = new File(nifiHomeFile, DEFAULT_CONFIG_FILE);
            configFilename = configFile.getAbsolutePath();
        }
        if (configFilename == null) {
            configFilename = DEFAULT_CONFIG_FILE;
        }
        File configFile = new File(configFilename);
        return configFile;
    }

    private File getBootstrapFile(Logger logger, String directory, String defaultDirectory, String fileName) throws IOException {
        File confDir = this.bootstrapConfigFile.getParentFile();
        File nifiHome = confDir.getParentFile();
        String confFileDir = System.getProperty(directory);
        File fileDir = confFileDir != null ? new File(confFileDir.trim()) : new File(nifiHome, defaultDirectory);
        FileUtils.ensureDirectoryExistAndCanAccess((File)fileDir);
        File statusFile = new File(fileDir, fileName);
        logger.debug("Status File: {}", (Object)statusFile);
        return statusFile;
    }

    File getPidFile(Logger logger) throws IOException {
        return this.getBootstrapFile(logger, MINIFI_PID_DIR_PROP, DEFAULT_PID_DIR, MINIFI_PID_FILE_NAME);
    }

    File getStatusFile(Logger logger) throws IOException {
        return this.getBootstrapFile(logger, MINIFI_PID_DIR_PROP, DEFAULT_PID_DIR, MINIFI_STATUS_FILE_NAME);
    }

    File getLockFile(Logger logger) throws IOException {
        return this.getBootstrapFile(logger, MINIFI_PID_DIR_PROP, DEFAULT_PID_DIR, MINIFI_LOCK_FILE_NAME);
    }

    File getStatusFile() throws IOException {
        return this.getStatusFile(this.defaultLogger);
    }

    public File getReloadFile(Logger logger) {
        File confDir = this.bootstrapConfigFile.getParentFile();
        File nifiHome = confDir.getParentFile();
        File bin = new File(nifiHome, DEFAULT_PID_DIR);
        File reloadFile = new File(bin, "minifi.reload.lock");
        logger.debug("Reload File: {}", (Object)reloadFile);
        return reloadFile;
    }

    public File getSwapFile(Logger logger) {
        File confDir = this.bootstrapConfigFile.getParentFile();
        File swapFile = new File(confDir, "swap.yml");
        logger.debug("Swap File: {}", (Object)swapFile);
        return swapFile;
    }

    private Properties loadProperties(Logger logger) throws IOException {
        Properties props = new Properties();
        File statusFile = this.getStatusFile(logger);
        if (statusFile == null || !statusFile.exists()) {
            logger.debug("No status file to load properties from");
            return props;
        }
        try (FileInputStream fis = new FileInputStream(this.getStatusFile(logger));){
            props.load(fis);
        }
        HashMap<Object, Object> modified = new HashMap<Object, Object>(props);
        modified.remove("secret.key");
        logger.debug("Properties: {}", modified);
        return props;
    }

    private synchronized void saveProperties(Properties minifiProps, Logger logger) throws IOException {
        File statusFile;
        String pid = minifiProps.getProperty(PID_KEY);
        if (!StringUtils.isBlank((CharSequence)pid)) {
            this.writePidFile(pid, logger);
        }
        if ((statusFile = this.getStatusFile(logger)).exists() && !statusFile.delete()) {
            logger.warn("Failed to delete {}", (Object)statusFile);
        }
        if (!statusFile.createNewFile()) {
            throw new IOException("Failed to create file " + statusFile);
        }
        try {
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
            perms.add(PosixFilePermission.OWNER_WRITE);
            perms.add(PosixFilePermission.OWNER_READ);
            perms.add(PosixFilePermission.GROUP_READ);
            perms.add(PosixFilePermission.OTHERS_READ);
            Files.setPosixFilePermissions(statusFile.toPath(), perms);
        }
        catch (Exception e) {
            logger.warn("Failed to set permissions so that only the owner can read status file {}; this may allows others to have access to the key needed to communicate with MiNiFi. Permissions should be changed so that only the owner can read this file", (Object)statusFile);
        }
        try (FileOutputStream fos = new FileOutputStream(statusFile);){
            minifiProps.store(fos, null);
            fos.getFD().sync();
        }
        logger.debug("Saved Properties {} to {}", new Object[]{minifiProps, statusFile});
    }

    private synchronized void writePidFile(String pid, Logger logger) throws IOException {
        File pidFile = this.getPidFile(logger);
        if (pidFile.exists() && !pidFile.delete()) {
            logger.warn("Failed to delete {}", (Object)pidFile);
        }
        if (!pidFile.createNewFile()) {
            throw new IOException("Failed to create file " + pidFile);
        }
        try {
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
            perms.add(PosixFilePermission.OWNER_READ);
            perms.add(PosixFilePermission.OWNER_WRITE);
            Files.setPosixFilePermissions(pidFile.toPath(), perms);
        }
        catch (Exception e) {
            logger.warn("Failed to set permissions so that only the owner can read pid file {}; this may allows others to have access to the key needed to communicate with MiNiFi. Permissions should be changed so that only the owner can read this file", (Object)pidFile);
        }
        try (FileOutputStream fos = new FileOutputStream(pidFile);){
            fos.write(pid.getBytes(StandardCharsets.UTF_8));
            fos.getFD().sync();
        }
        logger.debug("Saved Pid {} to {}", new Object[]{pid, pidFile});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isPingSuccessful(int port, String secretKey, Logger logger) {
        logger.debug("Pinging {}", (Object)port);
        try (Socket socket = new Socket("localhost", port);){
            OutputStream out = socket.getOutputStream();
            out.write(("PING " + secretKey + "\n").getBytes(StandardCharsets.UTF_8));
            out.flush();
            logger.debug("Sent PING command");
            socket.setSoTimeout(5000);
            InputStream in = socket.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String response = reader.readLine();
            logger.debug("PING response: {}", (Object)response);
            out.close();
            reader.close();
            boolean bl = PING_CMD.equals(response);
            return bl;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    private Integer getCurrentPort(Logger logger) throws IOException {
        Properties props = this.loadProperties(logger);
        String portVal = props.getProperty("port");
        if (portVal == null) {
            logger.debug("No Port found in status file");
            return null;
        }
        logger.debug("Port defined in status file: {}", (Object)portVal);
        int port = Integer.parseInt(portVal);
        boolean success = this.isPingSuccessful(port, props.getProperty("secret.key"), logger);
        if (success) {
            logger.debug("Successful PING on port {}", (Object)port);
            return port;
        }
        String pid = props.getProperty(PID_KEY);
        logger.debug("PID in status file is {}", (Object)pid);
        if (pid != null) {
            boolean procRunning = this.isProcessRunning(pid, logger);
            if (procRunning) {
                return port;
            }
            return null;
        }
        return null;
    }

    private boolean isProcessRunning(String pid, Logger logger) {
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command("ps", "-p", pid);
            Process proc = builder.start();
            boolean running = false;
            try (InputStream in = proc.getInputStream();
                 InputStreamReader streamReader = new InputStreamReader(in);
                 BufferedReader reader = new BufferedReader(streamReader);){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!line.trim().startsWith(pid)) continue;
                    running = true;
                }
            }
            if (running) {
                logger.debug("Process with PID {} is running", (Object)pid);
            } else {
                logger.debug("Process with PID {} is not running", (Object)pid);
            }
            return running;
        }
        catch (IOException ioe) {
            System.err.println("Failed to determine if Process " + pid + " is running; assuming that it is not");
            return false;
        }
    }

    private Status getStatus(Logger logger) {
        Properties props;
        try {
            props = this.loadProperties(logger);
        }
        catch (IOException ioe) {
            return new Status(null, null, false, false);
        }
        if (props == null) {
            return new Status(null, null, false, false);
        }
        String portValue = props.getProperty("port");
        String pid = props.getProperty(PID_KEY);
        String secretKey = props.getProperty("secret.key");
        if (portValue == null && pid == null) {
            return new Status(null, null, false, false);
        }
        Integer port = null;
        boolean pingSuccess = false;
        if (portValue != null) {
            try {
                port = Integer.parseInt(portValue);
                pingSuccess = this.isPingSuccessful(port, secretKey, logger);
            }
            catch (NumberFormatException nfe) {
                return new Status(null, null, false, false);
            }
        }
        if (pingSuccess) {
            return new Status(port, pid, true, true);
        }
        boolean alive = pid != null && this.isProcessRunning(pid, logger);
        return new Status(port, pid, pingSuccess, alive);
    }

    public int status() throws IOException {
        Logger logger = this.cmdLogger;
        Status status = this.getStatus(logger);
        if (status.isRespondingToPing()) {
            logger.info("Apache MiNiFi is currently running, listening to Bootstrap on port {}, PID={}", new Object[]{status.getPort(), status.getPid() == null ? "unknown" : status.getPid()});
            return 0;
        }
        if (status.isProcessRunning()) {
            logger.info("Apache MiNiFi is running at PID {} but is not responding to ping requests", (Object)status.getPid());
            return 4;
        }
        if (status.getPort() == null) {
            logger.info("Apache MiNiFi is not running");
            return 3;
        }
        if (status.getPid() == null) {
            logger.info("Apache MiNiFi is not responding to Ping requests. The process may have died or may be hung");
        } else {
            logger.info("Apache MiNiFi is not running");
        }
        return 3;
    }

    @Override
    public FlowStatusReport statusReport(String statusRequest) throws IOException {
        Logger logger = this.cmdLogger;
        Status status = this.getStatus(logger);
        Properties props = this.loadProperties(logger);
        LinkedList<String> problemsGeneratingReport = new LinkedList<String>();
        if (!status.isProcessRunning()) {
            problemsGeneratingReport.add("MiNiFi process is not running");
        }
        if (!status.isRespondingToPing()) {
            problemsGeneratingReport.add("MiNiFi process is not responding to pings");
        }
        if (!problemsGeneratingReport.isEmpty()) {
            FlowStatusReport flowStatusReport = new FlowStatusReport();
            flowStatusReport.setErrorsGeneratingReport(problemsGeneratingReport);
            return flowStatusReport;
        }
        return this.getFlowStatusReport(statusRequest, status.getPort(), props.getProperty("secret.key"), logger);
    }

    public void env() {
        Object virtualMachine;
        Method detachMethod;
        Method attachMethod;
        Class<?> virtualMachineClass;
        Logger logger = this.cmdLogger;
        Status status = this.getStatus(logger);
        if (status.getPid() == null) {
            logger.info("Apache MiNiFi is not running");
            return;
        }
        try {
            virtualMachineClass = Class.forName("com.sun.tools.attach.VirtualMachine");
        }
        catch (ClassNotFoundException cnfe) {
            logger.error("Seems tools.jar (Linux / Windows JDK) or classes.jar (Mac OS) is not available in classpath");
            return;
        }
        try {
            attachMethod = virtualMachineClass.getMethod("attach", String.class);
            detachMethod = virtualMachineClass.getDeclaredMethod("detach", new Class[0]);
        }
        catch (Exception e) {
            logger.error("Methods required for getting environment not available", (Throwable)e);
            return;
        }
        try {
            virtualMachine = attachMethod.invoke(null, status.getPid());
        }
        catch (Throwable t) {
            logger.error("Problem attaching to MiNiFi", t);
            return;
        }
        try {
            Method getSystemPropertiesMethod = virtualMachine.getClass().getMethod("getSystemProperties", new Class[0]);
            Properties sysProps = (Properties)getSystemPropertiesMethod.invoke(virtualMachine, new Object[0]);
            for (Map.Entry<Object, Object> syspropEntry : sysProps.entrySet()) {
                logger.info(syspropEntry.getKey().toString() + " = " + syspropEntry.getValue().toString());
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            try {
                detachMethod.invoke(virtualMachine, new Object[0]);
            }
            catch (Exception e) {
                logger.warn("Caught exception detaching from process", (Throwable)e);
            }
        }
    }

    public void dump(File dumpFile) throws IOException {
        Logger logger = this.defaultLogger;
        Integer port = this.getCurrentPort(logger);
        if (port == null) {
            logger.info("Apache MiNiFi is not currently running");
            return;
        }
        Properties minifiProps = this.loadProperties(logger);
        String secretKey = minifiProps.getProperty("secret.key");
        StringBuilder sb = new StringBuilder();
        try (Socket socket = new Socket();){
            logger.debug("Connecting to MiNiFi instance");
            socket.setSoTimeout(60000);
            socket.connect(new InetSocketAddress("localhost", (int)port));
            logger.debug("Established connection to MiNiFi instance.");
            socket.setSoTimeout(60000);
            logger.debug("Sending DUMP Command to port {}", (Object)port);
            OutputStream out = socket.getOutputStream();
            out.write(("DUMP " + secretKey + "\n").getBytes(StandardCharsets.UTF_8));
            out.flush();
            InputStream in = socket.getInputStream();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
            }
        }
        String dump = sb.toString();
        if (dumpFile == null) {
            logger.info(dump);
        } else {
            try (FileOutputStream fos = new FileOutputStream(dumpFile);){
                fos.write(dump.getBytes(StandardCharsets.UTF_8));
            }
            this.cmdLogger.info("Successfully wrote thread dump to {}", (Object)dumpFile.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() throws IOException {
        block32: {
            Logger logger = this.defaultLogger;
            Integer port = this.getCurrentPort(logger);
            if (port == null) {
                logger.info("Apache MiNiFi is not currently running");
                return;
            }
            File reloadLockFile = this.getReloadFile(logger);
            if (!reloadLockFile.exists()) {
                reloadLockFile.createNewFile();
            }
            Properties minifiProps = this.loadProperties(logger);
            String secretKey = minifiProps.getProperty("secret.key");
            String pid = minifiProps.getProperty(PID_KEY);
            try (Socket socket = new Socket();){
                int lastChar;
                logger.debug("Connecting to MiNiFi instance");
                socket.setSoTimeout(10000);
                socket.connect(new InetSocketAddress("localhost", (int)port));
                logger.debug("Established connection to MiNiFi instance.");
                socket.setSoTimeout(10000);
                logger.debug("Sending RELOAD Command to port {}", (Object)port);
                OutputStream out = socket.getOutputStream();
                out.write(("RELOAD " + secretKey + "\n").getBytes(StandardCharsets.UTF_8));
                out.flush();
                socket.shutdownOutput();
                InputStream in = socket.getInputStream();
                StringBuilder sb = new StringBuilder();
                while ((lastChar = in.read()) > -1) {
                    sb.append((char)lastChar);
                }
                String response = sb.toString().trim();
                logger.debug("Received response to RELOAD command: {}", (Object)response);
                if (RELOAD_CMD.equals(response)) {
                    int gracefulShutdownSeconds;
                    logger.info("Apache MiNiFi has accepted the Reload Command and is reloading");
                    if (pid == null) break block32;
                    Properties bootstrapProperties = this.getBootstrapProperties();
                    String gracefulShutdown = bootstrapProperties.getProperty(GRACEFUL_SHUTDOWN_PROP, DEFAULT_GRACEFUL_SHUTDOWN_VALUE);
                    try {
                        gracefulShutdownSeconds = Integer.parseInt(gracefulShutdown);
                    }
                    catch (NumberFormatException nfe) {
                        gracefulShutdownSeconds = Integer.parseInt(DEFAULT_GRACEFUL_SHUTDOWN_VALUE);
                    }
                    long startWait = System.nanoTime();
                    while (this.isProcessRunning(pid, logger)) {
                        logger.info("Waiting for Apache MiNiFi to finish shutting down...");
                        long waitNanos = System.nanoTime() - startWait;
                        long waitSeconds = TimeUnit.NANOSECONDS.toSeconds(waitNanos);
                        if (waitSeconds >= (long)gracefulShutdownSeconds && gracefulShutdownSeconds > 0) {
                            if (!this.isProcessRunning(pid, logger)) break;
                            logger.warn("MiNiFi has not finished shutting down after {} seconds as part of configuration reload. Killing process.", (Object)gracefulShutdownSeconds);
                            try {
                                this.killProcessTree(pid, logger);
                            }
                            catch (IOException ioe) {
                                logger.error("Failed to kill Process with PID {}", (Object)pid);
                            }
                            break;
                        }
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.reloading.set(true);
                    logger.info("MiNiFi has finished shutting down and will be reloaded.");
                    break block32;
                }
                logger.error("When sending RELOAD command to MiNiFi, got unexpected response {}", (Object)response);
            }
            catch (IOException ioe) {
                if (pid == null) {
                    logger.error("Failed to send shutdown command to port {} due to {}. No PID found for the MiNiFi process, so unable to kill process; the process should be killed manually.", new Object[]{port, ioe.toString()});
                } else {
                    logger.error("Failed to send shutdown command to port {} due to {}. Will kill the MiNiFi Process with PID {}.", new Object[]{port, ioe.toString(), pid});
                    this.killProcessTree(pid, logger);
                }
            }
            finally {
                if (reloadLockFile.exists() && !reloadLockFile.delete()) {
                    logger.error("Failed to delete reload lock file {}; this file should be cleaned up manually", (Object)reloadLockFile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        block35: {
            Logger logger = this.cmdLogger;
            Integer port = this.getCurrentPort(logger);
            if (port == null) {
                logger.info("Apache MiNiFi is not currently running");
                return;
            }
            File lockFile = this.getLockFile(logger);
            if (!lockFile.exists()) {
                lockFile.createNewFile();
            }
            Properties minifiProps = this.loadProperties(logger);
            String secretKey = minifiProps.getProperty("secret.key");
            String pid = minifiProps.getProperty(PID_KEY);
            File statusFile = this.getStatusFile(logger);
            File pidFile = this.getPidFile(logger);
            try (Socket socket = new Socket();){
                int lastChar;
                logger.debug("Connecting to MiNiFi instance");
                socket.setSoTimeout(10000);
                socket.connect(new InetSocketAddress("localhost", (int)port));
                logger.debug("Established connection to MiNiFi instance.");
                socket.setSoTimeout(10000);
                logger.debug("Sending SHUTDOWN Command to port {}", (Object)port);
                OutputStream out = socket.getOutputStream();
                out.write(("SHUTDOWN " + secretKey + "\n").getBytes(StandardCharsets.UTF_8));
                out.flush();
                socket.shutdownOutput();
                InputStream in = socket.getInputStream();
                StringBuilder sb = new StringBuilder();
                while ((lastChar = in.read()) > -1) {
                    sb.append((char)lastChar);
                }
                String response = sb.toString().trim();
                logger.debug("Received response to SHUTDOWN command: {}", (Object)response);
                if (SHUTDOWN_CMD.equals(response)) {
                    int gracefulShutdownSeconds;
                    logger.info("Apache MiNiFi has accepted the Shutdown Command and is shutting down now");
                    if (pid == null) break block35;
                    Properties bootstrapProperties = this.getBootstrapProperties();
                    String gracefulShutdown = bootstrapProperties.getProperty(GRACEFUL_SHUTDOWN_PROP, DEFAULT_GRACEFUL_SHUTDOWN_VALUE);
                    try {
                        gracefulShutdownSeconds = Integer.parseInt(gracefulShutdown);
                    }
                    catch (NumberFormatException nfe) {
                        gracefulShutdownSeconds = Integer.parseInt(DEFAULT_GRACEFUL_SHUTDOWN_VALUE);
                    }
                    long startWait = System.nanoTime();
                    while (this.isProcessRunning(pid, logger)) {
                        logger.info("Waiting for Apache MiNiFi to finish shutting down...");
                        long waitNanos = System.nanoTime() - startWait;
                        long waitSeconds = TimeUnit.NANOSECONDS.toSeconds(waitNanos);
                        if (waitSeconds >= (long)gracefulShutdownSeconds && gracefulShutdownSeconds > 0) {
                            if (!this.isProcessRunning(pid, logger)) break;
                            logger.warn("MiNiFi has not finished shutting down after {} seconds. Killing process.", (Object)gracefulShutdownSeconds);
                            try {
                                this.killProcessTree(pid, logger);
                            }
                            catch (IOException ioe) {
                                logger.error("Failed to kill Process with PID {}", (Object)pid);
                            }
                            break;
                        }
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (statusFile.exists() && !statusFile.delete()) {
                        logger.error("Failed to delete status file {}; this file should be cleaned up manually", (Object)statusFile);
                    }
                    if (pidFile.exists() && !pidFile.delete()) {
                        logger.error("Failed to delete pid file {}; this file should be cleaned up manually", (Object)pidFile);
                    }
                    logger.info("MiNiFi has finished shutting down.");
                    break block35;
                }
                logger.error("When sending SHUTDOWN command to MiNiFi, got unexpected response {}", (Object)response);
            }
            catch (IOException ioe) {
                if (pid == null) {
                    logger.error("Failed to send shutdown command to port {} due to {}. No PID found for the MiNiFi process, so unable to kill process; the process should be killed manually.", new Object[]{port, ioe.toString()});
                } else {
                    logger.error("Failed to send shutdown command to port {} due to {}. Will kill the MiNiFi Process with PID {}.", new Object[]{port, ioe.toString(), pid});
                    this.killProcessTree(pid, logger);
                    if (statusFile.exists() && !statusFile.delete()) {
                        logger.error("Failed to delete status file {}; this file should be cleaned up manually", (Object)statusFile);
                    }
                }
            }
            finally {
                if (lockFile.exists() && !lockFile.delete()) {
                    logger.error("Failed to delete lock file {}; this file should be cleaned up manually", (Object)lockFile);
                }
            }
        }
    }

    private Properties getBootstrapProperties() throws IOException {
        Properties bootstrapProperties = new Properties();
        try (FileInputStream fis = new FileInputStream(this.bootstrapConfigFile);){
            bootstrapProperties.load(fis);
        }
        return bootstrapProperties;
    }

    private static List<String> getChildProcesses(String ppid) throws IOException {
        Process proc = Runtime.getRuntime().exec(new String[]{"ps", "-o", PID_KEY, "--no-headers", "--ppid", ppid});
        ArrayList<String> childPids = new ArrayList<String>();
        try (InputStream in = proc.getInputStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = reader.readLine()) != null) {
                childPids.add(line.trim());
            }
        }
        return childPids;
    }

    private void killProcessTree(String pid, Logger logger) throws IOException {
        logger.debug("Killing Process Tree for PID {}", (Object)pid);
        List<String> children = RunMiNiFi.getChildProcesses(pid);
        logger.debug("Children of PID {}: {}", new Object[]{pid, children});
        for (String childPid : children) {
            this.killProcessTree(childPid, logger);
        }
        Runtime.getRuntime().exec(new String[]{"kill", "-9", pid});
    }

    public static boolean isAlive(Process process) {
        try {
            process.exitValue();
            return false;
        }
        catch (IllegalStateException | IllegalThreadStateException itse) {
            return true;
        }
    }

    private String getHostname() {
        String hostname = "Unknown Host";
        String ip = "Unknown IP Address";
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            hostname = localhost.getHostName();
            ip = localhost.getHostAddress();
        }
        catch (Exception e) {
            this.defaultLogger.warn("Failed to obtain hostname for notification due to:", (Throwable)e);
        }
        return hostname + " (" + ip + ")";
    }

    private int getGracefulShutdownSeconds(Map<String, String> props, File bootstrapConfigAbsoluteFile) {
        int gracefulShutdownSeconds;
        String gracefulShutdown = props.get(GRACEFUL_SHUTDOWN_PROP);
        if (gracefulShutdown == null) {
            gracefulShutdown = DEFAULT_GRACEFUL_SHUTDOWN_VALUE;
        }
        try {
            gracefulShutdownSeconds = Integer.parseInt(gracefulShutdown);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException("The 'graceful.shutdown.seconds' property in Bootstrap Config File " + bootstrapConfigAbsoluteFile.getAbsolutePath() + " has an invalid value. Must be a non-negative integer");
        }
        if (gracefulShutdownSeconds < 0) {
            throw new NumberFormatException("The 'graceful.shutdown.seconds' property in Bootstrap Config File " + bootstrapConfigAbsoluteFile.getAbsolutePath() + " has an invalid value. Must be a non-negative integer");
        }
        return gracefulShutdownSeconds;
    }

    private Map<String, String> readProperties() throws IOException {
        if (!this.bootstrapConfigFile.exists()) {
            throw new FileNotFoundException(this.bootstrapConfigFile.getAbsolutePath());
        }
        Properties properties = new Properties();
        try (FileInputStream fis = new FileInputStream(this.bootstrapConfigFile);){
            properties.load(fis);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.putAll(properties);
        return props;
    }

    public Tuple<ProcessBuilder, Process> startMiNiFi() throws IOException, InterruptedException {
        String javaHome;
        Integer port = this.getCurrentPort(this.cmdLogger);
        if (port != null) {
            this.cmdLogger.info("Apache MiNiFi is already running, listening to Bootstrap on port " + port);
            return null;
        }
        File prevLockFile = this.getLockFile(this.cmdLogger);
        if (prevLockFile.exists() && !prevLockFile.delete()) {
            this.cmdLogger.warn("Failed to delete previous lock file {}; this file should be cleaned up manually", (Object)prevLockFile);
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        Map<String, String> props = this.readProperties();
        String specifiedWorkingDir = props.get("working.dir");
        if (specifiedWorkingDir != null) {
            builder.directory(new File(specifiedWorkingDir));
        }
        File bootstrapConfigAbsoluteFile = this.bootstrapConfigFile.getAbsoluteFile();
        File binDir = bootstrapConfigAbsoluteFile.getParentFile();
        File workingDir = binDir.getParentFile();
        if (specifiedWorkingDir == null) {
            builder.directory(workingDir);
        }
        String minifiLogDir = this.replaceNull(System.getProperty("org.apache.nifi.minifi.bootstrap.config.log.dir"), DEFAULT_LOG_DIR).trim();
        String libFilename = this.replaceNull(props.get("lib.dir"), "./lib").trim();
        File libDir = this.getFile(libFilename, workingDir);
        String confFilename = this.replaceNull(props.get(CONF_DIR_KEY), "./conf").trim();
        File confDir = this.getFile(confFilename, workingDir);
        String minifiPropsFilename = props.get("props.file");
        if (minifiPropsFilename == null) {
            minifiPropsFilename = confDir.exists() ? new File(confDir, "nifi.properties").getAbsolutePath() : DEFAULT_CONFIG_FILE;
        }
        minifiPropsFilename = minifiPropsFilename.trim();
        ArrayList<File[]> javaAdditionalArgs = new ArrayList<File[]>();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String key = entry.getKey();
            File[] value = entry.getValue();
            if (!key.startsWith("java.arg")) continue;
            javaAdditionalArgs.add(value);
        }
        File[] libFiles = libDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.toLowerCase().endsWith(".jar");
            }
        });
        if (libFiles == null || libFiles.length == 0) {
            throw new RuntimeException("Could not find lib directory at " + libDir.getAbsolutePath());
        }
        File[] confFiles = confDir.listFiles();
        if (confFiles == null || confFiles.length == 0) {
            throw new RuntimeException("Could not find conf directory at " + confDir.getAbsolutePath());
        }
        ArrayList<String> cpFiles = new ArrayList<String>(confFiles.length + libFiles.length);
        cpFiles.add(confDir.getAbsolutePath());
        for (File file : libFiles) {
            cpFiles.add(file.getAbsolutePath());
        }
        StringBuilder classPathBuilder = new StringBuilder();
        for (int i = 0; i < cpFiles.size(); ++i) {
            String filename = (String)cpFiles.get(i);
            classPathBuilder.append(filename);
            if (i >= cpFiles.size() - 1) continue;
            classPathBuilder.append(File.pathSeparatorChar);
        }
        String classPath = classPathBuilder.toString();
        String javaCmd = props.get(DEFAULT_JAVA_CMD);
        if (javaCmd == null) {
            javaCmd = DEFAULT_JAVA_CMD;
        }
        if (javaCmd.equals(DEFAULT_JAVA_CMD) && (javaHome = System.getenv("JAVA_HOME")) != null) {
            String fileExtension = this.isWindows() ? ".exe" : "";
            File javaFile = new File(javaHome + File.separatorChar + DEFAULT_PID_DIR + File.separatorChar + DEFAULT_JAVA_CMD + fileExtension);
            if (javaFile.exists() && javaFile.canExecute()) {
                javaCmd = javaFile.getAbsolutePath();
            }
        }
        MiNiFiListener listener = new MiNiFiListener();
        int listenPort = listener.start(this);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(javaCmd);
        cmd.add("-classpath");
        cmd.add(classPath);
        cmd.addAll(javaAdditionalArgs);
        cmd.add("-Dnifi.properties.file.path=" + minifiPropsFilename);
        cmd.add("-Dnifi.bootstrap.listen.port=" + listenPort);
        cmd.add("-Dapp=MiNiFi");
        cmd.add("-Dorg.apache.nifi.minifi.bootstrap.config.log.dir=" + minifiLogDir);
        cmd.add("org.apache.nifi.minifi.MiNiFi");
        builder.command(cmd);
        StringBuilder cmdBuilder = new StringBuilder();
        for (String s : cmd) {
            cmdBuilder.append(s).append(" ");
        }
        this.cmdLogger.info("Starting Apache MiNiFi...");
        this.cmdLogger.info("Working Directory: {}", (Object)workingDir.getAbsolutePath());
        this.cmdLogger.info("Command: {}", (Object)cmdBuilder.toString());
        Process process = builder.start();
        this.handleLogging(process);
        Long pid = OSUtils.getProcessId((Process)process, (Logger)this.cmdLogger);
        if (pid != null) {
            this.minifiPid = pid;
            Properties minifiProps = new Properties();
            minifiProps.setProperty(PID_KEY, String.valueOf(this.minifiPid));
            this.saveProperties(minifiProps, this.cmdLogger);
        }
        this.gracefulShutdownSeconds = this.getGracefulShutdownSeconds(props, bootstrapConfigAbsoluteFile);
        this.shutdownHook = new ShutdownHook(process, this, this.secretKey, this.gracefulShutdownSeconds, this.loggingExecutor);
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(this.shutdownHook);
        return new Tuple((Object)builder, (Object)process);
    }

    public void start() throws IOException, InterruptedException {
        String confDir = this.getBootstrapProperties().getProperty(CONF_DIR_KEY);
        File configFile = new File(this.getBootstrapProperties().getProperty(MINIFI_CONFIG_FILE_KEY));
        try (FileInputStream inputStream = new FileInputStream(configFile);){
            ByteBuffer tempConfigFile = this.performTransformation(inputStream, confDir);
            this.currentConfigFileReference.set(tempConfigFile.asReadOnlyBuffer());
        }
        catch (ConfigurationChangeException e) {
            this.defaultLogger.error("The config file is malformed, unable to start.", (Throwable)e);
            return;
        }
        this.changeListener = new MiNiFiConfigurationChangeListener(this, this.defaultLogger);
        this.periodicStatusReporters = this.initializePeriodicNotifiers();
        this.startPeriodicNotifiers();
        try {
            this.changeCoordinator = this.initializeNotifier(this.changeListener);
        }
        catch (Exception e) {
            String errorMsg = "Unable to start as {} is not properly configured due to: {}";
            this.cmdLogger.error("Unable to start as {} is not properly configured due to: {}", (Object)this.changeListener.getDescriptor(), (Object)e.getMessage());
            this.defaultLogger.error("Unable to initialize notifier.", (Throwable)e);
            System.exit(1);
        }
        Tuple<ProcessBuilder, Process> tuple = this.startMiNiFi();
        if (tuple == null) {
            this.cmdLogger.info("Start method returned null, ending start command.");
            return;
        }
        ProcessBuilder builder = (ProcessBuilder)tuple.getKey();
        Process process = (Process)tuple.getValue();
        try {
            while (true) {
                boolean alive;
                if (alive = RunMiNiFi.isAlive(process)) {
                    try {
                        Thread.sleep(1000L);
                        if (!this.reloading.get() || !this.getNifiStarted()) continue;
                        File swapConfigFile = this.getSwapFile(this.defaultLogger);
                        if (swapConfigFile.exists()) {
                            this.defaultLogger.info("MiNiFi has finished reloading successfully and swap file exists. Deleting old configuration.");
                            if (swapConfigFile.delete()) {
                                this.defaultLogger.info("Swap file was successfully deleted.");
                            } else {
                                this.defaultLogger.error("Swap file was not deleted. It should be deleted manually.");
                            }
                        }
                        this.reloading.set(false);
                    }
                    catch (InterruptedException swapConfigFile) {}
                    continue;
                }
                Runtime runtime = Runtime.getRuntime();
                try {
                    runtime.removeShutdownHook(this.shutdownHook);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                if (this.autoRestartNiFi) {
                    File statusFile = this.getStatusFile(this.defaultLogger);
                    if (!statusFile.exists()) {
                        this.defaultLogger.info("Status File no longer exists. Will not restart MiNiFi");
                        return;
                    }
                    File lockFile = this.getLockFile(this.defaultLogger);
                    if (lockFile.exists()) {
                        this.defaultLogger.info("A shutdown was initiated. Will not restart MiNiFi");
                        return;
                    }
                    File reloadFile = this.getReloadFile(this.defaultLogger);
                    if (reloadFile.exists()) {
                        this.defaultLogger.info("Currently reloading configuration. Will wait to restart MiNiFi.");
                        Thread.sleep(5000L);
                        continue;
                    }
                    boolean previouslyStarted = this.getNifiStarted();
                    if (!previouslyStarted) {
                        File swapConfigFile = this.getSwapFile(this.defaultLogger);
                        if (swapConfigFile.exists()) {
                            this.defaultLogger.info("Swap file exists, MiNiFi failed trying to change configuration. Reverting to old configuration.");
                            try {
                                ByteBuffer tempConfigFile = this.performTransformation(new FileInputStream(swapConfigFile), confDir);
                                this.currentConfigFileReference.set(tempConfigFile.asReadOnlyBuffer());
                            }
                            catch (ConfigurationChangeException e) {
                                this.defaultLogger.error("The swap file is malformed, unable to restart from prior state. Will not attempt to restart MiNiFi. Swap File should be cleaned up manually.");
                                this.shutdownChangeNotifier();
                                this.shutdownPeriodicStatusReporters();
                                return;
                            }
                            Files.copy(swapConfigFile.toPath(), Paths.get(this.getBootstrapProperties().getProperty(MINIFI_CONFIG_FILE_KEY), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                            this.defaultLogger.info("Replacing config file with swap file and deleting swap file");
                            if (!swapConfigFile.delete()) {
                                this.defaultLogger.warn("The swap file failed to delete after replacing using it to revert to the old configuration. It should be cleaned up manually.");
                            }
                        } else {
                            this.defaultLogger.info("MiNiFi either never started or failed to restart. Will not attempt to restart MiNiFi");
                            return;
                        }
                        this.reloading.set(false);
                    } else {
                        this.setNiFiStarted(false);
                    }
                    this.secretKey = null;
                    process = builder.start();
                    this.handleLogging(process);
                    Long pid = OSUtils.getProcessId((Process)process, (Logger)this.defaultLogger);
                    if (pid != null) {
                        this.minifiPid = pid;
                        Properties minifiProps = new Properties();
                        minifiProps.setProperty(PID_KEY, String.valueOf(this.minifiPid));
                        this.saveProperties(minifiProps, this.defaultLogger);
                    }
                    this.shutdownHook = new ShutdownHook(process, this, this.secretKey, this.gracefulShutdownSeconds, this.loggingExecutor);
                    runtime.addShutdownHook(this.shutdownHook);
                    boolean started = this.waitForStart();
                    if (started) {
                        this.defaultLogger.info("Successfully spawned the thread to start Apache MiNiFi{}", (Object)(pid == null ? "" : " with PID " + pid));
                        continue;
                    }
                    this.defaultLogger.error("Apache MiNiFi does not appear to have started");
                    continue;
                }
                return;
            }
        }
        finally {
            this.shutdownChangeNotifier();
            this.shutdownPeriodicStatusReporters();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public FlowStatusReport getFlowStatusReport(String statusRequest, int port, String secretKey, Logger logger) throws IOException {
        logger.debug("Pinging {}", (Object)port);
        try {
            Throwable throwable = null;
            try (Socket socket = new Socket("localhost", port);){
                OutputStream out = socket.getOutputStream();
                String commandWithArgs = "FLOW_STATUS_REPORT " + secretKey + " " + statusRequest + "\n";
                out.write(commandWithArgs.getBytes(StandardCharsets.UTF_8));
                logger.debug("Sending command to MiNiFi: {}", (Object)commandWithArgs);
                out.flush();
                logger.debug("Sent FLOW_STATUS_REPORT_CMD to MiNiFi");
                socket.setSoTimeout(5000);
                InputStream in = socket.getInputStream();
                ObjectInputStream ois = new ObjectInputStream(in);
                logger.debug("FLOW_STATUS_REPORT_CMD response received");
                Object o = ois.readObject();
                ois.close();
                out.close();
                try {
                    FlowStatusReport flowStatusReport = (FlowStatusReport)FlowStatusReport.class.cast(o);
                    return flowStatusReport;
                }
                catch (ClassCastException e) {
                    FlowStatusReport flowStatusReport;
                    block19: {
                        block20: {
                            String message = (String)String.class.cast(o);
                            FlowStatusReport flowStatusReport2 = new FlowStatusReport();
                            flowStatusReport2.setErrorsGeneratingReport(Collections.singletonList("Failed to get status report from MiNiFi due to:" + message));
                            flowStatusReport = flowStatusReport2;
                            if (socket == null) break block19;
                            if (throwable == null) break block20;
                            try {
                                socket.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block19;
                        }
                        socket.close();
                    }
                    return flowStatusReport;
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                }
            }
        }
        catch (EOFException | ClassNotFoundException | SocketTimeoutException e) {
            throw new IllegalStateException("Failed to get the status report from the MiNiFi process. Potentially due to the process currently being down (restarting or otherwise).", e);
        }
    }

    private void handleLogging(final Process process) {
        Set<Future<?>> existingFutures = this.loggingFutures;
        if (existingFutures != null) {
            for (Future<?> future : existingFutures) {
                future.cancel(false);
            }
        }
        Future<?> stdOutFuture = this.loggingExecutor.submit(new Runnable(){

            @Override
            public void run() {
                Logger stdOutLogger = LoggerFactory.getLogger((String)"org.apache.nifi.minifi.StdOut");
                InputStream in = process.getInputStream();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        stdOutLogger.info(line);
                    }
                }
                catch (IOException e) {
                    RunMiNiFi.this.defaultLogger.error("Failed to read from MiNiFi's Standard Out stream", (Throwable)e);
                }
            }
        });
        Future<?> stdErrFuture = this.loggingExecutor.submit(new Runnable(){

            @Override
            public void run() {
                Logger stdErrLogger = LoggerFactory.getLogger((String)"org.apache.nifi.minifi.StdErr");
                InputStream in = process.getErrorStream();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        stdErrLogger.error(line);
                    }
                }
                catch (IOException e) {
                    RunMiNiFi.this.defaultLogger.error("Failed to read from MiNiFi's Standard Error stream", (Throwable)e);
                }
            }
        });
        HashSet futures = new HashSet();
        futures.add(stdOutFuture);
        futures.add(stdErrFuture);
        this.loggingFutures = futures;
    }

    private boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.toLowerCase().contains("win");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForStart() {
        this.lock.lock();
        try {
            long startTime = System.nanoTime();
            while (this.ccPort < 1) {
                try {
                    this.startupCondition.await(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ie) {
                    boolean bl = false;
                    this.lock.unlock();
                    return bl;
                }
                long waitNanos = System.nanoTime() - startTime;
                long waitSeconds = TimeUnit.NANOSECONDS.toSeconds(waitNanos);
                if (waitSeconds <= 60L) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    private File getFile(String filename, File workingDir) {
        File file = new File(filename);
        if (!file.isAbsolute()) {
            file = new File(workingDir, filename);
        }
        return file;
    }

    private String replaceNull(String value, String replacement) {
        return value == null ? replacement : value;
    }

    void setAutoRestartNiFi(boolean restart) {
        this.autoRestartNiFi = restart;
    }

    void setMiNiFiCommandControlPort(int port, String secretKey) throws IOException {
        if (this.secretKey != null && this.ccPort != -1) {
            this.defaultLogger.warn("Blocking attempt to change MiNiFi command port and secret after they have already been initialized. requestedPort={}", (Object)port);
            return;
        }
        this.ccPort = port;
        this.secretKey = secretKey;
        if (this.shutdownHook != null) {
            this.shutdownHook.setSecretKey(secretKey);
        }
        File statusFile = this.getStatusFile(this.defaultLogger);
        Properties minifiProps = new Properties();
        if (this.minifiPid != -1L) {
            minifiProps.setProperty(PID_KEY, String.valueOf(this.minifiPid));
        }
        minifiProps.setProperty("port", String.valueOf(this.ccPort));
        minifiProps.setProperty("secret.key", secretKey);
        try {
            this.saveProperties(minifiProps, this.defaultLogger);
        }
        catch (IOException ioe) {
            this.defaultLogger.warn("Apache MiNiFi has started but failed to persist MiNiFi Port information to {} due to {}", new Object[]{statusFile.getAbsolutePath(), ioe});
        }
        this.defaultLogger.info("The thread to run Apache MiNiFi is now running and listening for Bootstrap requests on port {}", (Object)port);
    }

    int getNiFiCommandControlPort() {
        return this.ccPort;
    }

    void setNiFiStarted(boolean nifiStarted) {
        this.startedLock.lock();
        try {
            this.nifiStarted = nifiStarted;
        }
        finally {
            this.startedLock.unlock();
        }
    }

    boolean getNifiStarted() {
        this.startedLock.lock();
        try {
            boolean bl = this.nifiStarted;
            return bl;
        }
        finally {
            this.startedLock.unlock();
        }
    }

    public void shutdownChangeNotifier() {
        try {
            this.getChangeCoordinator().close();
        }
        catch (IOException e) {
            this.defaultLogger.warn("Could not successfully stop notifier ", (Throwable)e);
        }
    }

    public ConfigurationChangeCoordinator getChangeCoordinator() {
        return this.changeCoordinator;
    }

    private ConfigurationChangeCoordinator initializeNotifier(ConfigurationChangeListener configChangeListener) throws IOException {
        Properties bootstrapProperties = this.getBootstrapProperties();
        ConfigurationChangeCoordinator notifier = new ConfigurationChangeCoordinator();
        notifier.initialize(bootstrapProperties, this, Collections.singleton(configChangeListener));
        notifier.start();
        return notifier;
    }

    public Set<PeriodicStatusReporter> getPeriodicStatusReporters() {
        return Collections.unmodifiableSet(this.periodicStatusReporters);
    }

    public void shutdownPeriodicStatusReporters() {
        for (PeriodicStatusReporter periodicStatusReporter : this.getPeriodicStatusReporters()) {
            try {
                periodicStatusReporter.stop();
            }
            catch (Exception exception) {
                System.out.println("Could not successfully stop periodic status reporter " + periodicStatusReporter.getClass() + " due to " + exception);
            }
        }
    }

    private Set<PeriodicStatusReporter> initializePeriodicNotifiers() throws IOException {
        HashSet<PeriodicStatusReporter> statusReporters = new HashSet<PeriodicStatusReporter>();
        Properties bootstrapProperties = this.getBootstrapProperties();
        String reportersCsv = bootstrapProperties.getProperty("nifi.minifi.status.reporter.components");
        if (reportersCsv != null && !reportersCsv.isEmpty()) {
            for (String reporterClassname : Arrays.asList(reportersCsv.split(","))) {
                try {
                    Class<?> reporterClass = Class.forName(reporterClassname);
                    PeriodicStatusReporter reporter = (PeriodicStatusReporter)reporterClass.newInstance();
                    reporter.initialize(bootstrapProperties, this);
                    statusReporters.add(reporter);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException("Issue instantiating notifier " + reporterClassname, e);
                }
            }
        }
        return statusReporters;
    }

    private void startPeriodicNotifiers() throws IOException {
        for (PeriodicStatusReporter periodicStatusReporter : this.periodicStatusReporters) {
            periodicStatusReporter.start();
        }
    }

    /*
     * Exception decompiling
     */
    private ByteBuffer performTransformation(InputStream configIs, String configDestinationPath) throws ConfigurationChangeException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class Status {
        private final Integer port;
        private final String pid;
        private final Boolean respondingToPing;
        private final Boolean processRunning;

        public Status(Integer port, String pid, Boolean respondingToPing, Boolean processRunning) {
            this.port = port;
            this.pid = pid;
            this.respondingToPing = respondingToPing;
            this.processRunning = processRunning;
        }

        public String getPid() {
            return this.pid;
        }

        public Integer getPort() {
            return this.port;
        }

        public boolean isRespondingToPing() {
            return Boolean.TRUE.equals(this.respondingToPing);
        }

        public boolean isProcessRunning() {
            return Boolean.TRUE.equals(this.processRunning);
        }
    }

    private static class MiNiFiConfigurationChangeListener
    implements ConfigurationChangeListener {
        private final RunMiNiFi runner;
        private final Logger logger;
        private static final ReentrantLock handlingLock = new ReentrantLock();

        public MiNiFiConfigurationChangeListener(RunMiNiFi runner, Logger logger) {
            this.runner = runner;
            this.logger = logger;
        }

        @Override
        public void handleChange(InputStream configInputStream) throws ConfigurationChangeException {
            this.logger.info("Received notification of a change");
            if (!handlingLock.tryLock()) {
                throw new ConfigurationChangeException("Instance is already handling another change");
            }
            try {
                Properties bootstrapProperties = this.runner.getBootstrapProperties();
                File configFile = new File(bootstrapProperties.getProperty(RunMiNiFi.MINIFI_CONFIG_FILE_KEY));
                ByteArrayOutputStream bufferedConfigOs = new ByteArrayOutputStream();
                byte[] copyArray = new byte[1024];
                int available = -1;
                while ((available = configInputStream.read(copyArray)) > 0) {
                    bufferedConfigOs.write(copyArray, 0, available);
                }
                try (ByteArrayInputStream newConfigBais = new ByteArrayInputStream(bufferedConfigOs.toByteArray());){
                    newConfigBais.mark(-1);
                    File swapConfigFile = this.runner.getSwapFile(this.logger);
                    this.logger.info("Persisting old configuration to {}", (Object)swapConfigFile.getAbsolutePath());
                    try (FileInputStream configFileInputStream = new FileInputStream(configFile);){
                        Files.copy(configFileInputStream, swapConfigFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    try {
                        this.logger.info("Persisting changes to {}", (Object)configFile.getAbsolutePath());
                        this.saveFile(newConfigBais, configFile);
                        String confDir = bootstrapProperties.getProperty(RunMiNiFi.CONF_DIR_KEY);
                        try {
                            newConfigBais.reset();
                            this.logger.info("Performing transformation for input and saving outputs to {}", (Object)confDir);
                            ByteBuffer tempConfigFile = this.runner.performTransformation(newConfigBais, confDir);
                            this.runner.currentConfigFileReference.set(tempConfigFile.asReadOnlyBuffer());
                            try {
                                this.logger.info("Reloading instance with new configuration");
                                this.restartInstance();
                            }
                            catch (Exception e) {
                                this.logger.debug("Transformation of new config file failed after transformation into Flow.xml and nifi.properties, reverting.");
                                ByteBuffer resetConfigFile = this.runner.performTransformation(new FileInputStream(swapConfigFile), confDir);
                                this.runner.currentConfigFileReference.set(resetConfigFile.asReadOnlyBuffer());
                                throw e;
                            }
                        }
                        catch (Exception e) {
                            this.logger.debug("Transformation of new config file failed after replacing original with the swap file, reverting.");
                            Files.copy(new FileInputStream(swapConfigFile), configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            throw e;
                        }
                    }
                    catch (Exception e) {
                        this.logger.debug("Transformation of new config file failed after swap file was created, deleting it.");
                        if (!swapConfigFile.delete()) {
                            this.logger.warn("The swap file failed to delete after a failed handling of a change. It should be cleaned up manually.");
                        }
                        throw e;
                    }
                }
            }
            catch (ConfigurationChangeException e) {
                this.logger.error("Unable to carry out reloading of configuration on receipt of notification event", (Throwable)e);
                throw e;
            }
            catch (IOException ioe) {
                this.logger.error("Unable to carry out reloading of configuration on receipt of notification event", (Throwable)ioe);
                throw new ConfigurationChangeException("Unable to perform reload of received configuration change", ioe);
            }
            finally {
                try {
                    if (configInputStream != null) {
                        configInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                handlingLock.unlock();
            }
        }

        @Override
        public String getDescriptor() {
            return "MiNiFiConfigurationChangeListener";
        }

        private void saveFile(InputStream configInputStream, File configFile) throws IOException {
            try (FileOutputStream configFileOutputStream = new FileOutputStream(configFile);){
                byte[] copyArray = new byte[1024];
                int available = -1;
                while ((available = configInputStream.read(copyArray)) > 0) {
                    configFileOutputStream.write(copyArray, 0, available);
                }
            }
            catch (IOException ioe) {
                throw new IOException("Unable to save updated configuration to the configured config file location", ioe);
            }
        }

        private void restartInstance() throws IOException {
            try {
                this.runner.reload();
            }
            catch (IOException e) {
                throw new IOException("Unable to successfully restart MiNiFi instance after configuration change.", e);
            }
        }
    }
}

